/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ParameterDeclaration;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public final class TemplatesAnalysisBuildItem
extends SimpleBuildItem {
    private final List<TemplateAnalysis> analysis;

    public TemplatesAnalysisBuildItem(List<TemplateAnalysis> analysis) {
        this.analysis = analysis;
    }

    public List<TemplateAnalysis> getAnalysis() {
        return this.analysis;
    }

    public static final class TemplateAnalysis {
        public final String id;
        public final String generatedId;
        public final List<Expression> expressions;
        public final List<ParameterDeclaration> parameterDeclarations;
        public final String path;
        public final Set<String> fragmentIds;
        private final Template template;

        TemplateAnalysis(String id, Template template, String path) {
            this.id = id;
            this.generatedId = template.getGeneratedId();
            this.expressions = template.getExpressions();
            this.parameterDeclarations = template.getParameterDeclarations();
            this.path = path;
            this.fragmentIds = template.getFragmentIds();
            this.template = template;
        }

        public List<TemplateNode> getNodes() {
            return this.template.getNodes();
        }

        public Collection<TemplateNode> findNodes(Predicate<TemplateNode> predicate) {
            return this.template.findNodes(predicate);
        }

        public List<ParameterDeclaration> getSortedParameterDeclarations() {
            return TemplateAnalysis.getSortedParameterDeclarations(this.parameterDeclarations);
        }

        public static List<ParameterDeclaration> getSortedParameterDeclarations(List<ParameterDeclaration> parameterDeclarations) {
            ArrayList<ParameterDeclaration> ret = new ArrayList<ParameterDeclaration>(parameterDeclarations);
            ret.sort(new Comparator<ParameterDeclaration>(){

                @Override
                public int compare(ParameterDeclaration pd1, ParameterDeclaration pd2) {
                    int ret = Boolean.compare(pd1.getOrigin().isSynthetic(), pd2.getOrigin().isSynthetic());
                    return ret == 0 ? Integer.compare(pd1.getOrigin().getLine(), pd2.getOrigin().getLine()) : ret;
                }
            });
            return ret;
        }

        Expression findExpression(int id) {
            for (Expression expression : this.expressions) {
                if (expression.getGeneratedId() != id) continue;
                return expression;
            }
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.generatedId == null ? 0 : this.generatedId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TemplateAnalysis other = (TemplateAnalysis)obj;
            return Objects.equals(this.generatedId, other.generatedId);
        }
    }
}

