/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime;

import io.quarkus.qute.Expression;
import io.quarkus.qute.RawString;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.Variant;
import java.util.Objects;
import java.util.Optional;

class HtmlEscaper
implements ResultMapper {
    HtmlEscaper() {
    }

    public boolean appliesTo(TemplateNode.Origin origin, Object result) {
        if (result instanceof RawString) {
            return false;
        }
        Optional variant = origin.getVariant();
        if (variant.isPresent()) {
            return HtmlEscaper.requiresDefaultEscaping((Variant)variant.get());
        }
        return false;
    }

    public String map(Object result, Expression expression) {
        return this.escape(result.toString());
    }

    String escape(CharSequence value) {
        if (Objects.requireNonNull(value).length() == 0) {
            return value.toString();
        }
        for (int i = 0; i < value.length(); ++i) {
            String replacement = this.replacementFor(value.charAt(i));
            if (replacement == null) continue;
            return this.doEscape(value, i, new StringBuilder(value.subSequence(0, i)).append(replacement));
        }
        return value.toString();
    }

    static boolean requiresDefaultEscaping(Variant variant) {
        return variant.mediaType != null ? "text/html".equals(variant.mediaType) || "text/xml".equals(variant.mediaType) : false;
    }

    private String doEscape(CharSequence value, int index, StringBuilder builder) {
        int length = value.length();
        while (++index < length) {
            char c = value.charAt(index);
            String replacement = this.replacementFor(c);
            if (replacement != null) {
                builder.append(replacement);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private String replacementFor(char c) {
        switch (c) {
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&#39;";
            }
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
        }
        return null;
    }
}

