/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime.extensions;

import io.quarkus.qute.Results;
import io.quarkus.qute.TemplateExtension;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.enterprise.inject.Vetoed;

@Vetoed
@TemplateExtension
public class CollectionTemplateExtensions {
    static <T> T get(List<T> list, int index) {
        return list.get(index);
    }

    @TemplateExtension(matchRegex="\\d{1,10}")
    static <T> T getByIndex(List<T> list, String index) {
        int idx = Integer.parseInt(index);
        if (idx >= list.size()) {
            return (T)Results.Result.NOT_FOUND;
        }
        return list.get(idx);
    }

    static <T> Iterator<T> reversed(List<T> list) {
        final ListIterator<T> it = list.listIterator(list.size());
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return it.hasPrevious();
            }

            @Override
            public T next() {
                return it.previous();
            }
        };
    }
}

