/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.HtmlEscaper;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ParserHook;
import io.quarkus.qute.Qute;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.Resolver;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.Results;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.UserTagSectionHelper;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.ValueResolvers;
import io.quarkus.qute.Variant;
import io.quarkus.qute.runtime.ContentTypes;
import io.quarkus.qute.runtime.PropertyNotFoundNoop;
import io.quarkus.qute.runtime.PropertyNotFoundOutputOriginal;
import io.quarkus.qute.runtime.PropertyNotFoundThrowException;
import io.quarkus.qute.runtime.QuteConfig;
import io.quarkus.qute.runtime.QuteRecorder;
import io.quarkus.qute.runtime.QuteRuntimeConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.Startup;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Startup(value=0)
@Singleton
public class EngineProducer {
    public static final String INJECT_NAMESPACE = "inject";
    public static final String CDI_NAMESPACE = "cdi";
    private static final String TAGS = "tags/";
    private static final Logger LOGGER = Logger.getLogger(EngineProducer.class);
    private final Engine engine;
    private final ContentTypes contentTypes;
    private final List<String> tags;
    private final List<String> suffixes;
    private final String basePath;
    private final String tagPath;
    private final Pattern templatePathExclude;
    private final Locale defaultLocale;
    private final Charset defaultCharset;

    public EngineProducer(QuteRecorder.QuteContext context, QuteConfig config, QuteRuntimeConfig runtimeConfig, Event<EngineBuilder> builderReady, Event<Engine> engineReady, ContentTypes contentTypes, LaunchMode launchMode, LocalesBuildTimeConfig locales) {
        this.contentTypes = contentTypes;
        this.suffixes = config.suffixes;
        this.basePath = "templates/";
        this.tagPath = this.basePath + TAGS;
        this.tags = context.getTags();
        this.templatePathExclude = config.templatePathExclude;
        this.defaultLocale = locales.defaultLocale;
        this.defaultCharset = config.defaultCharset;
        LOGGER.debugf("Initializing Qute [templates: %s, tags: %s, resolvers: %s", context.getTemplatePaths(), this.tags, context.getResolverClasses());
        EngineBuilder builder = Engine.builder();
        builder.addValueResolver(ValueResolvers.thisResolver());
        builder.addValueResolver(ValueResolvers.orResolver());
        builder.addValueResolver(ValueResolvers.trueResolver());
        builder.addValueResolver(ValueResolvers.collectionResolver());
        builder.addValueResolver(ValueResolvers.mapperResolver());
        builder.addValueResolver(ValueResolvers.mapEntryResolver());
        builder.addValueResolver(ValueResolvers.rawResolver());
        builder.addValueResolver(ValueResolvers.logicalAndResolver());
        builder.addValueResolver(ValueResolvers.logicalOrResolver());
        builder.addValueResolver(ValueResolvers.orEmpty());
        builder.addValueResolver(ValueResolvers.arrayResolver());
        if (runtimeConfig.strictRendering) {
            builder.strictRendering(true);
        } else {
            builder.strictRendering(false);
            if (runtimeConfig.propertyNotFoundStrategy.isPresent()) {
                switch (runtimeConfig.propertyNotFoundStrategy.get()) {
                    case THROW_EXCEPTION: {
                        builder.addResultMapper((ResultMapper)new PropertyNotFoundThrowException());
                        break;
                    }
                    case NOOP: {
                        builder.addResultMapper((ResultMapper)new PropertyNotFoundNoop());
                        break;
                    }
                    case OUTPUT_ORIGINAL: {
                        builder.addResultMapper((ResultMapper)new PropertyNotFoundOutputOriginal());
                        break;
                    }
                }
            } else if (launchMode == LaunchMode.DEVELOPMENT) {
                builder.addResultMapper((ResultMapper)new PropertyNotFoundThrowException());
            }
        }
        builder.addResultMapper((ResultMapper)new HtmlEscaper(List.copyOf(config.escapeContentTypes)));
        builder.addValueResolver((ValueResolver)new ReflectionValueResolver());
        builder.removeStandaloneLines(runtimeConfig.removeStandaloneLines);
        builder.iterationMetadataPrefix(config.iterationMetadataPrefix);
        builder.addDefaultSectionHelpers();
        builderReady.fire((Object)builder);
        Function<EvalContext, Object> cdiFun = new Function<EvalContext, Object>(){

            @Override
            public Object apply(EvalContext ctx) {
                try (InstanceHandle bean = Arc.container().instance(ctx.getName());){
                    Object object = bean.isAvailable() ? bean.get() : Results.NotFound.from((EvalContext)ctx);
                    return object;
                }
            }
        };
        builder.addNamespaceResolver(NamespaceResolver.builder((String)INJECT_NAMESPACE).resolve((Function)cdiFun).build());
        builder.addNamespaceResolver(NamespaceResolver.builder((String)CDI_NAMESPACE).resolve((Function)cdiFun).build());
        for (String resolverClass : context.getResolverClasses()) {
            Resolver resolver = this.createResolver(resolverClass);
            if (resolver instanceof NamespaceResolver) {
                builder.addNamespaceResolver((NamespaceResolver)resolver);
            } else {
                builder.addValueResolver((ValueResolver)resolver);
            }
            LOGGER.debugf("Added generated value resolver: %s", (Object)resolverClass);
        }
        for (String tag : this.tags) {
            String tagName = tag.contains(".") ? tag.substring(0, tag.lastIndexOf(46)) : tag;
            String tagTemplateId = TAGS + tagName;
            LOGGER.debugf("Registered UserTagSectionHelper for %s [%s]", (Object)tagName, (Object)tagTemplateId);
            builder.addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory(tagName, tagTemplateId));
        }
        builder.addLocator(this::locate);
        builder.addParserHook((ParserHook)new Qute.IndexedArgumentsParserHook());
        for (String initializerClass : context.getTemplateInstanceInitializerClasses()) {
            builder.addTemplateInstanceInitializer(this.createInitializer(initializerClass));
        }
        this.engine = builder.build();
        for (String path : context.getTemplatePaths()) {
            this.engine.getTemplate(path);
        }
        engineReady.fire((Object)this.engine);
        Qute.setEngine((Engine)this.engine);
    }

    @Produces
    @ApplicationScoped
    Engine getEngine() {
        return this.engine;
    }

    void onShutdown(@Observes ShutdownEvent event) {
        Qute.clearCache();
    }

    String getBasePath() {
        return this.basePath;
    }

    String getTagPath() {
        return this.tagPath;
    }

    private Resolver createResolver(String resolverClassName) {
        try {
            Class<?> resolverClazz = Thread.currentThread().getContextClassLoader().loadClass(resolverClassName);
            if (Resolver.class.isAssignableFrom(resolverClazz)) {
                return (Resolver)resolverClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            throw new IllegalStateException("Not a resolver: " + resolverClassName);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create resolver: " + resolverClassName, e);
        }
    }

    private TemplateInstance.Initializer createInitializer(String initializerClassName) {
        try {
            Class<?> initializerClazz = Thread.currentThread().getContextClassLoader().loadClass(initializerClassName);
            if (TemplateInstance.Initializer.class.isAssignableFrom(initializerClazz)) {
                return (TemplateInstance.Initializer)initializerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            throw new IllegalStateException("Not an initializer: " + initializerClazz);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create initializer: " + initializerClassName, e);
        }
    }

    private Optional<TemplateLocator.TemplateLocation> locate(String path) {
        URL resource = null;
        String templatePath = this.basePath + path;
        LOGGER.debugf("Locate template for %s", (Object)templatePath);
        if (this.templatePathExclude.matcher(path).matches()) {
            return Optional.empty();
        }
        resource = this.locatePath(templatePath);
        if (resource == null) {
            String suffix;
            String pathWithSuffix;
            Iterator<String> iterator = this.suffixes.iterator();
            while (iterator.hasNext() && (this.templatePathExclude.matcher(pathWithSuffix = path + "." + (suffix = iterator.next())).matches() || (resource = this.locatePath(templatePath = this.basePath + pathWithSuffix)) == null)) {
            }
        }
        if (resource != null) {
            return Optional.of(new ResourceTemplateLocation(resource, this.createVariant(templatePath)));
        }
        return Optional.empty();
    }

    private URL locatePath(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = EngineProducer.class.getClassLoader();
        }
        return cl.getResource(path);
    }

    Variant createVariant(String path) {
        String contentType = this.contentTypes.getContentType(path);
        return new Variant(this.defaultLocale, this.defaultCharset, contentType);
    }

    static class ResourceTemplateLocation
    implements TemplateLocator.TemplateLocation {
        private final URL resource;
        private final Optional<Variant> variant;

        public ResourceTemplateLocation(URL resource, Variant variant) {
            this.resource = resource;
            this.variant = Optional.ofNullable(variant);
        }

        public Reader read() {
            Charset charset = null;
            if (this.variant.isPresent()) {
                charset = this.variant.get().getCharset();
            }
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
            try {
                return new InputStreamReader(this.resource.openStream(), charset);
            }
            catch (IOException e) {
                return null;
            }
        }

        public Optional<Variant> getVariant() {
            return this.variant;
        }
    }
}

