/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime;

import io.quarkus.arc.All;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.FragmentNamespaceResolver;
import io.quarkus.qute.HtmlEscaper;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.JsonEscaper;
import io.quarkus.qute.NamedArgument;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ParserHook;
import io.quarkus.qute.Qute;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.Resolver;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.Results;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.StrEvalNamespaceResolver;
import io.quarkus.qute.StringTemplateLocation;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateGlobalProvider;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.UserTagSectionHelper;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.ValueResolvers;
import io.quarkus.qute.Variant;
import io.quarkus.qute.runtime.ContentTypes;
import io.quarkus.qute.runtime.PropertyNotFoundNoop;
import io.quarkus.qute.runtime.PropertyNotFoundOutputOriginal;
import io.quarkus.qute.runtime.PropertyNotFoundThrowException;
import io.quarkus.qute.runtime.QuteConfig;
import io.quarkus.qute.runtime.QuteRecorder;
import io.quarkus.qute.runtime.QuteRuntimeConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.Startup;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

@Startup(value=0)
@Singleton
public class EngineProducer {
    public static final String INJECT_NAMESPACE = "inject";
    public static final String CDI_NAMESPACE = "cdi";
    public static final String DEPENDENT_INSTANCES = "q_dep_inst";
    public static final String TAGS = "tags/";
    private static final Logger LOGGER = Logger.getLogger(EngineProducer.class);
    private final Engine engine;
    private final ContentTypes contentTypes;
    private final List<String> suffixes;
    private final Set<String> templateRoots;
    private final Map<String, QuteRecorder.TemplateInfo> templates;
    private final List<Pattern> templatePathExcludes;
    private final Locale defaultLocale;
    private final Charset defaultCharset;
    private final ArcContainer container;

    public EngineProducer(QuteRecorder.QuteContext context, QuteConfig config, QuteRuntimeConfig runtimeConfig, Event<EngineBuilder> builderReady, Event<Engine> engineReady, ContentTypes contentTypes, LaunchMode launchMode, LocalesBuildTimeConfig locales, @All List<TemplateLocator> locators, @All List<SectionHelperFactory<?>> sectionHelperFactories, @All List<ValueResolver> valueResolvers, @All List<NamespaceResolver> namespaceResolvers, @All List<ParserHook> parserHooks) {
        this.contentTypes = contentTypes;
        this.suffixes = config.suffixes();
        this.templateRoots = context.getTemplateRoots();
        this.templates = context.getTemplates();
        this.defaultLocale = locales.defaultLocale().orElse(Locale.getDefault());
        this.defaultCharset = config.defaultCharset();
        this.container = Arc.container();
        ImmutableList.Builder excludesBuilder = ImmutableList.builder().add((Object)config.templatePathExclude());
        for (String string : context.getExcludePatterns()) {
            excludesBuilder.add((Object)Pattern.compile(string));
        }
        this.templatePathExcludes = excludesBuilder.build();
        LOGGER.debugf("Initializing Qute [templates: %s, resolvers: %s", this.templates.keySet(), context.getResolverClasses());
        EngineBuilder builder = Engine.builder();
        builder.addValueResolver(ValueResolvers.thisResolver());
        builder.addValueResolver(ValueResolvers.orResolver());
        builder.addValueResolver(ValueResolvers.trueResolver());
        builder.addValueResolver(ValueResolvers.collectionResolver());
        builder.addValueResolver(ValueResolvers.mapperResolver());
        builder.addValueResolver(ValueResolvers.mapEntryResolver());
        builder.addValueResolver(ValueResolvers.rawResolver());
        builder.addValueResolver(ValueResolvers.logicalAndResolver());
        builder.addValueResolver(ValueResolvers.logicalOrResolver());
        builder.addValueResolver(ValueResolvers.orEmpty());
        builder.addValueResolver(ValueResolvers.arrayResolver());
        builder.addValueResolver((ValueResolver)new NamedArgument.SetValueResolver());
        for (ValueResolver valueResolver : valueResolvers) {
            builder.addValueResolver(valueResolver);
        }
        if (runtimeConfig.strictRendering()) {
            builder.strictRendering(true);
        } else {
            builder.strictRendering(false);
            if (runtimeConfig.propertyNotFoundStrategy().isPresent()) {
                switch (runtimeConfig.propertyNotFoundStrategy().get()) {
                    case THROW_EXCEPTION: {
                        builder.addResultMapper((ResultMapper)new PropertyNotFoundThrowException());
                        break;
                    }
                    case NOOP: {
                        builder.addResultMapper((ResultMapper)new PropertyNotFoundNoop());
                        break;
                    }
                    case OUTPUT_ORIGINAL: {
                        builder.addResultMapper((ResultMapper)new PropertyNotFoundOutputOriginal());
                        break;
                    }
                }
            } else if (launchMode == LaunchMode.DEVELOPMENT) {
                builder.addResultMapper((ResultMapper)new PropertyNotFoundThrowException());
            }
        }
        builder.addResultMapper((ResultMapper)new HtmlEscaper(List.copyOf(config.escapeContentTypes())));
        builder.addResultMapper((ResultMapper)new JsonEscaper());
        builder.addValueResolver((ValueResolver)new ReflectionValueResolver());
        builder.removeStandaloneLines(runtimeConfig.removeStandaloneLines());
        builder.iterationMetadataPrefix(config.iterationMetadataPrefix());
        builder.addDefaultSectionHelpers();
        for (SectionHelperFactory<?> sectionHelperFactory : sectionHelperFactories) {
            builder.addSectionHelper(sectionHelperFactory);
        }
        builderReady.fire((Object)builder);
        builder.addNamespaceResolver(NamespaceResolver.builder((String)INJECT_NAMESPACE).resolve(this::resolveInject).build());
        builder.addNamespaceResolver(NamespaceResolver.builder((String)CDI_NAMESPACE).resolve(this::resolveInject).build());
        for (NamespaceResolver namespaceResolver : namespaceResolvers) {
            builder.addNamespaceResolver(namespaceResolver);
        }
        builder.addNamespaceResolver((NamespaceResolver)new StrEvalNamespaceResolver());
        builder.addNamespaceResolver((NamespaceResolver)new NamedArgument.ParamNamespaceResolver());
        builder.addNamespaceResolver((NamespaceResolver)new FragmentNamespaceResolver("fragment"));
        builder.addNamespaceResolver((NamespaceResolver)new FragmentNamespaceResolver("frg"));
        builder.addNamespaceResolver((NamespaceResolver)new FragmentNamespaceResolver("capture"));
        builder.addNamespaceResolver((NamespaceResolver)new FragmentNamespaceResolver("cap"));
        for (String resolverClass : context.getResolverClasses()) {
            Resolver resolver = this.createResolver(resolverClass);
            if (resolver instanceof NamespaceResolver) {
                builder.addNamespaceResolver((NamespaceResolver)resolver);
            } else {
                builder.addValueResolver((ValueResolver)resolver);
            }
            LOGGER.debugf("Added generated value resolver: %s", (Object)resolverClass);
        }
        for (String tag : context.getTags()) {
            String tagName = tag.contains(".") ? tag.substring(0, tag.indexOf(46)) : tag;
            String string = TAGS + tagName;
            LOGGER.debugf("Registered UserTagSectionHelper for %s [%s]", (Object)tagName, (Object)string);
            builder.addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory(tagName, string));
        }
        builder.addLocator(this::locate);
        this.registerCustomLocators(builder, locators);
        for (ParserHook parserHook : parserHooks) {
            builder.addParserHook(parserHook);
        }
        builder.addParserHook((ParserHook)new Qute.IndexedArgumentsParserHook());
        for (String globalProviderClass : context.getTemplateGlobalProviderClasses()) {
            TemplateGlobalProvider provider = this.createGlobalProvider(globalProviderClass);
            builder.addTemplateInstanceInitializer((TemplateInstance.Initializer)provider);
            builder.addNamespaceResolver((NamespaceResolver)provider);
        }
        final HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        builder.addTemplateInstanceInitializer(new TemplateInstance.Initializer(){

            public void accept(final TemplateInstance instance) {
                Boolean hasInject = (Boolean)hashMap.get(instance.getTemplate().getGeneratedId());
                if (hasInject == null) {
                    hasInject = EngineProducer.this.hasInjectExpression(instance.getTemplate());
                }
                if (hasInject.booleanValue()) {
                    instance.setAttribute(EngineProducer.DEPENDENT_INSTANCES, new ConcurrentHashMap());
                    instance.onRendered(new Runnable(){

                        @Override
                        public void run() {
                            ConcurrentMap existing;
                            Object dependentInstances = instance.getAttribute(EngineProducer.DEPENDENT_INSTANCES);
                            if (dependentInstances != null && !(existing = (ConcurrentMap)dependentInstances).isEmpty()) {
                                for (InstanceHandle handle : existing.values()) {
                                    handle.close();
                                }
                            }
                        }
                    });
                }
            }
        });
        builder.timeout(runtimeConfig.timeout());
        builder.useAsyncTimeout(runtimeConfig.useAsyncTimeout());
        this.engine = builder.build();
        HashMap<String, ArrayList<Template>> discovered = new HashMap<String, ArrayList<Template>>();
        for (QuteRecorder.TemplateInfo templateInfo : context.getTemplates().values()) {
            String path;
            Template template;
            if (templateInfo.isTag() || (template = this.engine.getTemplate(path = templateInfo.path)) == null) continue;
            for (String suffix : config.suffixes()) {
                if (!path.endsWith(suffix)) continue;
                String pathNoSuffix = path.substring(0, path.length() - (suffix.length() + 1));
                ArrayList<Template> templates = (ArrayList<Template>)discovered.get(pathNoSuffix);
                if (templates == null) {
                    templates = new ArrayList<Template>();
                    discovered.put(pathNoSuffix, templates);
                }
                templates.add(template);
                break;
            }
            hashMap.put(template.getGeneratedId(), this.hasInjectExpression(template));
        }
        for (Map.Entry entry : discovered.entrySet()) {
            this.processDefaultTemplate((String)entry.getKey(), (List)entry.getValue(), config, this.engine);
        }
        engineReady.fire((Object)this.engine);
        Qute.setEngine((Engine)this.engine);
    }

    private void registerCustomLocators(EngineBuilder builder, List<TemplateLocator> locators) {
        if (locators != null && !locators.isEmpty()) {
            for (TemplateLocator locator : locators) {
                builder.addLocator(locator);
            }
        }
    }

    @Produces
    @ApplicationScoped
    Engine getEngine() {
        return this.engine;
    }

    void onShutdown(@Observes ShutdownEvent event) {
        Qute.clearCache();
    }

    private Resolver createResolver(String resolverClassName) {
        try {
            Class<?> resolverClazz = Thread.currentThread().getContextClassLoader().loadClass(resolverClassName);
            if (Resolver.class.isAssignableFrom(resolverClazz)) {
                return (Resolver)resolverClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            throw new IllegalStateException("Not a resolver: " + resolverClassName);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create resolver: " + resolverClassName, e);
        }
    }

    private TemplateGlobalProvider createGlobalProvider(String initializerClassName) {
        try {
            Class<?> initializerClazz = Thread.currentThread().getContextClassLoader().loadClass(initializerClassName);
            if (TemplateGlobalProvider.class.isAssignableFrom(initializerClazz)) {
                return (TemplateGlobalProvider)initializerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            throw new IllegalStateException("Not a global provider: " + String.valueOf(initializerClazz));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create global provider: " + initializerClassName, e);
        }
    }

    private boolean isExcluded(String path) {
        for (Pattern p : this.templatePathExcludes) {
            if (!p.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    private Optional<TemplateLocator.TemplateLocation> locate(String path) {
        if (this.isExcluded(path)) {
            return Optional.empty();
        }
        LOGGER.debugf("Locate template contents for %s", (Object)path);
        QuteRecorder.TemplateInfo template = this.templates.get(path);
        if (template != null && template.hasContent()) {
            return this.getTemplateLocation(template.content, path);
        }
        for (String suffix : this.suffixes) {
            String pathWithSuffix = path + "." + suffix;
            if (this.isExcluded(pathWithSuffix) || (template = this.templates.get(pathWithSuffix)) == null || !template.hasContent()) continue;
            return this.getTemplateLocation(template.content, pathWithSuffix);
        }
        for (String templateRoot : this.templateRoots) {
            URL resource = null;
            String templatePath = templateRoot + path;
            LOGGER.debugf("Locate template file for %s", (Object)templatePath);
            resource = this.locatePath(templatePath);
            if (resource != null) {
                return this.getTemplateLocation(resource, templatePath, path);
            }
            for (String suffix : this.suffixes) {
                String pathWithSuffix = path + "." + suffix;
                if (this.isExcluded(pathWithSuffix) || (resource = this.locatePath(templatePath = templateRoot + pathWithSuffix)) == null) continue;
                return this.getTemplateLocation(resource, templatePath, pathWithSuffix);
            }
        }
        return Optional.empty();
    }

    private Optional<TemplateLocator.TemplateLocation> getTemplateLocation(String content, String pathWithSuffix) {
        return Optional.of(new StringTemplateLocation(content, Optional.ofNullable(this.createVariant(pathWithSuffix))));
    }

    private Optional<TemplateLocator.TemplateLocation> getTemplateLocation(URL resource, String templatePath, String path) {
        URI source = null;
        QuteRecorder.TemplateInfo template = this.templates.get(path);
        if (template != null) {
            source = template.parseSource();
        }
        return Optional.of(new ResourceTemplateLocation(resource, this.createVariant(templatePath), source));
    }

    private URL locatePath(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = EngineProducer.class.getClassLoader();
        }
        return cl.getResource(path);
    }

    Variant createVariant(String path) {
        String contentType = this.contentTypes.getContentType(path);
        return new Variant(this.defaultLocale, this.defaultCharset, contentType);
    }

    private Object resolveInject(EvalContext ctx) {
        InjectableBean bean = this.container.namedBean(ctx.getName());
        if (bean != null) {
            Object dependentInstances;
            if (bean.getScope().equals(Dependent.class) && (dependentInstances = ctx.getAttribute(DEPENDENT_INSTANCES)) != null) {
                ConcurrentMap existing = (ConcurrentMap)dependentInstances;
                return existing.computeIfAbsent(ctx.getName(), name -> this.container.instance(bean)).get();
            }
            return this.container.instance(bean).get();
        }
        return Results.NotFound.from((EvalContext)ctx);
    }

    private boolean hasInjectExpression(Template template) {
        for (Expression expression : template.getExpressions()) {
            if (!this.isInjectExpression(expression)) continue;
            return true;
        }
        return false;
    }

    private boolean isInjectExpression(Expression expression) {
        String namespace = expression.getNamespace();
        if (namespace != null && (CDI_NAMESPACE.equals(namespace) || INJECT_NAMESPACE.equals(namespace))) {
            return true;
        }
        for (Expression.Part part : expression.getParts()) {
            if (!part.isVirtualMethod()) continue;
            for (Expression param : part.asVirtualMethod().getParameters()) {
                if (param.isLiteral() || !this.isInjectExpression(param)) continue;
                return true;
            }
        }
        return false;
    }

    private void processDefaultTemplate(String path, List<Template> templates, QuteConfig config, Engine engine) {
        if (engine.isTemplateLoaded(path)) {
            return;
        }
        for (String suffix : config.suffixes()) {
            for (Template template : templates) {
                if (!template.getId().endsWith(suffix)) continue;
                engine.putTemplate(path, template);
                return;
            }
        }
    }

    static class ResourceTemplateLocation
    implements TemplateLocator.TemplateLocation {
        private final URL resource;
        private final Optional<Variant> variant;
        private final Optional<URI> source;

        ResourceTemplateLocation(URL resource, Variant variant, URI source) {
            this.resource = resource;
            this.variant = Optional.ofNullable(variant);
            this.source = Optional.ofNullable(source);
        }

        public Reader read() {
            Charset charset = null;
            if (this.variant.isPresent()) {
                charset = this.variant.get().getCharset();
            }
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
            try {
                return new InputStreamReader(this.resource.openStream(), charset);
            }
            catch (IOException e) {
                return null;
            }
        }

        public Optional<Variant> getVariant() {
            return this.variant;
        }

        public Optional<URI> getSource() {
            return this.source;
        }
    }
}

