/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.annotations.RecordableConstructor;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

@Recorder
public class QuteRecorder {
    public Supplier<Object> createContext(final Map<String, List<String>> variants, final Set<String> templateRoots, final List<String> excludePatterns, final Map<String, TemplateInfo> templates) {
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return new QuteContext(){
                    volatile List<String> resolverClasses;
                    volatile List<String> templateGlobalProviderClasses;

                    @Override
                    public Map<String, TemplateInfo> getTemplates() {
                        return templates;
                    }

                    @Override
                    public List<String> getResolverClasses() {
                        if (this.resolverClasses == null) {
                            throw this.generatedClassesNotInitialized();
                        }
                        return this.resolverClasses;
                    }

                    @Override
                    public Map<String, List<String>> getVariants() {
                        return variants;
                    }

                    @Override
                    public List<String> getTemplateGlobalProviderClasses() {
                        if (this.templateGlobalProviderClasses == null) {
                            throw this.generatedClassesNotInitialized();
                        }
                        return this.templateGlobalProviderClasses;
                    }

                    @Override
                    public Set<String> getTemplateRoots() {
                        return templateRoots;
                    }

                    @Override
                    public List<String> getExcludePatterns() {
                        return excludePatterns;
                    }

                    @Override
                    public void setGeneratedClasses(List<String> resolverClasses, List<String> templateGlobalProviderClasses) {
                        this.resolverClasses = resolverClasses;
                        this.templateGlobalProviderClasses = templateGlobalProviderClasses;
                    }

                    private IllegalStateException generatedClassesNotInitialized() {
                        return new IllegalStateException("Generated classes not initialized yet!");
                    }
                };
            }
        };
    }

    public void initializeGeneratedClasses(List<String> resolverClasses, List<String> templateGlobalProviderClasses) {
        QuteContext context = (QuteContext)Arc.container().instance(QuteContext.class, new Annotation[0]).get();
        context.setGeneratedClasses(resolverClasses, templateGlobalProviderClasses);
    }

    public static interface QuteContext {
        public List<String> getResolverClasses();

        public Map<String, TemplateInfo> getTemplates();

        public Map<String, List<String>> getVariants();

        public List<String> getTemplateGlobalProviderClasses();

        public Set<String> getTemplateRoots();

        public List<String> getExcludePatterns();

        public void setGeneratedClasses(List<String> var1, List<String> var2);

        default public List<String> getTags() {
            ArrayList<String> ret = new ArrayList<String>();
            for (TemplateInfo template : this.getTemplates().values()) {
                if (!template.isTag()) continue;
                ret.add(template.path.substring("tags/".length(), template.path.length()));
            }
            return ret;
        }
    }

    public static class TemplateInfo {
        public final String path;
        public final String source;
        public final String content;

        @RecordableConstructor
        public TemplateInfo(String path, String source, String content) {
            this.path = path;
            this.source = source;
            this.content = content;
        }

        public boolean isTag() {
            return this.path.startsWith("tags/");
        }

        public boolean hasContent() {
            return this.content != null;
        }

        public URI parseSource() {
            if (this.source != null) {
                try {
                    return new URI(this.source);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return null;
        }

        public String toString() {
            return "TemplateInfo [path=" + this.path + ", source=" + this.source + "]";
        }
    }
}

