/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime.debug;

import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.debug.adapter.RegisterDebugServerAdapter;
import io.quarkus.qute.runtime.QuteConfig;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.common.annotation.Experimental;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Singleton;

@Singleton
@Experimental(value="This observer is experimental and may change in the future")
public class DebugQuteEngineObserver {
    private static final RegisterDebugServerAdapter registrar = new RegisterDebugServerAdapter();

    void configureEngine(@Observes EngineBuilder builder, QuteConfig config) {
        if (LaunchMode.current() == LaunchMode.DEVELOPMENT && config.debug().enabled() && registrar.getPort() != null) {
            builder.enableTracing(true);
            builder.addEngineListener((EngineBuilder.EngineListener)registrar);
        }
    }

    @PreDestroy
    void cleanup() {
        if (LaunchMode.current() == LaunchMode.DEVELOPMENT) {
            registrar.reset();
        }
    }
}

