/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.datasource.runtime;

import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.inject.spi.Bean;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.jboss.logging.Logger;

public abstract class ReactiveDatasourceHealthCheck
implements HealthCheck {
    private static final Logger log = Logger.getLogger(ReactiveDatasourceHealthCheck.class);
    private final Map<String, Pool> pools = new ConcurrentHashMap<String, Pool>();
    private final String healthCheckResponseName;
    private final String healthCheckSQL;

    protected ReactiveDatasourceHealthCheck(String healthCheckResponseName, String healthCheckSQL) {
        this.healthCheckResponseName = healthCheckResponseName;
        this.healthCheckSQL = healthCheckSQL;
    }

    protected void addPool(String name, Pool p) {
        Pool previous = this.pools.put(name, p);
        if (previous != null) {
            throw new IllegalStateException("Duplicate pool name: " + name);
        }
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)this.healthCheckResponseName);
        builder.up();
        for (Map.Entry<String, Pool> pgPoolEntry : this.pools.entrySet()) {
            String dataSourceName = pgPoolEntry.getKey();
            Pool pgPool = pgPoolEntry.getValue();
            try {
                CompletableFuture databaseConnectionAttempt = new CompletableFuture();
                Context context = Vertx.currentContext();
                if (context != null) {
                    log.debug((Object)"Run health check on the current Vert.x context");
                    context.runOnContext(v -> pgPool.query(this.healthCheckSQL).execute(ar -> {
                        this.checkFailure((AsyncResult<RowSet<Row>>)ar, builder, dataSourceName);
                        databaseConnectionAttempt.complete(null);
                    }));
                } else {
                    log.warn((Object)("Vert.x context unavailable to perform healthcheck of reactive datasource `" + dataSourceName + "`. This is unlikely to work correctly."));
                    pgPool.query(this.healthCheckSQL).execute(ar -> {
                        this.checkFailure((AsyncResult<RowSet<Row>>)ar, builder, dataSourceName);
                        databaseConnectionAttempt.complete(null);
                    });
                }
                databaseConnectionAttempt.get(20L, TimeUnit.SECONDS);
                builder.withData(dataSourceName, "up");
            }
            catch (RuntimeException | ExecutionException exception) {
                this.operationsError(dataSourceName, exception);
                builder.down();
                builder.withData(dataSourceName, "down - connection failed: " + exception.getMessage());
            }
            catch (InterruptedException e) {
                log.warn((Object)("Interrupted while obtaining database connection for healthcheck of datasource " + dataSourceName));
                Thread.currentThread().interrupt();
                return builder.build();
            }
            catch (TimeoutException e) {
                log.warn((Object)("Timed out while waiting for an available connection to perform healthcheck of datasource " + dataSourceName));
                builder.down();
                builder.withData(dataSourceName, "timed out, unable to obtain connection to perform healthcheck of datasource");
            }
        }
        return builder.build();
    }

    private void operationsError(String datasourceName, Throwable cause) {
        log.warn((Object)("Error obtaining database connection for healthcheck of datasource '" + datasourceName + '\''), cause);
    }

    private void checkFailure(AsyncResult<RowSet<Row>> ar, HealthCheckResponseBuilder builder, String dataSourceName) {
        if (ar.failed()) {
            this.operationsError(dataSourceName, ar.cause());
            builder.down();
            builder.withData(dataSourceName, "down - connection failed: " + ar.cause().getMessage());
        }
    }

    protected String getPoolName(Bean<?> bean) {
        for (Object qualifier : bean.getQualifiers()) {
            if (!(qualifier instanceof ReactiveDataSource)) continue;
            return ((ReactiveDataSource)qualifier).value();
        }
        return "<default>";
    }
}

