/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.datasource.runtime;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveBuildTimeConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Map;

@ConfigRoot(name="datasource", phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public class DataSourcesReactiveBuildTimeConfig {
    @ConfigItem(name="reactive")
    public DataSourceReactiveBuildTimeConfig defaultDataSource;
    @ConfigItem(name="<<parent>>")
    public Map<String, DataSourceReactiveOuterNamedBuildTimeConfig> namedDataSources;

    public DataSourceReactiveBuildTimeConfig getDataSourceReactiveBuildTimeConfig(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.defaultDataSource;
        }
        DataSourceReactiveOuterNamedBuildTimeConfig dataSourceReactiveOuterNamedBuildTimeConfig = this.namedDataSources.get(dataSourceName);
        if (dataSourceReactiveOuterNamedBuildTimeConfig == null) {
            return new DataSourceReactiveBuildTimeConfig();
        }
        return dataSourceReactiveOuterNamedBuildTimeConfig.reactive;
    }

    @ConfigGroup
    public static class DataSourceReactiveOuterNamedBuildTimeConfig {
        @ConfigItem
        public DataSourceReactiveBuildTimeConfig reactive;
    }
}

