/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.db2.client.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.reactive.datasource.deployment.VertxPoolBuildItem;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveBuildTimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.db2.client.deployment.DB2PoolBuildItem;
import io.quarkus.reactive.db2.client.runtime.DB2PoolProducer;
import io.quarkus.reactive.db2.client.runtime.DB2PoolRecorder;
import io.quarkus.reactive.db2.client.runtime.DataSourceReactiveDB2Config;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.vertx.db2client.DB2Pool;
import io.vertx.sqlclient.Pool;
import javax.inject.Singleton;

class ReactiveDB2ClientProcessor {
    ReactiveDB2ClientProcessor() {
    }

    @BuildStep
    void poolProducer(BuildProducer<AdditionalBeanBuildItem> additionalBeans, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourceReactiveBuildTimeConfig dataSourceReactiveBuildTimeConfig) {
        if (!ReactiveDB2ClientProcessor.createPool(dataSourcesBuildTimeConfig, dataSourceReactiveBuildTimeConfig)) {
            return;
        }
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem.Builder().addBeanClass(DB2PoolProducer.class).setUnremovable().setDefaultScope(DotNames.APPLICATION_SCOPED).build());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem build(BuildProducer<FeatureBuildItem> feature, BuildProducer<DB2PoolBuildItem> db2Pool, BuildProducer<VertxPoolBuildItem> vertxPool, DB2PoolRecorder recorder, VertxBuildItem vertx, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, ShutdownContextBuildItem shutdown, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourceReactiveBuildTimeConfig dataSourceReactiveBuildTimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveDB2Config dataSourceReactiveDB2Config) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.REACTIVE_DB2_CLIENT));
        ServiceStartBuildItem serviceStart = new ServiceStartBuildItem("reactive-db2-client");
        if (!ReactiveDB2ClientProcessor.createPool(dataSourcesBuildTimeConfig, dataSourceReactiveBuildTimeConfig)) {
            return serviceStart;
        }
        RuntimeValue db2PoolValue = recorder.configureDB2Pool(vertx.getVertx(), dataSourcesRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveDB2Config, (ShutdownContext)shutdown);
        db2Pool.produce((BuildItem)new DB2PoolBuildItem((RuntimeValue<DB2Pool>)db2PoolValue));
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DB2Pool.class).addType(Pool.class)).scope(Singleton.class)).runtimeValue(db2PoolValue).setRuntimeInit().done());
        boolean isDefault = true;
        vertxPool.produce((BuildItem)new VertxPoolBuildItem(db2PoolValue, "db2", isDefault));
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.REACTIVE_DB2_CLIENT));
        return serviceStart;
    }

    @BuildStep
    void addHealthCheck(BuildProducer<HealthBuildItem> healthChecks, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourceReactiveBuildTimeConfig dataSourceReactiveBuildTimeConfig) {
        if (!ReactiveDB2ClientProcessor.createPool(dataSourcesBuildTimeConfig, dataSourceReactiveBuildTimeConfig)) {
            return;
        }
        healthChecks.produce((BuildItem)new HealthBuildItem("io.quarkus.reactive.db2.client.runtime.health.ReactiveDB2DataSourceHealthCheck", dataSourcesBuildTimeConfig.healthEnabled));
    }

    private static boolean createPool(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourceReactiveBuildTimeConfig dataSourceReactiveBuildTimeConfig) {
        if (!dataSourcesBuildTimeConfig.defaultDataSource.dbKind.isPresent()) {
            return false;
        }
        return DatabaseKind.isDB2((String)((String)dataSourcesBuildTimeConfig.defaultDataSource.dbKind.get())) && dataSourceReactiveBuildTimeConfig.enabled;
    }
}

