/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.db2.client.runtime;

import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.db2.client.runtime.DataSourceReactiveDB2Config;
import io.quarkus.reactive.db2.client.runtime.DataSourcesReactiveDB2Config;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.JksConfiguration;
import io.quarkus.vertx.core.runtime.config.PemKeyCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PemTrustCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PfxConfiguration;
import io.vertx.core.Vertx;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.mutiny.db2client.DB2Pool;
import io.vertx.sqlclient.PoolOptions;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class DB2PoolRecorder {
    private static final Logger log = Logger.getLogger(DB2PoolRecorder.class);

    public RuntimeValue<io.vertx.db2client.DB2Pool> configureDB2Pool(RuntimeValue<Vertx> vertx, Supplier<Integer> eventLoopCount, String dataSourceName, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactiveDB2Config dataSourcesReactiveDB2Config, ShutdownContext shutdown) {
        io.vertx.db2client.DB2Pool db2Pool = this.initialize((Vertx)vertx.getValue(), eventLoopCount.get(), dataSourcesRuntimeConfig.getDataSourceRuntimeConfig(dataSourceName), dataSourcesReactiveRuntimeConfig.getDataSourceReactiveRuntimeConfig(dataSourceName), dataSourcesReactiveDB2Config.getDataSourceReactiveRuntimeConfig(dataSourceName));
        shutdown.addShutdownTask(() -> ((io.vertx.db2client.DB2Pool)db2Pool).close());
        return new RuntimeValue((Object)db2Pool);
    }

    public RuntimeValue<DB2Pool> mutinyDB2Pool(RuntimeValue<io.vertx.db2client.DB2Pool> db2Pool) {
        return new RuntimeValue((Object)DB2Pool.newInstance((io.vertx.db2client.DB2Pool)((io.vertx.db2client.DB2Pool)db2Pool.getValue())));
    }

    private io.vertx.db2client.DB2Pool initialize(Vertx vertx, Integer eventLoopCount, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveDB2Config dataSourceReactiveDB2Config) {
        PoolOptions poolOptions = this.toPoolOptions(eventLoopCount, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveDB2Config);
        DB2ConnectOptions connectOptions = this.toConnectOptions(dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveDB2Config);
        if (dataSourceReactiveRuntimeConfig.threadLocal.isPresent()) {
            log.warn((Object)"Configuration element 'thread-local' on Reactive datasource connections is deprecated and will be ignored. The started pool will always be based on a per-thread separate pool now.");
        }
        return io.vertx.db2client.DB2Pool.pool((Vertx)vertx, (DB2ConnectOptions)connectOptions, (PoolOptions)poolOptions);
    }

    private PoolOptions toPoolOptions(Integer eventLoopCount, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveDB2Config dataSourceReactiveDB2Config) {
        PoolOptions poolOptions = new PoolOptions();
        if (dataSourceReactiveRuntimeConfig.maxSize.isPresent()) {
            poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize.getAsInt());
        }
        if (dataSourceReactiveRuntimeConfig.idleTimeout.isPresent()) {
            int idleTimeout = Math.toIntExact(((Duration)dataSourceReactiveRuntimeConfig.idleTimeout.get()).toMillis());
            poolOptions.setIdleTimeout(idleTimeout).setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        }
        if (dataSourceReactiveRuntimeConfig.shared) {
            poolOptions.setShared(true);
            if (dataSourceReactiveRuntimeConfig.name.isPresent()) {
                poolOptions.setName((String)dataSourceReactiveRuntimeConfig.name.get());
            }
        }
        if (dataSourceReactiveRuntimeConfig.eventLoopSize.isPresent()) {
            poolOptions.setEventLoopSize(Math.max(0, dataSourceReactiveRuntimeConfig.eventLoopSize.getAsInt()));
        } else if (eventLoopCount != null) {
            poolOptions.setEventLoopSize(Math.max(0, eventLoopCount));
        }
        return poolOptions;
    }

    private DB2ConnectOptions toConnectOptions(DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveDB2Config dataSourceReactiveDB2Config) {
        DB2ConnectOptions connectOptions;
        if (dataSourceReactiveRuntimeConfig.url.isPresent()) {
            String url = (String)dataSourceReactiveRuntimeConfig.url.get();
            if (url.matches("^vertx-reactive:db2://.*$")) {
                url = url.substring("vertx-reactive:".length());
            }
            connectOptions = DB2ConnectOptions.fromUri((String)url);
        } else {
            connectOptions = new DB2ConnectOptions();
        }
        if (dataSourceRuntimeConfig.username.isPresent()) {
            connectOptions.setUser((String)dataSourceRuntimeConfig.username.get());
        }
        if (dataSourceRuntimeConfig.password.isPresent()) {
            connectOptions.setPassword((String)dataSourceRuntimeConfig.password.get());
        }
        if (dataSourceRuntimeConfig.credentialsProvider.isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName.orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider.get();
            Map credentials = credentialsProvider.getCredentials(name);
            String user = (String)credentials.get("user");
            String password = (String)credentials.get("password");
            if (user != null) {
                connectOptions.setUser(user);
            }
            if (password != null) {
                connectOptions.setPassword(user);
            }
        }
        if (dataSourceReactiveDB2Config.cachePreparedStatements.isPresent()) {
            log.warn((Object)"datasource.reactive.db2.cache-prepared-statements is deprecated, use datasource.reactive.cache-prepared-statements instead");
            connectOptions.setCachePreparedStatements(dataSourceReactiveDB2Config.cachePreparedStatements.get().booleanValue());
        } else {
            connectOptions.setCachePreparedStatements(dataSourceReactiveRuntimeConfig.cachePreparedStatements);
        }
        connectOptions.setSsl(dataSourceReactiveDB2Config.ssl);
        connectOptions.setTrustAll(dataSourceReactiveRuntimeConfig.trustAll);
        SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)connectOptions, (PemTrustCertConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePem);
        SSLConfigHelper.configureJksTrustOptions((TCPSSLOptions)connectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.trustCertificateJks);
        SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)connectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePfx);
        SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)connectOptions, (PemKeyCertConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePem);
        SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)connectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.keyCertificateJks);
        SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)connectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePfx);
        connectOptions.setReconnectAttempts(dataSourceReactiveRuntimeConfig.reconnectAttempts);
        connectOptions.setReconnectInterval(dataSourceReactiveRuntimeConfig.reconnectInterval.toMillis());
        if (dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm.isPresent()) {
            connectOptions.setHostnameVerificationAlgorithm((String)dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm.get());
        }
        dataSourceReactiveRuntimeConfig.additionalProperties.forEach((arg_0, arg_1) -> ((DB2ConnectOptions)connectOptions).addProperty(arg_0, arg_1));
        return connectOptions;
    }
}

