/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.db2.client.runtime.health;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.runtime.DataSourceSupport;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.vertx.mutiny.db2client.DB2Pool;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
class ReactiveDB2DataSourcesHealthCheck
implements HealthCheck {
    private Map<String, DB2Pool> db2Pools = new HashMap<String, DB2Pool>();

    ReactiveDB2DataSourcesHealthCheck() {
    }

    @PostConstruct
    protected void init() {
        ArcContainer container = Arc.container();
        DataSourceSupport support = (DataSourceSupport)container.instance(DataSourceSupport.class, new Annotation[0]).get();
        Set excludedNames = support.getInactiveOrHealthCheckExcludedNames();
        for (InstanceHandle handle : container.select(DB2Pool.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            String db2PoolName = this.getDB2PoolName((Bean<?>)handle.getBean());
            if (excludedNames.contains(db2PoolName)) continue;
            this.db2Pools.put(db2PoolName, (DB2Pool)handle.get());
        }
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Reactive DB2 connections health check");
        builder.up();
        for (Map.Entry<String, DB2Pool> db2PoolEntry : this.db2Pools.entrySet()) {
            String dataSourceName = db2PoolEntry.getKey();
            DB2Pool db2Pool = db2PoolEntry.getValue();
            try {
                db2Pool.query("SELECT 1 FROM SYSIBM.SYSDUMMY1").execute().await().atMost(Duration.ofSeconds(10L));
                builder.withData(dataSourceName, "up");
            }
            catch (Exception exception) {
                builder.down();
                builder.withData(dataSourceName, "down - connection failed: " + exception.getMessage());
            }
        }
        return builder.build();
    }

    private String getDB2PoolName(Bean<?> bean) {
        for (Object qualifier : bean.getQualifiers()) {
            if (!(qualifier instanceof ReactiveDataSource)) continue;
            return ((ReactiveDataSource)qualifier).value();
        }
        return "<default>";
    }
}

