/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactivemessaging.http.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.reactivemessaging.http.runtime.QuarkusHttpConnector;
import io.quarkus.reactivemessaging.http.runtime.QuarkusWebSocketConnector;
import io.quarkus.reactivemessaging.http.runtime.ReactiveHttpHandlerBean;
import io.quarkus.reactivemessaging.http.runtime.ReactiveHttpRecorder;
import io.quarkus.reactivemessaging.http.runtime.ReactiveWebSocketHandlerBean;
import io.quarkus.reactivemessaging.http.runtime.config.HttpStreamConfig;
import io.quarkus.reactivemessaging.http.runtime.config.ReactiveHttpConfig;
import io.quarkus.reactivemessaging.http.runtime.config.WebSocketStreamConfig;
import io.quarkus.reactivemessaging.http.runtime.converters.JsonArrayConverter;
import io.quarkus.reactivemessaging.http.runtime.converters.JsonObjectConverter;
import io.quarkus.reactivemessaging.http.runtime.converters.ObjectConverter;
import io.quarkus.reactivemessaging.http.runtime.converters.StringConverter;
import io.quarkus.reactivemessaging.http.runtime.serializers.Serializer;
import io.quarkus.reactivemessaging.http.runtime.serializers.SerializerFactoryBase;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.smallrye.mutiny.Multi;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class ReactiveHttpProcessor {
    private static final DotName JSON_ARRAY = DotName.createSimple((String)JsonArray.class.getName());
    private static final DotName JSON_OBJECT = DotName.createSimple((String)JsonObject.class.getName());
    private static final DotName MESSAGE = DotName.createSimple((String)Message.class.getName());
    private static final DotName MULTI = DotName.createSimple((String)Multi.class.getName());
    private static final DotName PROCESSOR = DotName.createSimple((String)Processor.class.getName());
    private static final DotName PROCESSOR_BUILDER = DotName.createSimple((String)ProcessorBuilder.class.getName());
    private static final DotName PUBLISHER = DotName.createSimple((String)Publisher.class.getName());
    private static final DotName PUBLISHER_BUILDER = DotName.createSimple((String)PublisherBuilder.class.getName());
    private static final DotName SUBSCRIBER = DotName.createSimple((String)Subscriber.class.getName());
    private static final DotName SUBSCRIBER_BUILDER = DotName.createSimple((String)SubscriberBuilder.class.getName());

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerHttpConnector(BuildProducer<AdditionalBeanBuildItem> beanProducer, BuildProducer<GeneratedBeanBuildItem> generatedBeanProducer, BuildProducer<RouteBuildItem> routeProducer, BodyHandlerBuildItem bodyHandler, ReactiveHttpRecorder recorder) {
        Handler handler;
        beanProducer.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{QuarkusHttpConnector.class}));
        beanProducer.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{QuarkusWebSocketConnector.class}));
        beanProducer.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ReactiveHttpConfig.class}));
        beanProducer.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ReactiveHttpHandlerBean.class}));
        beanProducer.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ReactiveWebSocketHandlerBean.class}));
        beanProducer.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{JsonArrayConverter.class}));
        beanProducer.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{JsonObjectConverter.class}));
        beanProducer.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ObjectConverter.class}));
        beanProducer.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{StringConverter.class}));
        List httpConfigs = ReactiveHttpConfig.readIncomingHttpConfigs();
        List wsConfigs = ReactiveHttpConfig.readIncomingWebSocketConfigs();
        if (!httpConfigs.isEmpty()) {
            handler = recorder.createHttpHandler();
            httpConfigs.stream().map(HttpStreamConfig::path).distinct().forEach(path -> {
                routeProducer.produce((BuildItem)RouteBuildItem.builder().route(path).handler(bodyHandler.getHandler()).build());
                routeProducer.produce((BuildItem)RouteBuildItem.builder().route(path).handler(handler).build());
            });
        }
        if (!wsConfigs.isEmpty()) {
            handler = recorder.createWebSocketHandler();
            wsConfigs.stream().map(WebSocketStreamConfig::path).distinct().forEach(path -> routeProducer.produce((BuildItem)RouteBuildItem.builder().route(path).handler(handler).build()));
        }
        this.initSerializers(ReactiveHttpConfig.readSerializers(), generatedBeanProducer);
    }

    @BuildStep
    void registerMessagePayloadClassesForReflection(BeanArchiveIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        HashSet<String> payloadClasses = new HashSet<String>();
        for (AnnotationInstance incoming : index.getIndex().getAnnotations(DotName.createSimple((String)Incoming.class.getName()))) {
            ParameterizedType parameterizedType;
            Type returnType;
            List arguments;
            MethodInfo methodInfo = incoming.target().asMethod();
            List parameters = methodInfo.parameters();
            if (parameters.size() == 1) {
                Type type = (Type)parameters.get(0);
                DotName typeName = type.name();
                if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && (typeName.equals((Object)PUBLISHER_BUILDER) || typeName.equals((Object)PUBLISHER) || typeName.equals((Object)MULTI))) {
                    arguments = type.asParameterizedType().arguments();
                    if (arguments.size() <= 0) continue;
                    this.collectPayloadType(payloadClasses, (Type)arguments.get(0));
                    continue;
                }
                this.collectPayloadType(payloadClasses, type);
                continue;
            }
            if (parameters.size() != 0 || !(returnType = methodInfo.returnType()).name().equals((Object)SUBSCRIBER_BUILDER) && !returnType.name().equals((Object)PROCESSOR_BUILDER) && !returnType.name().equals((Object)SUBSCRIBER) && !returnType.name().equals((Object)PROCESSOR) || returnType.kind() != Type.Kind.PARAMETERIZED_TYPE || (arguments = (parameterizedType = returnType.asParameterizedType()).arguments()).size() <= 0) continue;
            this.collectPayloadType(payloadClasses, (Type)arguments.get(0));
        }
        payloadClasses.removeAll(Arrays.asList(JSON_OBJECT.toString(), DotNames.OBJECT.toString(), JSON_ARRAY.toString(), DotNames.STRING.toString()));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, payloadClasses.toArray(new String[0])));
    }

    private void collectPayloadType(Set<String> payloadClasses, Type type) {
        if (type.kind() != Type.Kind.CLASS && type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            return;
        }
        if (type.name().equals((Object)MESSAGE)) {
            Type payloadType;
            if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && (payloadType = (Type)type.asParameterizedType().arguments().get(0)).kind() == Type.Kind.CLASS) {
                payloadClasses.add(payloadType.name().toString());
            }
        } else {
            payloadClasses.add(type.name().toString());
        }
    }

    private void initSerializers(List<String> serializers, BuildProducer<GeneratedBeanBuildItem> generatedBeans) {
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        try (ClassCreator factory = ClassCreator.builder().classOutput((ClassOutput)classOutput).className("io.quarkus.reactivemessaging.http.runtime.serializers.SerializerFactory").superClass(SerializerFactoryBase.class).build();){
            factory.addAnnotation(ApplicationScoped.class);
            try (MethodCreator init = factory.getMethodCreator("initAdditionalSerializers", Void.TYPE, new Class[0]);){
                init.setModifiers(4);
                MethodDescriptor addSerializer = MethodDescriptor.ofMethod(SerializerFactoryBase.class, (String)"addSerializer", Void.TYPE, (Class[])new Class[]{String.class, Serializer.class});
                for (String serializerName : serializers) {
                    ResultHandle serializer = init.newInstance(MethodDescriptor.ofConstructor((String)serializerName, (String[])new String[0]), new ResultHandle[0]);
                    init.invokeVirtualMethod(addSerializer, init.getThis(), new ResultHandle[]{init.load(serializerName), serializer});
                }
                init.returnValue(null);
            }
        }
    }
}

