/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactivemessaging.http.runtime;

import java.util.concurrent.atomic.AtomicInteger;

class StrictQueueSizeGuard {
    private final int queueSize;
    private final AtomicInteger enqueued = new AtomicInteger();

    StrictQueueSizeGuard(int queueSize) {
        this.queueSize = queueSize;
    }

    void dequeue() {
        this.enqueued.decrementAndGet();
    }

    boolean prepareToEmit() {
        int oldVal;
        int newVal;
        while ((newVal = (oldVal = this.enqueued.get()) + 1) <= this.queueSize) {
            if (!this.enqueued.compareAndSet(oldVal, newVal)) continue;
            return true;
        }
        return false;
    }
}

