/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactivemessaging.http.runtime.config;

import io.quarkus.reactivemessaging.http.runtime.config.StreamConfigBase;
import io.vertx.core.http.HttpMethod;
import java.util.Locale;

public class HttpStreamConfig
extends StreamConfigBase {
    public final HttpMethod method;
    public final String path;

    public HttpStreamConfig(String path, String method, String name, int bufferSize) {
        super(bufferSize);
        this.path = path;
        this.method = this.toHttpMethod(method, name);
    }

    public String path() {
        return this.path;
    }

    private HttpMethod toHttpMethod(String method, String connectorName) {
        try {
            return HttpMethod.valueOf((String)method.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid http method '" + method + "' defined for connector " + connectorName);
        }
    }
}

