/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.mysql.client.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.quarkus.reactive.datasource.deployment.VertxPoolBuildItem;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveBuildTimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveBuildTimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.mysql.client.deployment.MySQLPoolBuildItem;
import io.quarkus.reactive.mysql.client.runtime.DataSourcesReactiveMySQLConfig;
import io.quarkus.reactive.mysql.client.runtime.MySQLPoolRecorder;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.vertx.mutiny.mysqlclient.MySQLPool;
import io.vertx.sqlclient.Pool;
import javax.enterprise.context.ApplicationScoped;

class ReactiveMySQLClientProcessor {
    ReactiveMySQLClientProcessor() {
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem build(BuildProducer<FeatureBuildItem> feature, BuildProducer<MySQLPoolBuildItem> mySQLPool, BuildProducer<VertxPoolBuildItem> vertxPool, MySQLPoolRecorder recorder, VertxBuildItem vertx, ShutdownContextBuildItem shutdown, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactiveMySQLConfig dataSourcesReactiveMySQLConfig) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.REACTIVE_MYSQL_CLIENT));
        this.createPoolIfDefined(recorder, vertx, shutdown, mySQLPool, vertxPool, syntheticBeans, "<default>", dataSourcesBuildTimeConfig, dataSourcesRuntimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourcesReactiveRuntimeConfig, dataSourcesReactiveMySQLConfig);
        for (String dataSourceName : dataSourcesBuildTimeConfig.namedDataSources.keySet()) {
            this.createPoolIfDefined(recorder, vertx, shutdown, mySQLPool, vertxPool, syntheticBeans, dataSourceName, dataSourcesBuildTimeConfig, dataSourcesRuntimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourcesReactiveRuntimeConfig, dataSourcesReactiveMySQLConfig);
        }
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.REACTIVE_MYSQL_CLIENT));
        return new ServiceStartBuildItem("reactive-mysql-client");
    }

    @BuildStep
    void addHealthCheck(BuildProducer<HealthBuildItem> healthChecks, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig) {
        if (!this.hasPools(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig)) {
            return;
        }
        healthChecks.produce((BuildItem)new HealthBuildItem("io.quarkus.reactive.mysql.client.runtime.health.ReactiveMySQLDataSourcesHealthCheck", dataSourcesBuildTimeConfig.healthEnabled));
    }

    private void createPoolIfDefined(MySQLPoolRecorder recorder, VertxBuildItem vertx, ShutdownContextBuildItem shutdown, BuildProducer<MySQLPoolBuildItem> mySQLPool, BuildProducer<VertxPoolBuildItem> vertxPool, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, String dataSourceName, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactiveMySQLConfig dataSourcesReactiveMySQLConfig) {
        if (!ReactiveMySQLClientProcessor.isReactiveMySQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourceName)) {
            return;
        }
        RuntimeValue pool = recorder.configureMySQLPool(vertx.getVertx(), dataSourceName, dataSourcesRuntimeConfig, dataSourcesReactiveRuntimeConfig, dataSourcesReactiveMySQLConfig, (ShutdownContext)shutdown);
        mySQLPool.produce((BuildItem)new MySQLPoolBuildItem(dataSourceName, (RuntimeValue<io.vertx.mysqlclient.MySQLPool>)pool));
        SyntheticBeanBuildItem.ExtendedBeanConfigurator mySQLPoolBeanConfigurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(io.vertx.mysqlclient.MySQLPool.class).defaultBean()).addType(Pool.class)).scope(ApplicationScoped.class)).runtimeValue(pool).unremovable()).setRuntimeInit();
        ReactiveMySQLClientProcessor.addQualifiers(mySQLPoolBeanConfigurator, dataSourceName);
        syntheticBeans.produce((BuildItem)mySQLPoolBeanConfigurator.done());
        SyntheticBeanBuildItem.ExtendedBeanConfigurator mutinyMySQLPoolConfigurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MySQLPool.class).defaultBean()).scope(ApplicationScoped.class)).runtimeValue(recorder.mutinyMySQLPool(pool)).setRuntimeInit();
        ReactiveMySQLClientProcessor.addQualifiers(mutinyMySQLPoolConfigurator, dataSourceName);
        syntheticBeans.produce((BuildItem)mutinyMySQLPoolConfigurator.done());
        vertxPool.produce((BuildItem)new VertxPoolBuildItem(pool, "mysql", DataSourceUtil.isDefault((String)dataSourceName)));
    }

    private static boolean isReactiveMySQLPoolDefined(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, String dataSourceName) {
        DataSourceBuildTimeConfig dataSourceBuildTimeConfig = dataSourcesBuildTimeConfig.getDataSourceRuntimeConfig(dataSourceName);
        DataSourceReactiveBuildTimeConfig dataSourceReactiveBuildTimeConfig = dataSourcesReactiveBuildTimeConfig.getDataSourceReactiveBuildTimeConfig(dataSourceName);
        if (!dataSourceBuildTimeConfig.dbKind.isPresent()) {
            return false;
        }
        return (DatabaseKind.isMySQL((String)((String)dataSourceBuildTimeConfig.dbKind.get())) || DatabaseKind.isMariaDB((String)((String)dataSourceBuildTimeConfig.dbKind.get()))) && dataSourceReactiveBuildTimeConfig.enabled;
    }

    private boolean hasPools(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig) {
        if (ReactiveMySQLClientProcessor.isReactiveMySQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, "<default>")) {
            return true;
        }
        for (String dataSourceName : dataSourcesBuildTimeConfig.namedDataSources.keySet()) {
            if (!ReactiveMySQLClientProcessor.isReactiveMySQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourceName)) continue;
            return true;
        }
        return false;
    }

    private static void addQualifiers(SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator, String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            configurator.addQualifier(DotNames.DEFAULT);
        } else {
            configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)dataSourceName).done();
            configurator.addQualifier().annotation(ReactiveDataSource.class).addValue("value", (Object)dataSourceName).done();
        }
    }
}

