/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.mysql.client.runtime;

import io.quarkus.reactive.datasource.runtime.ThreadLocalPool;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Query;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Transaction;

public class ThreadLocalMySQLPool
extends ThreadLocalPool<MySQLPool>
implements MySQLPool {
    private final MySQLConnectOptions mySQLConnectOptions;

    public ThreadLocalMySQLPool(Vertx vertx, MySQLConnectOptions mySQLConnectOptions, PoolOptions poolOptions) {
        super(vertx, poolOptions);
        this.mySQLConnectOptions = mySQLConnectOptions;
    }

    protected MySQLPool createThreadLocalPool() {
        return new MySQLPoolWrapper(MySQLPool.pool((Vertx)this.vertx, (MySQLConnectOptions)this.mySQLConnectOptions, (PoolOptions)this.poolOptions));
    }

    private class MySQLPoolWrapper
    implements MySQLPool {
        private final MySQLPool delegate;
        private boolean open = true;

        private MySQLPoolWrapper(MySQLPool delegate) {
            this.delegate = delegate;
        }

        public void getConnection(Handler<AsyncResult<SqlConnection>> handler) {
            this.delegate.getConnection(handler);
        }

        public Query<RowSet<Row>> query(String s) {
            return this.delegate.query(s);
        }

        public PreparedQuery<RowSet<Row>> preparedQuery(String s) {
            return this.delegate.preparedQuery(s);
        }

        public void begin(Handler<AsyncResult<Transaction>> handler) {
            this.delegate.begin(handler);
        }

        public void close() {
            if (this.open) {
                this.delegate.close();
                ThreadLocalMySQLPool.this.removeSelfFromTracking((Pool)this);
            }
        }
    }
}

