/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.mysql.client.runtime;

import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.datasource.runtime.LegacyDataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.LegacyDataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.mysql.client.runtime.DataSourceReactiveMySQLConfig;
import io.quarkus.reactive.mysql.client.runtime.LegacyDataSourceReactiveMySQLConfig;
import io.quarkus.reactive.mysql.client.runtime.ThreadLocalMySQLPool;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.JksConfiguration;
import io.quarkus.vertx.core.runtime.config.PemKeyCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PemTrustCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PfxConfiguration;
import io.vertx.core.Vertx;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.sqlclient.PoolOptions;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

@Recorder
public class MySQLPoolRecorder {
    private static final Logger log = Logger.getLogger(MySQLPoolRecorder.class);

    public RuntimeValue<MySQLPool> configureMySQLPool(RuntimeValue<Vertx> vertx, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMySQLConfig dataSourceReactiveMySQLConfig, LegacyDataSourcesRuntimeConfig legacyDataSourcesRuntimeConfig, LegacyDataSourceReactiveMySQLConfig legacyDataSourceReactiveMySQLConfig, boolean isLegacy, ShutdownContext shutdown) {
        MySQLPool mysqlPool = !isLegacy ? this.initialize((Vertx)vertx.getValue(), dataSourcesRuntimeConfig.defaultDataSource, dataSourceReactiveRuntimeConfig, dataSourceReactiveMySQLConfig) : this.legacyInitialize((Vertx)vertx.getValue(), dataSourcesRuntimeConfig.defaultDataSource, legacyDataSourcesRuntimeConfig.defaultDataSource, legacyDataSourceReactiveMySQLConfig);
        shutdown.addShutdownTask(() -> ((MySQLPool)mysqlPool).close());
        return new RuntimeValue((Object)mysqlPool);
    }

    private MySQLPool initialize(Vertx vertx, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMySQLConfig dataSourceReactiveMySQLConfig) {
        PoolOptions poolOptions = this.toPoolOptions(dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveMySQLConfig);
        MySQLConnectOptions mysqlConnectOptions = this.toMySQLConnectOptions(dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveMySQLConfig);
        if (dataSourceReactiveRuntimeConfig.threadLocal.isPresent() && ((Boolean)dataSourceReactiveRuntimeConfig.threadLocal.get()).booleanValue()) {
            return new ThreadLocalMySQLPool(vertx, mysqlConnectOptions, poolOptions);
        }
        return MySQLPool.pool((Vertx)vertx, (MySQLConnectOptions)mysqlConnectOptions, (PoolOptions)poolOptions);
    }

    private PoolOptions toPoolOptions(DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMySQLConfig dataSourceReactiveMySQLConfig) {
        PoolOptions poolOptions = new PoolOptions();
        if (dataSourceReactiveRuntimeConfig.maxSize.isPresent()) {
            poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize.getAsInt());
        }
        return poolOptions;
    }

    private MySQLConnectOptions toMySQLConnectOptions(DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMySQLConfig dataSourceReactiveMySQLConfig) {
        MySQLConnectOptions mysqlConnectOptions;
        if (dataSourceReactiveRuntimeConfig.url.isPresent()) {
            String url = (String)dataSourceReactiveRuntimeConfig.url.get();
            if (url.startsWith("vertx-reactive:mysql://")) {
                url = url.substring("vertx-reactive:".length());
            }
            mysqlConnectOptions = MySQLConnectOptions.fromUri((String)url);
        } else {
            mysqlConnectOptions = new MySQLConnectOptions();
        }
        if (dataSourceRuntimeConfig.username.isPresent()) {
            mysqlConnectOptions.setUser((String)dataSourceRuntimeConfig.username.get());
        }
        if (dataSourceRuntimeConfig.password.isPresent()) {
            mysqlConnectOptions.setPassword((String)dataSourceRuntimeConfig.password.get());
        }
        if (dataSourceRuntimeConfig.credentialsProvider.isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName.orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider.get();
            Map credentials = credentialsProvider.getCredentials(name);
            String user = (String)credentials.get("user");
            String password = (String)credentials.get("password");
            if (user != null) {
                mysqlConnectOptions.setUser(user);
            }
            if (password != null) {
                mysqlConnectOptions.setPassword(password);
            }
        }
        if (dataSourceReactiveMySQLConfig.cachePreparedStatements.isPresent()) {
            log.warn((Object)"datasource.reactive.mysql.cache-prepared-statements is deprecated, use datasource.reactive.cache-prepared-statements instead");
            mysqlConnectOptions.setCachePreparedStatements(dataSourceReactiveMySQLConfig.cachePreparedStatements.get().booleanValue());
        } else {
            mysqlConnectOptions.setCachePreparedStatements(dataSourceReactiveRuntimeConfig.cachePreparedStatements);
        }
        if (dataSourceReactiveMySQLConfig.charset.isPresent()) {
            mysqlConnectOptions.setCharset(dataSourceReactiveMySQLConfig.charset.get());
        }
        if (dataSourceReactiveMySQLConfig.collation.isPresent()) {
            mysqlConnectOptions.setCollation(dataSourceReactiveMySQLConfig.collation.get());
        }
        if (dataSourceReactiveMySQLConfig.sslMode.isPresent()) {
            mysqlConnectOptions.setSslMode(dataSourceReactiveMySQLConfig.sslMode.get());
        }
        mysqlConnectOptions.setTrustAll(dataSourceReactiveRuntimeConfig.trustAll);
        SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)mysqlConnectOptions, (PemTrustCertConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePem);
        SSLConfigHelper.configureJksTrustOptions((TCPSSLOptions)mysqlConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.trustCertificateJks);
        SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)mysqlConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePfx);
        SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)mysqlConnectOptions, (PemKeyCertConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePem);
        SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)mysqlConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.keyCertificateJks);
        SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)mysqlConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePfx);
        mysqlConnectOptions.setReconnectAttempts(dataSourceReactiveRuntimeConfig.reconnectAttempts);
        mysqlConnectOptions.setReconnectInterval(dataSourceReactiveRuntimeConfig.reconnectInterval.toMillis());
        if (dataSourceReactiveRuntimeConfig.idleTimeout.isPresent()) {
            int idleTimeout = Math.toIntExact(((Duration)dataSourceReactiveRuntimeConfig.idleTimeout.get()).toMillis());
            mysqlConnectOptions.setIdleTimeout(idleTimeout).setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        }
        return mysqlConnectOptions;
    }

    private MySQLPool legacyInitialize(Vertx vertx, DataSourceRuntimeConfig dataSourceRuntimeConfig, LegacyDataSourceRuntimeConfig legacyDataSourceRuntimeConfig, LegacyDataSourceReactiveMySQLConfig legacyDataSourceReactiveMySQLConfig) {
        PoolOptions poolOptions = this.legacyToPoolOptionsLegacy(legacyDataSourceRuntimeConfig);
        MySQLConnectOptions mysqlConnectOptions = this.legacyToMySQLConnectOptions(dataSourceRuntimeConfig, legacyDataSourceRuntimeConfig, legacyDataSourceReactiveMySQLConfig);
        return MySQLPool.pool((Vertx)vertx, (MySQLConnectOptions)mysqlConnectOptions, (PoolOptions)poolOptions);
    }

    private PoolOptions legacyToPoolOptionsLegacy(LegacyDataSourceRuntimeConfig legacyDataSourceRuntimeConfig) {
        PoolOptions poolOptions = new PoolOptions();
        poolOptions.setMaxSize(legacyDataSourceRuntimeConfig.maxSize);
        return poolOptions;
    }

    private MySQLConnectOptions legacyToMySQLConnectOptions(DataSourceRuntimeConfig dataSourceRuntimeConfig, LegacyDataSourceRuntimeConfig legacyDataSourceRuntimeConfig, LegacyDataSourceReactiveMySQLConfig legacyDataSourceReactiveMySQLConfig) {
        MySQLConnectOptions mysqlConnectOptions;
        if (legacyDataSourceRuntimeConfig.url.isPresent()) {
            String url = (String)legacyDataSourceRuntimeConfig.url.get();
            if (url.startsWith("vertx-reactive:mysql://")) {
                url = url.substring("vertx-reactive:".length());
            }
            mysqlConnectOptions = MySQLConnectOptions.fromUri((String)url);
        } else {
            mysqlConnectOptions = new MySQLConnectOptions();
        }
        if (dataSourceRuntimeConfig.username.isPresent()) {
            mysqlConnectOptions.setUser((String)dataSourceRuntimeConfig.username.get());
        }
        if (dataSourceRuntimeConfig.password.isPresent()) {
            mysqlConnectOptions.setPassword((String)dataSourceRuntimeConfig.password.get());
        }
        if (legacyDataSourceReactiveMySQLConfig.cachePreparedStatements.isPresent()) {
            mysqlConnectOptions.setCachePreparedStatements(legacyDataSourceReactiveMySQLConfig.cachePreparedStatements.get().booleanValue());
        }
        if (legacyDataSourceReactiveMySQLConfig.charset.isPresent()) {
            mysqlConnectOptions.setCharset(legacyDataSourceReactiveMySQLConfig.charset.get());
        }
        if (legacyDataSourceReactiveMySQLConfig.collation.isPresent()) {
            mysqlConnectOptions.setCollation(legacyDataSourceReactiveMySQLConfig.collation.get());
        }
        return mysqlConnectOptions;
    }
}

