/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.mysql.client.runtime.health;

import io.quarkus.arc.Arc;
import io.vertx.mysqlclient.MySQLPool;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class ReactiveMySQLDataSourceHealthCheck
implements HealthCheck {
    private MySQLPool mySQLPool;

    @PostConstruct
    protected void init() {
        this.mySQLPool = (MySQLPool)Arc.container().instance(MySQLPool.class, new Annotation[0]).get();
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Reactive MySQL connection health check").up();
        try {
            CompletableFuture databaseConnectionAttempt = new CompletableFuture();
            this.mySQLPool.query("SELECT 1").execute(ar -> {
                if (ar.failed()) {
                    builder.down();
                }
                databaseConnectionAttempt.complete(null);
            });
            databaseConnectionAttempt.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            builder.down();
        }
        return builder.build();
    }
}

