/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.mysql.client.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.mysql.client.MySQLPoolCreator;
import io.quarkus.reactive.mysql.client.runtime.DataSourceReactiveMySQLConfig;
import io.quarkus.reactive.mysql.client.runtime.DataSourcesReactiveMySQLConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.JksConfiguration;
import io.quarkus.vertx.core.runtime.config.PemKeyCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PemTrustCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PfxConfiguration;
import io.vertx.core.Vertx;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.mutiny.mysqlclient.MySQLPool;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.SslMode;
import io.vertx.sqlclient.PoolOptions;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class MySQLPoolRecorder {
    private static final Logger log = Logger.getLogger(MySQLPoolRecorder.class);

    public RuntimeValue<io.vertx.mysqlclient.MySQLPool> configureMySQLPool(RuntimeValue<Vertx> vertx, Supplier<Integer> eventLoopCount, String dataSourceName, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactiveMySQLConfig dataSourcesReactiveMySQLConfig, ShutdownContext shutdown) {
        io.vertx.mysqlclient.MySQLPool mysqlPool = this.initialize((Vertx)vertx.getValue(), eventLoopCount.get(), dataSourceName, dataSourcesRuntimeConfig.getDataSourceRuntimeConfig(dataSourceName), dataSourcesReactiveRuntimeConfig.getDataSourceReactiveRuntimeConfig(dataSourceName), dataSourcesReactiveMySQLConfig.getDataSourceReactiveRuntimeConfig(dataSourceName));
        shutdown.addShutdownTask(() -> ((io.vertx.mysqlclient.MySQLPool)mysqlPool).close());
        return new RuntimeValue((Object)mysqlPool);
    }

    public RuntimeValue<MySQLPool> mutinyMySQLPool(RuntimeValue<io.vertx.mysqlclient.MySQLPool> mysqlPool) {
        return new RuntimeValue((Object)MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)((io.vertx.mysqlclient.MySQLPool)mysqlPool.getValue())));
    }

    private io.vertx.mysqlclient.MySQLPool initialize(Vertx vertx, Integer eventLoopCount, String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMySQLConfig dataSourceReactiveMySQLConfig) {
        PoolOptions poolOptions = this.toPoolOptions(eventLoopCount, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveMySQLConfig);
        List<MySQLConnectOptions> mysqlConnectOptionsList = this.toMySQLConnectOptions(dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveMySQLConfig);
        mysqlConnectOptionsList.forEach(mysqlConnectOptions -> mysqlConnectOptions.setMetricsName("mysql|" + dataSourceName));
        return this.createPool(vertx, poolOptions, mysqlConnectOptionsList, dataSourceName);
    }

    private PoolOptions toPoolOptions(Integer eventLoopCount, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMySQLConfig dataSourceReactiveMySQLConfig) {
        PoolOptions poolOptions = new PoolOptions();
        poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize);
        if (dataSourceReactiveRuntimeConfig.idleTimeout.isPresent()) {
            int idleTimeout = Math.toIntExact(((Duration)dataSourceReactiveRuntimeConfig.idleTimeout.get()).toMillis());
            poolOptions.setIdleTimeout(idleTimeout).setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        }
        if (dataSourceReactiveRuntimeConfig.shared) {
            poolOptions.setShared(true);
            if (dataSourceReactiveRuntimeConfig.name.isPresent()) {
                poolOptions.setName((String)dataSourceReactiveRuntimeConfig.name.get());
            }
        }
        if (dataSourceReactiveRuntimeConfig.eventLoopSize.isPresent()) {
            poolOptions.setEventLoopSize(Math.max(0, dataSourceReactiveRuntimeConfig.eventLoopSize.getAsInt()));
        } else if (eventLoopCount != null) {
            poolOptions.setEventLoopSize(Math.max(0, eventLoopCount));
        }
        if (dataSourceReactiveMySQLConfig.connectionTimeout.isPresent()) {
            poolOptions.setConnectionTimeout(dataSourceReactiveMySQLConfig.connectionTimeout.getAsInt());
            poolOptions.setConnectionTimeoutUnit(TimeUnit.SECONDS);
        }
        return poolOptions;
    }

    private List<MySQLConnectOptions> toMySQLConnectOptions(DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMySQLConfig dataSourceReactiveMySQLConfig) {
        ArrayList<MySQLConnectOptions> mysqlConnectOptionsList = new ArrayList<MySQLConnectOptions>();
        if (dataSourceReactiveRuntimeConfig.url.isPresent()) {
            List urls = (List)dataSourceReactiveRuntimeConfig.url.get();
            urls.forEach(url -> {
                if (url.startsWith("vertx-reactive:mysql://")) {
                    url = url.substring("vertx-reactive:".length());
                }
                mysqlConnectOptionsList.add(MySQLConnectOptions.fromUri((String)url));
            });
        } else {
            mysqlConnectOptionsList.add(new MySQLConnectOptions());
        }
        mysqlConnectOptionsList.forEach(mysqlConnectOptions -> {
            dataSourceRuntimeConfig.username.ifPresent(arg_0 -> ((MySQLConnectOptions)mysqlConnectOptions).setUser(arg_0));
            dataSourceRuntimeConfig.password.ifPresent(arg_0 -> ((MySQLConnectOptions)mysqlConnectOptions).setPassword(arg_0));
            if (dataSourceRuntimeConfig.credentialsProvider.isPresent()) {
                String beanName = dataSourceRuntimeConfig.credentialsProviderName.orElse(null);
                CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
                String name = (String)dataSourceRuntimeConfig.credentialsProvider.get();
                Map credentials = credentialsProvider.getCredentials(name);
                String user = (String)credentials.get("user");
                String password = (String)credentials.get("password");
                if (user != null) {
                    mysqlConnectOptions.setUser(user);
                }
                if (password != null) {
                    mysqlConnectOptions.setPassword(password);
                }
            }
            mysqlConnectOptions.setCachePreparedStatements(dataSourceReactiveRuntimeConfig.cachePreparedStatements);
            dataSourceReactiveMySQLConfig.charset.ifPresent(arg_0 -> ((MySQLConnectOptions)mysqlConnectOptions).setCharset(arg_0));
            dataSourceReactiveMySQLConfig.collation.ifPresent(arg_0 -> ((MySQLConnectOptions)mysqlConnectOptions).setCollation(arg_0));
            if (dataSourceReactiveMySQLConfig.pipeliningLimit.isPresent()) {
                mysqlConnectOptions.setPipeliningLimit(dataSourceReactiveMySQLConfig.pipeliningLimit.getAsInt());
            }
            dataSourceReactiveMySQLConfig.useAffectedRows.ifPresent(arg_0 -> ((MySQLConnectOptions)mysqlConnectOptions).setUseAffectedRows(arg_0));
            if (dataSourceReactiveMySQLConfig.sslMode.isPresent()) {
                SslMode sslMode = dataSourceReactiveMySQLConfig.sslMode.get();
                mysqlConnectOptions.setSslMode(sslMode);
                if (sslMode == SslMode.VERIFY_IDENTITY && (!dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm.isPresent() || "".equals(dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm.get()))) {
                    throw new IllegalArgumentException("quarkus.datasource.reactive.hostname-verification-algorithm must be specified under verify-identity sslmode");
                }
            }
            mysqlConnectOptions.setTrustAll(dataSourceReactiveRuntimeConfig.trustAll);
            SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)mysqlConnectOptions, (PemTrustCertConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePem);
            SSLConfigHelper.configureJksTrustOptions((TCPSSLOptions)mysqlConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.trustCertificateJks);
            SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)mysqlConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePfx);
            SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)mysqlConnectOptions, (PemKeyCertConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePem);
            SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)mysqlConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.keyCertificateJks);
            SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)mysqlConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePfx);
            mysqlConnectOptions.setReconnectAttempts(dataSourceReactiveRuntimeConfig.reconnectAttempts);
            mysqlConnectOptions.setReconnectInterval(dataSourceReactiveRuntimeConfig.reconnectInterval.toMillis());
            dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm.ifPresent(arg_0 -> ((MySQLConnectOptions)mysqlConnectOptions).setHostnameVerificationAlgorithm(arg_0));
            dataSourceReactiveMySQLConfig.authenticationPlugin.ifPresent(arg_0 -> ((MySQLConnectOptions)mysqlConnectOptions).setAuthenticationPlugin(arg_0));
            dataSourceReactiveRuntimeConfig.additionalProperties.forEach((arg_0, arg_1) -> ((MySQLConnectOptions)mysqlConnectOptions).addProperty(arg_0, arg_1));
        });
        return mysqlConnectOptionsList;
    }

    private io.vertx.mysqlclient.MySQLPool createPool(Vertx vertx, PoolOptions poolOptions, List<MySQLConnectOptions> mySQLConnectOptionsList, String dataSourceName) {
        InjectableInstance instance = DataSourceUtil.isDefault((String)dataSourceName) ? Arc.container().select(MySQLPoolCreator.class, new Annotation[0]) : Arc.container().select(MySQLPoolCreator.class, new Annotation[]{new ReactiveDataSource.ReactiveDataSourceLiteral(dataSourceName)});
        if (instance.isResolvable()) {
            DefaultInput input = new DefaultInput(vertx, poolOptions, mySQLConnectOptionsList);
            return ((MySQLPoolCreator)instance.get()).create(input);
        }
        return io.vertx.mysqlclient.MySQLPool.pool((Vertx)vertx, mySQLConnectOptionsList, (PoolOptions)poolOptions);
    }

    private static class DefaultInput
    implements MySQLPoolCreator.Input {
        private final Vertx vertx;
        private final PoolOptions poolOptions;
        private final List<MySQLConnectOptions> mySQLConnectOptionsList;

        public DefaultInput(Vertx vertx, PoolOptions poolOptions, List<MySQLConnectOptions> mySQLConnectOptionsList) {
            this.vertx = vertx;
            this.poolOptions = poolOptions;
            this.mySQLConnectOptionsList = mySQLConnectOptionsList;
        }

        @Override
        public Vertx vertx() {
            return this.vertx;
        }

        @Override
        public PoolOptions poolOptions() {
            return this.poolOptions;
        }

        @Override
        public List<MySQLConnectOptions> mySQLConnectOptionsList() {
            return this.mySQLConnectOptionsList;
        }
    }
}

