/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.mysql.client.runtime;

import io.quarkus.arc.ActiveResult;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.ConnectOptionsSupplier;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.ReactiveDataSourceUtil;
import io.quarkus.reactive.datasource.runtime.UnitisedTime;
import io.quarkus.reactive.mysql.client.MySQLPoolCreator;
import io.quarkus.reactive.mysql.client.runtime.DataSourceReactiveMySQLConfig;
import io.quarkus.reactive.mysql.client.runtime.DataSourcesReactiveMySQLConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.JksConfiguration;
import io.quarkus.vertx.core.runtime.config.PemKeyCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PemTrustCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PfxConfiguration;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.mysqlclient.SslMode;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.impl.Utils;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

@Recorder
public class MySQLPoolRecorder {
    private static final TypeLiteral<Instance<MySQLPoolCreator>> POOL_CREATOR_TYPE_LITERAL = new TypeLiteral<Instance<MySQLPoolCreator>>(){};
    private final RuntimeValue<DataSourcesRuntimeConfig> runtimeConfig;
    private final RuntimeValue<DataSourcesReactiveRuntimeConfig> reactiveRuntimeConfig;

    @Inject
    public MySQLPoolRecorder(RuntimeValue<DataSourcesRuntimeConfig> runtimeConfig, RuntimeValue<DataSourcesReactiveRuntimeConfig> reactiveRuntimeConfig) {
        this.runtimeConfig = runtimeConfig;
        this.reactiveRuntimeConfig = reactiveRuntimeConfig;
    }

    public Supplier<ActiveResult> poolCheckActiveSupplier(final String dataSourceName) {
        return new Supplier<ActiveResult>(){

            @Override
            public ActiveResult get() {
                Optional active = ((DataSourceRuntimeConfig)((DataSourcesRuntimeConfig)MySQLPoolRecorder.this.runtimeConfig.getValue()).dataSources().get(dataSourceName)).active();
                if (active.isPresent() && !((Boolean)active.get()).booleanValue()) {
                    return ActiveResult.inactive((String)DataSourceUtil.dataSourceInactiveReasonDeactivated((String)dataSourceName));
                }
                if (((DataSourcesReactiveRuntimeConfig.DataSourceReactiveOuterNamedRuntimeConfig)((DataSourcesReactiveRuntimeConfig)MySQLPoolRecorder.this.reactiveRuntimeConfig.getValue()).dataSources().get(dataSourceName)).reactive().url().isEmpty()) {
                    return ActiveResult.inactive((String)DataSourceUtil.dataSourceInactiveReasonUrlMissing((String)dataSourceName, (String)"reactive.url"));
                }
                return ActiveResult.active();
            }
        };
    }

    public Function<SyntheticCreationalContext<MySQLPool>, MySQLPool> configureMySQLPool(final RuntimeValue<Vertx> vertx, final Supplier<Integer> eventLoopCount, final String dataSourceName, final DataSourcesRuntimeConfig dataSourcesRuntimeConfig, final DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, final DataSourcesReactiveMySQLConfig dataSourcesReactiveMySQLConfig, final ShutdownContext shutdown) {
        return new Function<SyntheticCreationalContext<MySQLPool>, MySQLPool>(){

            @Override
            public MySQLPool apply(SyntheticCreationalContext<MySQLPool> context) {
                MySQLPool pool = MySQLPoolRecorder.this.initialize((VertxInternal)vertx.getValue(), (Integer)eventLoopCount.get(), dataSourceName, (DataSourceRuntimeConfig)dataSourcesRuntimeConfig.dataSources().get(dataSourceName), ((DataSourcesReactiveRuntimeConfig.DataSourceReactiveOuterNamedRuntimeConfig)dataSourcesReactiveRuntimeConfig.dataSources().get(dataSourceName)).reactive(), dataSourcesReactiveMySQLConfig.dataSources().get(dataSourceName).reactive().mysql(), context);
                shutdown.addShutdownTask(() -> ((MySQLPool)pool).close());
                return pool;
            }
        };
    }

    public Function<SyntheticCreationalContext<io.vertx.mutiny.mysqlclient.MySQLPool>, io.vertx.mutiny.mysqlclient.MySQLPool> mutinyMySQLPool(final String dataSourceName) {
        return new Function<SyntheticCreationalContext<io.vertx.mutiny.mysqlclient.MySQLPool>, io.vertx.mutiny.mysqlclient.MySQLPool>(){

            @Override
            public io.vertx.mutiny.mysqlclient.MySQLPool apply(SyntheticCreationalContext context) {
                return io.vertx.mutiny.mysqlclient.MySQLPool.newInstance((MySQLPool)((MySQLPool)context.getInjectedReference(MySQLPool.class, new Annotation[]{ReactiveDataSourceUtil.qualifier((String)dataSourceName)})));
            }
        };
    }

    private MySQLPool initialize(VertxInternal vertx, Integer eventLoopCount, String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMySQLConfig dataSourceReactiveMySQLConfig, SyntheticCreationalContext<MySQLPool> context) {
        PoolOptions poolOptions = this.toPoolOptions(eventLoopCount, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveMySQLConfig);
        List<MySQLConnectOptions> mySQLConnectOptions = this.toMySQLConnectOptions(dataSourceName, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveMySQLConfig);
        Supplier<Future<MySQLConnectOptions>> databasesSupplier = this.toDatabasesSupplier((Vertx)vertx, mySQLConnectOptions, dataSourceRuntimeConfig);
        return this.createPool((Vertx)vertx, poolOptions, mySQLConnectOptions, dataSourceName, databasesSupplier, context);
    }

    private Supplier<Future<MySQLConnectOptions>> toDatabasesSupplier(Vertx vertx, List<MySQLConnectOptions> mySQLConnectOptions, DataSourceRuntimeConfig dataSourceRuntimeConfig) {
        Supplier supplier;
        if (dataSourceRuntimeConfig.credentialsProvider().isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName().orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider().get();
            supplier = new ConnectOptionsSupplier(vertx, credentialsProvider, name, mySQLConnectOptions, MySQLConnectOptions::new);
        } else {
            supplier = Utils.roundRobinSupplier(mySQLConnectOptions);
        }
        return supplier;
    }

    private PoolOptions toPoolOptions(Integer eventLoopCount, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMySQLConfig dataSourceReactiveMySQLConfig) {
        PoolOptions poolOptions = new PoolOptions();
        poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize());
        if (dataSourceReactiveRuntimeConfig.idleTimeout().isPresent()) {
            UnitisedTime idleTimeout = UnitisedTime.unitised((Duration)((Duration)dataSourceReactiveRuntimeConfig.idleTimeout().get()));
            poolOptions.setIdleTimeout(idleTimeout.value).setIdleTimeoutUnit(idleTimeout.unit);
        }
        if (dataSourceReactiveRuntimeConfig.maxLifetime().isPresent()) {
            UnitisedTime maxLifetime = UnitisedTime.unitised((Duration)((Duration)dataSourceReactiveRuntimeConfig.maxLifetime().get()));
            poolOptions.setMaxLifetime(maxLifetime.value).setMaxLifetimeUnit(maxLifetime.unit);
        }
        if (dataSourceReactiveRuntimeConfig.shared()) {
            poolOptions.setShared(true);
            if (dataSourceReactiveRuntimeConfig.name().isPresent()) {
                poolOptions.setName((String)dataSourceReactiveRuntimeConfig.name().get());
            }
        }
        if (dataSourceReactiveRuntimeConfig.eventLoopSize().isPresent()) {
            poolOptions.setEventLoopSize(Math.max(0, dataSourceReactiveRuntimeConfig.eventLoopSize().getAsInt()));
        } else if (eventLoopCount != null) {
            poolOptions.setEventLoopSize(Math.max(0, eventLoopCount));
        }
        if (dataSourceReactiveMySQLConfig.connectionTimeout().isPresent()) {
            poolOptions.setConnectionTimeout(dataSourceReactiveMySQLConfig.connectionTimeout().getAsInt());
            poolOptions.setConnectionTimeoutUnit(TimeUnit.SECONDS);
        }
        return poolOptions;
    }

    private List<MySQLConnectOptions> toMySQLConnectOptions(String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMySQLConfig dataSourceReactiveMySQLConfig) {
        ArrayList<MySQLConnectOptions> mysqlConnectOptionsList = new ArrayList<MySQLConnectOptions>();
        if (dataSourceReactiveRuntimeConfig.url().isPresent()) {
            List urls = (List)dataSourceReactiveRuntimeConfig.url().get();
            urls.forEach(url -> {
                if (url.startsWith("vertx-reactive:mysql://")) {
                    url = url.substring("vertx-reactive:".length());
                }
                mysqlConnectOptionsList.add(MySQLConnectOptions.fromUri((String)url));
            });
        } else {
            mysqlConnectOptionsList.add(new MySQLConnectOptions());
        }
        mysqlConnectOptionsList.forEach(mysqlConnectOptions -> {
            dataSourceRuntimeConfig.username().ifPresent(arg_0 -> ((MySQLConnectOptions)mysqlConnectOptions).setUser(arg_0));
            dataSourceRuntimeConfig.password().ifPresent(arg_0 -> ((MySQLConnectOptions)mysqlConnectOptions).setPassword(arg_0));
            if (dataSourceRuntimeConfig.credentialsProvider().isPresent()) {
                String beanName = dataSourceRuntimeConfig.credentialsProviderName().orElse(null);
                CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
                String name = (String)dataSourceRuntimeConfig.credentialsProvider().get();
                Map credentials = credentialsProvider.getCredentials(name);
                String user = (String)credentials.get("user");
                String password = (String)credentials.get("password");
                if (user != null) {
                    mysqlConnectOptions.setUser(user);
                }
                if (password != null) {
                    mysqlConnectOptions.setPassword(password);
                }
            }
            mysqlConnectOptions.setCachePreparedStatements(dataSourceReactiveRuntimeConfig.cachePreparedStatements());
            dataSourceReactiveMySQLConfig.charset().ifPresent(arg_0 -> ((MySQLConnectOptions)mysqlConnectOptions).setCharset(arg_0));
            dataSourceReactiveMySQLConfig.collation().ifPresent(arg_0 -> ((MySQLConnectOptions)mysqlConnectOptions).setCollation(arg_0));
            if (dataSourceReactiveMySQLConfig.pipeliningLimit().isPresent()) {
                mysqlConnectOptions.setPipeliningLimit(dataSourceReactiveMySQLConfig.pipeliningLimit().getAsInt());
            }
            dataSourceReactiveMySQLConfig.useAffectedRows().ifPresent(arg_0 -> ((MySQLConnectOptions)mysqlConnectOptions).setUseAffectedRows(arg_0));
            if (dataSourceReactiveMySQLConfig.sslMode().isPresent()) {
                SslMode sslMode = dataSourceReactiveMySQLConfig.sslMode().get();
                mysqlConnectOptions.setSslMode(sslMode);
                String algo = dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm();
                if ("NONE".equalsIgnoreCase(algo) && sslMode == SslMode.VERIFY_IDENTITY) {
                    throw new IllegalArgumentException("quarkus.datasource.reactive.hostname-verification-algorithm must be specified under verify-identity sslmode");
                }
            }
            mysqlConnectOptions.setTrustAll(dataSourceReactiveRuntimeConfig.trustAll());
            SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)mysqlConnectOptions, (PemTrustCertConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePem());
            SSLConfigHelper.configureJksTrustOptions((TCPSSLOptions)mysqlConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.trustCertificateJks());
            SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)mysqlConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePfx());
            SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)mysqlConnectOptions, (PemKeyCertConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePem());
            SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)mysqlConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.keyCertificateJks());
            SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)mysqlConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePfx());
            mysqlConnectOptions.setReconnectAttempts(dataSourceReactiveRuntimeConfig.reconnectAttempts());
            mysqlConnectOptions.setReconnectInterval(dataSourceReactiveRuntimeConfig.reconnectInterval().toMillis());
            String algo = dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm();
            if ("NONE".equalsIgnoreCase(algo)) {
                mysqlConnectOptions.setHostnameVerificationAlgorithm("");
            } else {
                mysqlConnectOptions.setHostnameVerificationAlgorithm(algo);
            }
            dataSourceReactiveMySQLConfig.authenticationPlugin().ifPresent(arg_0 -> ((MySQLConnectOptions)mysqlConnectOptions).setAuthenticationPlugin(arg_0));
            dataSourceReactiveRuntimeConfig.additionalProperties().forEach((arg_0, arg_1) -> ((MySQLConnectOptions)mysqlConnectOptions).addProperty(arg_0, arg_1));
            mysqlConnectOptions.setMetricsName("mysql|" + dataSourceName);
        });
        return mysqlConnectOptionsList;
    }

    private MySQLPool createPool(Vertx vertx, PoolOptions poolOptions, List<MySQLConnectOptions> mySQLConnectOptionsList, String dataSourceName, Supplier<Future<MySQLConnectOptions>> databases, SyntheticCreationalContext<MySQLPool> context) {
        Instance instance = (Instance)context.getInjectedReference(POOL_CREATOR_TYPE_LITERAL, new Annotation[]{ReactiveDataSourceUtil.qualifier((String)dataSourceName)});
        if (instance.isResolvable()) {
            DefaultInput input = new DefaultInput(vertx, poolOptions, mySQLConnectOptionsList);
            return ((MySQLPoolCreator)instance.get()).create(input);
        }
        return MySQLPool.pool((Vertx)vertx, databases, (PoolOptions)poolOptions);
    }

    private static class DefaultInput
    implements MySQLPoolCreator.Input {
        private final Vertx vertx;
        private final PoolOptions poolOptions;
        private final List<MySQLConnectOptions> mySQLConnectOptionsList;

        public DefaultInput(Vertx vertx, PoolOptions poolOptions, List<MySQLConnectOptions> mySQLConnectOptionsList) {
            this.vertx = vertx;
            this.poolOptions = poolOptions;
            this.mySQLConnectOptionsList = mySQLConnectOptionsList;
        }

        @Override
        public Vertx vertx() {
            return this.vertx;
        }

        @Override
        public PoolOptions poolOptions() {
            return this.poolOptions;
        }

        @Override
        public List<MySQLConnectOptions> mySQLConnectOptionsList() {
            return this.mySQLConnectOptionsList;
        }
    }
}

