/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.oracle.client.runtime;

import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.oracle.client.runtime.DataSourceReactiveOracleConfig;
import io.quarkus.reactive.oracle.client.runtime.DataSourcesReactiveOracleConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Vertx;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.OraclePool;
import io.vertx.sqlclient.PoolOptions;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class OraclePoolRecorder {
    private static final Logger log = Logger.getLogger(OraclePoolRecorder.class);

    public RuntimeValue<OraclePool> configureOraclePool(RuntimeValue<Vertx> vertx, Supplier<Integer> eventLoopCount, String dataSourceName, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactiveOracleConfig dataSourcesReactiveOracleConfig, ShutdownContext shutdown) {
        OraclePool oraclePool = this.initialize((Vertx)vertx.getValue(), eventLoopCount.get(), dataSourcesRuntimeConfig.getDataSourceRuntimeConfig(dataSourceName), dataSourcesReactiveRuntimeConfig.getDataSourceReactiveRuntimeConfig(dataSourceName), dataSourcesReactiveOracleConfig.getDataSourceReactiveRuntimeConfig(dataSourceName));
        shutdown.addShutdownTask(() -> ((OraclePool)oraclePool).close());
        return new RuntimeValue((Object)oraclePool);
    }

    public RuntimeValue<io.vertx.mutiny.oracleclient.OraclePool> mutinyOraclePool(RuntimeValue<OraclePool> oraclePool) {
        return new RuntimeValue((Object)io.vertx.mutiny.oracleclient.OraclePool.newInstance((OraclePool)((OraclePool)oraclePool.getValue())));
    }

    private OraclePool initialize(Vertx vertx, Integer eventLoopCount, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveOracleConfig dataSourceReactiveOracleConfig) {
        PoolOptions poolOptions = this.toPoolOptions(eventLoopCount, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveOracleConfig);
        OracleConnectOptions oracleConnectOptions = this.toOracleConnectOptions(dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveOracleConfig);
        if (dataSourceReactiveRuntimeConfig.threadLocal.isPresent()) {
            log.warn((Object)"Configuration element 'thread-local' on Reactive datasource connections is deprecated and will be ignored. The started pool will always be based on a per-thread separate pool now.");
        }
        return OraclePool.pool((Vertx)vertx, (OracleConnectOptions)oracleConnectOptions, (PoolOptions)poolOptions);
    }

    private PoolOptions toPoolOptions(Integer eventLoopCount, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveOracleConfig dataSourceReactiveOracleConfig) {
        PoolOptions poolOptions = new PoolOptions();
        if (dataSourceReactiveRuntimeConfig.maxSize.isPresent()) {
            poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize.getAsInt());
        }
        if (dataSourceReactiveRuntimeConfig.idleTimeout.isPresent()) {
            int idleTimeout = Math.toIntExact(((Duration)dataSourceReactiveRuntimeConfig.idleTimeout.get()).toMillis());
            poolOptions.setIdleTimeout(idleTimeout).setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        }
        if (dataSourceReactiveRuntimeConfig.shared) {
            poolOptions.setShared(true);
            if (dataSourceReactiveRuntimeConfig.name.isPresent()) {
                poolOptions.setName((String)dataSourceReactiveRuntimeConfig.name.get());
            }
        }
        if (dataSourceReactiveRuntimeConfig.eventLoopSize.isPresent()) {
            poolOptions.setEventLoopSize(Math.max(0, dataSourceReactiveRuntimeConfig.eventLoopSize.getAsInt()));
        } else if (eventLoopCount != null) {
            poolOptions.setEventLoopSize(Math.max(0, eventLoopCount));
        }
        return poolOptions;
    }

    private OracleConnectOptions toOracleConnectOptions(DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveOracleConfig dataSourceReactiveOracleConfig) {
        OracleConnectOptions oracleConnectOptions;
        if (dataSourceReactiveRuntimeConfig.url.isPresent()) {
            String url = (String)dataSourceReactiveRuntimeConfig.url.get();
            if (url.startsWith("vertx-reactive:oracle:")) {
                url = url.substring("vertx-reactive:".length());
            }
            oracleConnectOptions = OracleConnectOptions.fromUri((String)url);
        } else {
            oracleConnectOptions = new OracleConnectOptions();
        }
        if (dataSourceRuntimeConfig.username.isPresent()) {
            oracleConnectOptions.setUser((String)dataSourceRuntimeConfig.username.get());
        }
        if (dataSourceRuntimeConfig.password.isPresent()) {
            oracleConnectOptions.setPassword((String)dataSourceRuntimeConfig.password.get());
        }
        if (dataSourceRuntimeConfig.credentialsProvider.isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName.orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider.get();
            Map credentials = credentialsProvider.getCredentials(name);
            String user = (String)credentials.get("user");
            String password = (String)credentials.get("password");
            if (user != null) {
                oracleConnectOptions.setUser(user);
            }
            if (password != null) {
                oracleConnectOptions.setPassword(password);
            }
        }
        dataSourceReactiveRuntimeConfig.additionalProperties.forEach((arg_0, arg_1) -> ((OracleConnectOptions)oracleConnectOptions).addProperty(arg_0, arg_1));
        return oracleConnectOptions;
    }
}

