/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.oracle.client.runtime;

import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourceSupport;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.quarkus.reactive.datasource.runtime.ConnectOptionsSupplier;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.UnitisedTime;
import io.quarkus.reactive.oracle.client.OraclePoolCreator;
import io.quarkus.reactive.oracle.client.runtime.DataSourceReactiveOracleConfig;
import io.quarkus.reactive.oracle.client.runtime.DataSourcesReactiveOracleConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.OraclePool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.impl.Utils;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class OraclePoolRecorder {
    private static final TypeLiteral<Instance<OraclePoolCreator>> POOL_CREATOR_TYPE_LITERAL = new TypeLiteral<Instance<OraclePoolCreator>>(){};
    private static final Logger log = Logger.getLogger(OraclePoolRecorder.class);

    public Function<SyntheticCreationalContext<OraclePool>, OraclePool> configureOraclePool(final RuntimeValue<Vertx> vertx, final Supplier<Integer> eventLoopCount, final String dataSourceName, final DataSourcesRuntimeConfig dataSourcesRuntimeConfig, final DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, final DataSourcesReactiveOracleConfig dataSourcesReactiveOracleConfig, final ShutdownContext shutdown) {
        return new Function<SyntheticCreationalContext<OraclePool>, OraclePool>(){

            @Override
            public OraclePool apply(SyntheticCreationalContext<OraclePool> context) {
                OraclePool pool = OraclePoolRecorder.this.initialize((VertxInternal)vertx.getValue(), (Integer)eventLoopCount.get(), dataSourceName, (DataSourceRuntimeConfig)dataSourcesRuntimeConfig.dataSources().get(dataSourceName), dataSourcesReactiveRuntimeConfig.getDataSourceReactiveRuntimeConfig(dataSourceName), dataSourcesReactiveOracleConfig.dataSources().get(dataSourceName).reactive().oracle(), context);
                shutdown.addShutdownTask(() -> ((OraclePool)pool).close());
                return pool;
            }
        };
    }

    public Function<SyntheticCreationalContext<io.vertx.mutiny.oracleclient.OraclePool>, io.vertx.mutiny.oracleclient.OraclePool> mutinyOraclePool(final String dataSourceName) {
        return new Function<SyntheticCreationalContext<io.vertx.mutiny.oracleclient.OraclePool>, io.vertx.mutiny.oracleclient.OraclePool>(){

            @Override
            public io.vertx.mutiny.oracleclient.OraclePool apply(SyntheticCreationalContext context) {
                DataSourceSupport datasourceSupport = (DataSourceSupport)context.getInjectedReference(DataSourceSupport.class, new Annotation[0]);
                if (datasourceSupport.getInactiveNames().contains(dataSourceName)) {
                    throw DataSourceUtil.dataSourceInactive((String)dataSourceName);
                }
                return io.vertx.mutiny.oracleclient.OraclePool.newInstance((OraclePool)((OraclePool)context.getInjectedReference(OraclePool.class, new Annotation[]{OraclePoolRecorder.getReactiveDataSourceQualifier(dataSourceName)})));
            }
        };
    }

    private static Annotation getReactiveDataSourceQualifier(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return Default.Literal.INSTANCE;
        }
        return new ReactiveDataSource.ReactiveDataSourceLiteral(dataSourceName);
    }

    private OraclePool initialize(VertxInternal vertx, Integer eventLoopCount, String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveOracleConfig dataSourceReactiveOracleConfig, SyntheticCreationalContext<OraclePool> context) {
        if (((DataSourceSupport)context.getInjectedReference(DataSourceSupport.class, new Annotation[0])).getInactiveNames().contains(dataSourceName)) {
            throw DataSourceUtil.dataSourceInactive((String)dataSourceName);
        }
        PoolOptions poolOptions = this.toPoolOptions(eventLoopCount, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveOracleConfig);
        OracleConnectOptions oracleConnectOptions = this.toOracleConnectOptions(dataSourceName, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveOracleConfig);
        Supplier<Future<OracleConnectOptions>> databasesSupplier = this.toDatabasesSupplier((Vertx)vertx, List.of(oracleConnectOptions), dataSourceRuntimeConfig);
        return this.createPool((Vertx)vertx, poolOptions, oracleConnectOptions, dataSourceName, databasesSupplier, context);
    }

    private Supplier<Future<OracleConnectOptions>> toDatabasesSupplier(Vertx vertx, List<OracleConnectOptions> oracleConnectOptions, DataSourceRuntimeConfig dataSourceRuntimeConfig) {
        Supplier supplier;
        if (dataSourceRuntimeConfig.credentialsProvider().isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName().orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider().get();
            supplier = new ConnectOptionsSupplier(vertx, credentialsProvider, name, oracleConnectOptions, OracleConnectOptions::new);
        } else {
            supplier = Utils.roundRobinSupplier(oracleConnectOptions);
        }
        return supplier;
    }

    private PoolOptions toPoolOptions(Integer eventLoopCount, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveOracleConfig dataSourceReactiveOracleConfig) {
        PoolOptions poolOptions = new PoolOptions();
        poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize());
        if (dataSourceReactiveRuntimeConfig.idleTimeout().isPresent()) {
            UnitisedTime idleTimeout = UnitisedTime.unitised((Duration)((Duration)dataSourceReactiveRuntimeConfig.idleTimeout().get()));
            poolOptions.setIdleTimeout(idleTimeout.value).setIdleTimeoutUnit(idleTimeout.unit);
        }
        if (dataSourceReactiveRuntimeConfig.maxLifetime().isPresent()) {
            UnitisedTime maxLifetime = UnitisedTime.unitised((Duration)((Duration)dataSourceReactiveRuntimeConfig.maxLifetime().get()));
            poolOptions.setMaxLifetime(maxLifetime.value).setMaxLifetimeUnit(maxLifetime.unit);
        }
        if (dataSourceReactiveRuntimeConfig.shared()) {
            poolOptions.setShared(true);
            if (dataSourceReactiveRuntimeConfig.name().isPresent()) {
                poolOptions.setName((String)dataSourceReactiveRuntimeConfig.name().get());
            }
        }
        if (dataSourceReactiveRuntimeConfig.eventLoopSize().isPresent()) {
            poolOptions.setEventLoopSize(Math.max(0, dataSourceReactiveRuntimeConfig.eventLoopSize().getAsInt()));
        } else if (eventLoopCount != null) {
            poolOptions.setEventLoopSize(Math.max(0, eventLoopCount));
        }
        return poolOptions;
    }

    private OracleConnectOptions toOracleConnectOptions(String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveOracleConfig dataSourceReactiveOracleConfig) {
        OracleConnectOptions oracleConnectOptions;
        if (dataSourceReactiveRuntimeConfig.url().isPresent()) {
            String url;
            List urls = (List)dataSourceReactiveRuntimeConfig.url().get();
            if (urls.size() > 1) {
                log.warn((Object)"The Reactive Oracle client does not support multiple URLs. The first one will be used, and others will be ignored.");
            }
            if ((url = (String)urls.get(0)).startsWith("vertx-reactive:oracle:")) {
                url = url.substring("vertx-reactive:".length());
            }
            oracleConnectOptions = OracleConnectOptions.fromUri((String)url);
        } else {
            oracleConnectOptions = new OracleConnectOptions();
        }
        if (dataSourceRuntimeConfig.username().isPresent()) {
            oracleConnectOptions.setUser((String)dataSourceRuntimeConfig.username().get());
        }
        if (dataSourceRuntimeConfig.password().isPresent()) {
            oracleConnectOptions.setPassword((String)dataSourceRuntimeConfig.password().get());
        }
        if (dataSourceRuntimeConfig.credentialsProvider().isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName().orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider().get();
            Map credentials = credentialsProvider.getCredentials(name);
            String user = (String)credentials.get("user");
            String password = (String)credentials.get("password");
            if (user != null) {
                oracleConnectOptions.setUser(user);
            }
            if (password != null) {
                oracleConnectOptions.setPassword(password);
            }
        }
        dataSourceReactiveRuntimeConfig.additionalProperties().forEach((arg_0, arg_1) -> ((OracleConnectOptions)oracleConnectOptions).addProperty(arg_0, arg_1));
        oracleConnectOptions.setMetricsName("oracle|" + dataSourceName);
        return oracleConnectOptions;
    }

    private OraclePool createPool(Vertx vertx, PoolOptions poolOptions, OracleConnectOptions oracleConnectOptions, String dataSourceName, Supplier<Future<OracleConnectOptions>> databases, SyntheticCreationalContext<OraclePool> context) {
        Instance instance = DataSourceUtil.isDefault((String)dataSourceName) ? (Instance)context.getInjectedReference(POOL_CREATOR_TYPE_LITERAL, new Annotation[0]) : (Instance)context.getInjectedReference(POOL_CREATOR_TYPE_LITERAL, new Annotation[]{new ReactiveDataSource.ReactiveDataSourceLiteral(dataSourceName)});
        if (instance.isResolvable()) {
            DefaultInput input = new DefaultInput(vertx, poolOptions, oracleConnectOptions);
            return ((OraclePoolCreator)instance.get()).create(input);
        }
        return OraclePool.pool((Vertx)vertx, databases, (PoolOptions)poolOptions);
    }

    private static class DefaultInput
    implements OraclePoolCreator.Input {
        private final Vertx vertx;
        private final PoolOptions poolOptions;
        private final OracleConnectOptions oracleConnectOptions;

        public DefaultInput(Vertx vertx, PoolOptions poolOptions, OracleConnectOptions oracleConnectOptions) {
            this.vertx = vertx;
            this.poolOptions = poolOptions;
            this.oracleConnectOptions = oracleConnectOptions;
        }

        @Override
        public Vertx vertx() {
            return this.vertx;
        }

        @Override
        public PoolOptions poolOptions() {
            return this.poolOptions;
        }

        @Override
        public OracleConnectOptions oracleConnectOptions() {
            return this.oracleConnectOptions;
        }
    }
}

