/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.oracle.client.runtime;

import io.quarkus.arc.ActiveResult;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.ConnectOptionsSupplier;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.ReactiveDataSourceUtil;
import io.quarkus.reactive.datasource.runtime.UnitisedTime;
import io.quarkus.reactive.oracle.client.OraclePoolCreator;
import io.quarkus.reactive.oracle.client.runtime.DataSourceReactiveOracleConfig;
import io.quarkus.reactive.oracle.client.runtime.DataSourcesReactiveOracleConfig;
import io.quarkus.reactive.oracle.client.runtime.OraclePoolSupport;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.mutiny.oracleclient.OraclePool;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.spi.OracleDriver;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.impl.Utils;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class OraclePoolRecorder {
    private static final Logger log = Logger.getLogger(OraclePoolRecorder.class);
    private static final TypeLiteral<Instance<OraclePoolCreator>> POOL_CREATOR_TYPE_LITERAL = new TypeLiteral<Instance<OraclePoolCreator>>(){};
    private final RuntimeValue<DataSourcesRuntimeConfig> runtimeConfig;
    private final RuntimeValue<DataSourcesReactiveRuntimeConfig> reactiveRuntimeConfig;

    @Inject
    public OraclePoolRecorder(RuntimeValue<DataSourcesRuntimeConfig> runtimeConfig, RuntimeValue<DataSourcesReactiveRuntimeConfig> reactiveRuntimeConfig) {
        this.runtimeConfig = runtimeConfig;
        this.reactiveRuntimeConfig = reactiveRuntimeConfig;
    }

    public Supplier<ActiveResult> poolCheckActiveSupplier(final String dataSourceName) {
        return new Supplier<ActiveResult>(){

            @Override
            public ActiveResult get() {
                Optional active = ((DataSourceRuntimeConfig)((DataSourcesRuntimeConfig)OraclePoolRecorder.this.runtimeConfig.getValue()).dataSources().get(dataSourceName)).active();
                if (active.isPresent() && !((Boolean)active.get()).booleanValue()) {
                    return ActiveResult.inactive((String)DataSourceUtil.dataSourceInactiveReasonDeactivated((String)dataSourceName));
                }
                if (((DataSourcesReactiveRuntimeConfig.DataSourceReactiveOuterNamedRuntimeConfig)((DataSourcesReactiveRuntimeConfig)OraclePoolRecorder.this.reactiveRuntimeConfig.getValue()).dataSources().get(dataSourceName)).reactive().url().isEmpty()) {
                    return ActiveResult.inactive((String)DataSourceUtil.dataSourceInactiveReasonUrlMissing((String)dataSourceName, (String)"reactive.url"));
                }
                return ActiveResult.active();
            }
        };
    }

    public Function<SyntheticCreationalContext<io.vertx.oracleclient.OraclePool>, io.vertx.oracleclient.OraclePool> configureOraclePool(final RuntimeValue<Vertx> vertx, final Supplier<Integer> eventLoopCount, final String dataSourceName, final DataSourcesRuntimeConfig dataSourcesRuntimeConfig, final DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, final DataSourcesReactiveOracleConfig dataSourcesReactiveOracleConfig, final ShutdownContext shutdown) {
        return new Function<SyntheticCreationalContext<io.vertx.oracleclient.OraclePool>, io.vertx.oracleclient.OraclePool>(){

            @Override
            public io.vertx.oracleclient.OraclePool apply(SyntheticCreationalContext<io.vertx.oracleclient.OraclePool> context) {
                io.vertx.oracleclient.OraclePool pool = OraclePoolRecorder.this.initialize((VertxInternal)vertx.getValue(), (Integer)eventLoopCount.get(), dataSourceName, (DataSourceRuntimeConfig)dataSourcesRuntimeConfig.dataSources().get(dataSourceName), ((DataSourcesReactiveRuntimeConfig.DataSourceReactiveOuterNamedRuntimeConfig)dataSourcesReactiveRuntimeConfig.dataSources().get(dataSourceName)).reactive(), dataSourcesReactiveOracleConfig.dataSources().get(dataSourceName).reactive().oracle(), context);
                shutdown.addShutdownTask(() -> ((io.vertx.oracleclient.OraclePool)pool).close());
                return pool;
            }
        };
    }

    public Function<SyntheticCreationalContext<OraclePool>, OraclePool> mutinyOraclePool(final String dataSourceName) {
        return new Function<SyntheticCreationalContext<OraclePool>, OraclePool>(){

            @Override
            public OraclePool apply(SyntheticCreationalContext context) {
                return OraclePool.newInstance((io.vertx.oracleclient.OraclePool)((io.vertx.oracleclient.OraclePool)context.getInjectedReference(io.vertx.oracleclient.OraclePool.class, new Annotation[]{ReactiveDataSourceUtil.qualifier((String)dataSourceName)})));
            }
        };
    }

    private io.vertx.oracleclient.OraclePool initialize(VertxInternal vertx, Integer eventLoopCount, String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveOracleConfig dataSourceReactiveOracleConfig, SyntheticCreationalContext<io.vertx.oracleclient.OraclePool> context) {
        PoolOptions poolOptions = this.toPoolOptions(eventLoopCount, dataSourceReactiveRuntimeConfig);
        OracleConnectOptions oracleConnectOptions = this.toOracleConnectOptions(dataSourceName, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveOracleConfig);
        Supplier<Future<OracleConnectOptions>> databasesSupplier = this.toDatabasesSupplier((Vertx)vertx, List.of(oracleConnectOptions), dataSourceRuntimeConfig);
        return this.createPool((Vertx)vertx, poolOptions, oracleConnectOptions, dataSourceName, databasesSupplier, context);
    }

    private Supplier<Future<OracleConnectOptions>> toDatabasesSupplier(Vertx vertx, List<OracleConnectOptions> oracleConnectOptions, DataSourceRuntimeConfig dataSourceRuntimeConfig) {
        Supplier supplier;
        if (dataSourceRuntimeConfig.credentialsProvider().isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName().orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider().get();
            supplier = new ConnectOptionsSupplier(vertx, credentialsProvider, name, oracleConnectOptions, OracleConnectOptions::new);
        } else {
            supplier = Utils.roundRobinSupplier(oracleConnectOptions);
        }
        return supplier;
    }

    private PoolOptions toPoolOptions(Integer eventLoopCount, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig) {
        PoolOptions poolOptions = new PoolOptions();
        poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize());
        if (dataSourceReactiveRuntimeConfig.idleTimeout().isPresent()) {
            UnitisedTime idleTimeout = UnitisedTime.unitised((Duration)((Duration)dataSourceReactiveRuntimeConfig.idleTimeout().get()));
            poolOptions.setIdleTimeout(idleTimeout.value).setIdleTimeoutUnit(idleTimeout.unit);
        }
        if (dataSourceReactiveRuntimeConfig.maxLifetime().isPresent()) {
            UnitisedTime maxLifetime = UnitisedTime.unitised((Duration)((Duration)dataSourceReactiveRuntimeConfig.maxLifetime().get()));
            poolOptions.setMaxLifetime(maxLifetime.value).setMaxLifetimeUnit(maxLifetime.unit);
        }
        if (dataSourceReactiveRuntimeConfig.shared()) {
            poolOptions.setShared(true);
            if (dataSourceReactiveRuntimeConfig.name().isPresent()) {
                poolOptions.setName((String)dataSourceReactiveRuntimeConfig.name().get());
            }
        }
        if (dataSourceReactiveRuntimeConfig.eventLoopSize().isPresent()) {
            poolOptions.setEventLoopSize(Math.max(0, dataSourceReactiveRuntimeConfig.eventLoopSize().getAsInt()));
        } else if (eventLoopCount != null) {
            poolOptions.setEventLoopSize(Math.max(0, eventLoopCount));
        }
        return poolOptions;
    }

    private OracleConnectOptions toOracleConnectOptions(String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveOracleConfig dataSourceReactiveOracleConfig) {
        OracleConnectOptions oracleConnectOptions;
        if (dataSourceReactiveRuntimeConfig.url().isPresent()) {
            String url;
            List urls = (List)dataSourceReactiveRuntimeConfig.url().get();
            if (urls.size() > 1) {
                log.warn((Object)"The Reactive Oracle client does not support multiple URLs. The first one will be used, and others will be ignored.");
            }
            if ((url = (String)urls.get(0)).startsWith("vertx-reactive:oracle:")) {
                url = url.substring("vertx-reactive:".length());
            }
            oracleConnectOptions = OracleConnectOptions.fromUri((String)url);
        } else {
            oracleConnectOptions = new OracleConnectOptions();
        }
        if (dataSourceRuntimeConfig.username().isPresent()) {
            oracleConnectOptions.setUser((String)dataSourceRuntimeConfig.username().get());
        }
        if (dataSourceRuntimeConfig.password().isPresent()) {
            oracleConnectOptions.setPassword((String)dataSourceRuntimeConfig.password().get());
        }
        if (dataSourceRuntimeConfig.credentialsProvider().isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName().orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider().get();
            Map credentials = credentialsProvider.getCredentials(name);
            String user = (String)credentials.get("user");
            String password = (String)credentials.get("password");
            if (user != null) {
                oracleConnectOptions.setUser(user);
            }
            if (password != null) {
                oracleConnectOptions.setPassword(password);
            }
        }
        dataSourceReactiveRuntimeConfig.additionalProperties().forEach((arg_0, arg_1) -> ((OracleConnectOptions)oracleConnectOptions).addProperty(arg_0, arg_1));
        oracleConnectOptions.setMetricsName("oracle|" + dataSourceName);
        return oracleConnectOptions;
    }

    private io.vertx.oracleclient.OraclePool createPool(Vertx vertx, PoolOptions poolOptions, OracleConnectOptions oracleConnectOptions, String dataSourceName, Supplier<Future<OracleConnectOptions>> databases, SyntheticCreationalContext<io.vertx.oracleclient.OraclePool> context) {
        Instance instance = (Instance)context.getInjectedReference(POOL_CREATOR_TYPE_LITERAL, new Annotation[]{ReactiveDataSourceUtil.qualifier((String)dataSourceName)});
        if (instance.isResolvable()) {
            DefaultInput input = new DefaultInput(vertx, poolOptions, oracleConnectOptions);
            return (io.vertx.oracleclient.OraclePool)((OraclePoolCreator)instance.get()).create(input);
        }
        return (io.vertx.oracleclient.OraclePool)OracleDriver.INSTANCE.createPool(vertx, databases, poolOptions);
    }

    public RuntimeValue<OraclePoolSupport> createOraclePoolSupport(Set<String> oraclePoolNames) {
        return new RuntimeValue((Object)new OraclePoolSupport(oraclePoolNames));
    }

    private static class DefaultInput
    implements OraclePoolCreator.Input {
        private final Vertx vertx;
        private final PoolOptions poolOptions;
        private final OracleConnectOptions oracleConnectOptions;

        public DefaultInput(Vertx vertx, PoolOptions poolOptions, OracleConnectOptions oracleConnectOptions) {
            this.vertx = vertx;
            this.poolOptions = poolOptions;
            this.oracleConnectOptions = oracleConnectOptions;
        }

        @Override
        public Vertx vertx() {
            return this.vertx;
        }

        @Override
        public PoolOptions poolOptions() {
            return this.poolOptions;
        }

        @Override
        public OracleConnectOptions oracleConnectOptions() {
            return this.oracleConnectOptions;
        }
    }
}

