/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.pg.client.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.quarkus.reactive.datasource.deployment.VertxPoolBuildItem;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveBuildTimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveBuildTimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.pg.client.deployment.PgPoolBuildItem;
import io.quarkus.reactive.pg.client.runtime.DataSourcesReactivePostgreSQLConfig;
import io.quarkus.reactive.pg.client.runtime.PgPoolRecorder;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.Pool;
import javax.inject.Singleton;

class ReactivePgClientProcessor {
    ReactivePgClientProcessor() {
    }

    @BuildStep
    NativeImageConfigBuildItem config() {
        return NativeImageConfigBuildItem.builder().addRuntimeInitializedClass("io.vertx.pgclient.impl.codec.StartupMessage").build();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem build(BuildProducer<FeatureBuildItem> feature, BuildProducer<PgPoolBuildItem> pgPool, BuildProducer<VertxPoolBuildItem> vertxPool, PgPoolRecorder recorder, VertxBuildItem vertx, ShutdownContextBuildItem shutdown, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactivePostgreSQLConfig dataSourcesReactivePostgreSQLConfig) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.REACTIVE_PG_CLIENT));
        this.createPoolIfDefined(recorder, vertx, shutdown, pgPool, vertxPool, syntheticBeans, "<default>", dataSourcesBuildTimeConfig, dataSourcesRuntimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourcesReactiveRuntimeConfig, dataSourcesReactivePostgreSQLConfig);
        for (String dataSourceName : dataSourcesBuildTimeConfig.namedDataSources.keySet()) {
            this.createPoolIfDefined(recorder, vertx, shutdown, pgPool, vertxPool, syntheticBeans, dataSourceName, dataSourcesBuildTimeConfig, dataSourcesRuntimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourcesReactiveRuntimeConfig, dataSourcesReactivePostgreSQLConfig);
        }
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.REACTIVE_PG_CLIENT));
        return new ServiceStartBuildItem("reactive-pg-client");
    }

    @BuildStep
    void addHealthCheck(BuildProducer<HealthBuildItem> healthChecks, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig) {
        if (!this.hasPools(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig)) {
            return;
        }
        healthChecks.produce((BuildItem)new HealthBuildItem("io.quarkus.reactive.pg.client.runtime.health.ReactivePgDataSourcesHealthCheck", dataSourcesBuildTimeConfig.healthEnabled));
    }

    private void createPoolIfDefined(PgPoolRecorder recorder, VertxBuildItem vertx, ShutdownContextBuildItem shutdown, BuildProducer<PgPoolBuildItem> pgPool, BuildProducer<VertxPoolBuildItem> vertxPool, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, String dataSourceName, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactivePostgreSQLConfig dataSourcesReactivePostgreSQLConfig) {
        if (!ReactivePgClientProcessor.isReactivePostgreSQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourceName)) {
            return;
        }
        RuntimeValue pool = recorder.configurePgPool(vertx.getVertx(), dataSourceName, dataSourcesRuntimeConfig, dataSourcesReactiveRuntimeConfig, dataSourcesReactivePostgreSQLConfig, (ShutdownContext)shutdown);
        pgPool.produce((BuildItem)new PgPoolBuildItem(dataSourceName, (RuntimeValue<PgPool>)pool));
        SyntheticBeanBuildItem.ExtendedBeanConfigurator pgPoolBeanConfigurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(PgPool.class).defaultBean()).addType(Pool.class)).scope(Singleton.class)).runtimeValue(pool).unremovable()).setRuntimeInit();
        ReactivePgClientProcessor.addQualifiers(pgPoolBeanConfigurator, dataSourceName);
        syntheticBeans.produce((BuildItem)pgPoolBeanConfigurator.done());
        SyntheticBeanBuildItem.ExtendedBeanConfigurator mutinyPgPoolConfigurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(io.vertx.mutiny.pgclient.PgPool.class).defaultBean()).scope(Singleton.class)).runtimeValue(recorder.mutinyPgPool(pool)).setRuntimeInit();
        ReactivePgClientProcessor.addQualifiers(mutinyPgPoolConfigurator, dataSourceName);
        syntheticBeans.produce((BuildItem)mutinyPgPoolConfigurator.done());
        vertxPool.produce((BuildItem)new VertxPoolBuildItem(pool, "postgresql", DataSourceUtil.isDefault((String)dataSourceName)));
    }

    private static boolean isReactivePostgreSQLPoolDefined(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, String dataSourceName) {
        DataSourceBuildTimeConfig dataSourceBuildTimeConfig = dataSourcesBuildTimeConfig.getDataSourceRuntimeConfig(dataSourceName);
        DataSourceReactiveBuildTimeConfig dataSourceReactiveBuildTimeConfig = dataSourcesReactiveBuildTimeConfig.getDataSourceReactiveBuildTimeConfig(dataSourceName);
        if (!dataSourceBuildTimeConfig.dbKind.isPresent()) {
            return false;
        }
        return DatabaseKind.isPostgreSQL((String)((String)dataSourceBuildTimeConfig.dbKind.get())) && dataSourceReactiveBuildTimeConfig.enabled;
    }

    private boolean hasPools(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig) {
        if (ReactivePgClientProcessor.isReactivePostgreSQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, "<default>")) {
            return true;
        }
        for (String dataSourceName : dataSourcesBuildTimeConfig.namedDataSources.keySet()) {
            if (!ReactivePgClientProcessor.isReactivePostgreSQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourceName)) continue;
            return true;
        }
        return false;
    }

    private static void addQualifiers(SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator, String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            configurator.addQualifier(DotNames.DEFAULT);
        } else {
            configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)dataSourceName).done();
            configurator.addQualifier().annotation(ReactiveDataSource.class).addValue("value", (Object)dataSourceName).done();
        }
    }
}

