/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.pg.client.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.datasource.runtime.LegacyDataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.LegacyDataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.pg.client.runtime.DataSourceReactivePostgreSQLConfig;
import io.quarkus.reactive.pg.client.runtime.LegacyDataSourceReactivePostgreSQLConfig;
import io.quarkus.reactive.pg.client.runtime.PgPoolProducer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Vertx;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.PoolOptions;
import java.lang.annotation.Annotation;
import java.util.Map;

@Recorder
public class PgPoolRecorder {
    public RuntimeValue<PgPool> configurePgPool(RuntimeValue<Vertx> vertx, BeanContainer container, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactivePostgreSQLConfig dataSourceReactivePostgreSQLConfig, LegacyDataSourcesRuntimeConfig legacyDataSourcesRuntimeConfig, LegacyDataSourceReactivePostgreSQLConfig legacyDataSourceReactivePostgreSQLConfig, boolean isLegacy, ShutdownContext shutdown) {
        PgPool pgPool = !isLegacy ? this.initialize((Vertx)vertx.getValue(), dataSourcesRuntimeConfig.defaultDataSource, dataSourceReactiveRuntimeConfig, dataSourceReactivePostgreSQLConfig) : this.legacyInitialize((Vertx)vertx.getValue(), dataSourcesRuntimeConfig.defaultDataSource, legacyDataSourcesRuntimeConfig.defaultDataSource, legacyDataSourceReactivePostgreSQLConfig);
        PgPoolProducer producer = (PgPoolProducer)container.instance(PgPoolProducer.class, new Annotation[0]);
        producer.initialize(pgPool);
        shutdown.addShutdownTask(() -> ((PgPool)pgPool).close());
        return new RuntimeValue((Object)pgPool);
    }

    private PgPool initialize(Vertx vertx, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactivePostgreSQLConfig dataSourceReactivePostgreSQLConfig) {
        PoolOptions poolOptions = this.toPoolOptions(dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactivePostgreSQLConfig);
        PgConnectOptions pgConnectOptions = this.toPgConnectOptions(dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactivePostgreSQLConfig);
        return PgPool.pool((Vertx)vertx, (PgConnectOptions)pgConnectOptions, (PoolOptions)poolOptions);
    }

    private PoolOptions toPoolOptions(DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactivePostgreSQLConfig dataSourceReactivePostgreSQLConfig) {
        PoolOptions poolOptions = new PoolOptions();
        if (dataSourceReactiveRuntimeConfig.maxSize.isPresent()) {
            poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize.getAsInt());
        }
        return poolOptions;
    }

    private PgConnectOptions toPgConnectOptions(DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactivePostgreSQLConfig dataSourceReactivePostgreSQLConfig) {
        PgConnectOptions pgConnectOptions;
        if (dataSourceReactiveRuntimeConfig.url.isPresent()) {
            String url = (String)dataSourceReactiveRuntimeConfig.url.get();
            if (url.matches("^vertx-reactive:postgre(?:s|sql)://.*$")) {
                url = url.substring("vertx-reactive:".length());
            }
            pgConnectOptions = PgConnectOptions.fromUri((String)url);
        } else {
            pgConnectOptions = new PgConnectOptions();
        }
        if (dataSourceRuntimeConfig.username.isPresent()) {
            pgConnectOptions.setUser((String)dataSourceRuntimeConfig.username.get());
        }
        if (dataSourceRuntimeConfig.password.isPresent()) {
            pgConnectOptions.setPassword((String)dataSourceRuntimeConfig.password.get());
        }
        if (dataSourceRuntimeConfig.credentialsProvider.isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName.orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider.get();
            Map credentials = credentialsProvider.getCredentials(name);
            String user = (String)credentials.get("user");
            String password = (String)credentials.get("password");
            if (user != null) {
                pgConnectOptions.setUser(user);
            }
            if (password != null) {
                pgConnectOptions.setPassword(user);
            }
        }
        if (dataSourceReactivePostgreSQLConfig.cachePreparedStatements.isPresent()) {
            pgConnectOptions.setCachePreparedStatements(dataSourceReactivePostgreSQLConfig.cachePreparedStatements.get().booleanValue());
        }
        if (dataSourceReactivePostgreSQLConfig.pipeliningLimit.isPresent()) {
            pgConnectOptions.setPipeliningLimit(dataSourceReactivePostgreSQLConfig.pipeliningLimit.getAsInt());
        }
        return pgConnectOptions;
    }

    private PgPool legacyInitialize(Vertx vertx, DataSourceRuntimeConfig dataSourceRuntimeConfig, LegacyDataSourceRuntimeConfig legacyDataSourceRuntimeConfig, LegacyDataSourceReactivePostgreSQLConfig legacyDataSourceReactivePostgreSQLConfig) {
        PoolOptions poolOptions = this.legacyToPoolOptionsLegacy(legacyDataSourceRuntimeConfig);
        PgConnectOptions pgConnectOptions = this.legacyToPostgreSQLConnectOptions(dataSourceRuntimeConfig, legacyDataSourceRuntimeConfig, legacyDataSourceReactivePostgreSQLConfig);
        return PgPool.pool((Vertx)vertx, (PgConnectOptions)pgConnectOptions, (PoolOptions)poolOptions);
    }

    private PoolOptions legacyToPoolOptionsLegacy(LegacyDataSourceRuntimeConfig legacyDataSourceRuntimeConfig) {
        PoolOptions poolOptions = new PoolOptions();
        poolOptions.setMaxSize(legacyDataSourceRuntimeConfig.maxSize);
        return poolOptions;
    }

    private PgConnectOptions legacyToPostgreSQLConnectOptions(DataSourceRuntimeConfig dataSourceRuntimeConfig, LegacyDataSourceRuntimeConfig legacyDataSourceRuntimeConfig, LegacyDataSourceReactivePostgreSQLConfig legacyDataSourceReactivePostgreSQLConfig) {
        PgConnectOptions pgConnectOptions;
        if (legacyDataSourceRuntimeConfig.url.isPresent()) {
            String url = (String)legacyDataSourceRuntimeConfig.url.get();
            if (url.matches("^vertx-reactive:postgre(?:s|sql)://.*$")) {
                url = url.substring("vertx-reactive:".length());
            }
            pgConnectOptions = PgConnectOptions.fromUri((String)url);
        } else {
            pgConnectOptions = new PgConnectOptions();
        }
        if (dataSourceRuntimeConfig.username.isPresent()) {
            pgConnectOptions.setUser((String)dataSourceRuntimeConfig.username.get());
        }
        if (dataSourceRuntimeConfig.password.isPresent()) {
            pgConnectOptions.setPassword((String)dataSourceRuntimeConfig.password.get());
        }
        if (legacyDataSourceReactivePostgreSQLConfig.cachePreparedStatements.isPresent()) {
            pgConnectOptions.setCachePreparedStatements(legacyDataSourceReactivePostgreSQLConfig.cachePreparedStatements.get().booleanValue());
        }
        if (legacyDataSourceReactivePostgreSQLConfig.pipeliningLimit.isPresent()) {
            pgConnectOptions.setPipeliningLimit(legacyDataSourceReactivePostgreSQLConfig.pipeliningLimit.getAsInt());
        }
        return pgConnectOptions;
    }
}

