/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.pg.client.runtime.health;

import io.quarkus.arc.Arc;
import io.vertx.pgclient.PgPool;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class ReactivePgDataSourceHealthCheck
implements HealthCheck {
    private PgPool pgPool;

    @PostConstruct
    protected void init() {
        this.pgPool = (PgPool)Arc.container().instance(PgPool.class, new Annotation[0]).get();
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Reactive PostgreSQL connection health check").up();
        try {
            CompletableFuture databaseConnectionAttempt = new CompletableFuture();
            this.pgPool.query("SELECT 1").execute(ar -> {
                if (ar.failed()) {
                    builder.down();
                }
                databaseConnectionAttempt.complete(null);
            });
            databaseConnectionAttempt.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            builder.down();
        }
        return builder.build();
    }
}

