/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.pg.client.runtime.health;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.runtime.DataSourcesHealthSupport;
import io.quarkus.reactive.datasource.runtime.ReactiveDatasourceHealthCheck;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.Pool;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
class ReactivePgDataSourcesHealthCheck
extends ReactiveDatasourceHealthCheck {
    public ReactivePgDataSourcesHealthCheck() {
        super("Reactive PostgreSQL connections health check", "SELECT 1");
    }

    @PostConstruct
    protected void init() {
        ArcContainer container = Arc.container();
        DataSourcesHealthSupport excluded = (DataSourcesHealthSupport)container.instance(DataSourcesHealthSupport.class, new Annotation[0]).get();
        Set excludedNames = excluded.getExcludedNames();
        for (InstanceHandle handle : container.select(PgPool.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            String poolName = this.getPoolName((Bean)handle.getBean());
            if (excludedNames.contains(poolName)) continue;
            this.addPool(poolName, (Pool)handle.get());
        }
    }
}

