/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.pg.client.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.pg.client.PgPoolCreator;
import io.quarkus.reactive.pg.client.runtime.DataSourceReactivePostgreSQLConfig;
import io.quarkus.reactive.pg.client.runtime.DataSourcesReactivePostgreSQLConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.JksConfiguration;
import io.quarkus.vertx.core.runtime.config.PemKeyCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PemTrustCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PfxConfiguration;
import io.vertx.core.Vertx;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgPool;
import io.vertx.pgclient.SslMode;
import io.vertx.sqlclient.PoolOptions;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class PgPoolRecorder {
    private static final Logger log = Logger.getLogger(PgPoolRecorder.class);

    public RuntimeValue<PgPool> configurePgPool(RuntimeValue<Vertx> vertx, Supplier<Integer> eventLoopCount, String dataSourceName, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactivePostgreSQLConfig dataSourcesReactivePostgreSQLConfig, ShutdownContext shutdown) {
        PgPool pgPool = this.initialize((Vertx)vertx.getValue(), eventLoopCount.get(), dataSourceName, dataSourcesRuntimeConfig.getDataSourceRuntimeConfig(dataSourceName), dataSourcesReactiveRuntimeConfig.getDataSourceReactiveRuntimeConfig(dataSourceName), dataSourcesReactivePostgreSQLConfig.getDataSourceReactiveRuntimeConfig(dataSourceName));
        shutdown.addShutdownTask(() -> ((PgPool)pgPool).close());
        return new RuntimeValue((Object)pgPool);
    }

    public RuntimeValue<io.vertx.mutiny.pgclient.PgPool> mutinyPgPool(RuntimeValue<PgPool> pgPool) {
        return new RuntimeValue((Object)io.vertx.mutiny.pgclient.PgPool.newInstance((PgPool)((PgPool)pgPool.getValue())));
    }

    private PgPool initialize(Vertx vertx, Integer eventLoopCount, String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactivePostgreSQLConfig dataSourceReactivePostgreSQLConfig) {
        PoolOptions poolOptions = this.toPoolOptions(eventLoopCount, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactivePostgreSQLConfig);
        List<PgConnectOptions> pgConnectOptionsList = this.toPgConnectOptions(dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactivePostgreSQLConfig);
        pgConnectOptionsList.forEach(pgConnectOptions -> pgConnectOptions.setMetricsName("postgresql|" + dataSourceName));
        return this.createPool(vertx, poolOptions, pgConnectOptionsList, dataSourceName);
    }

    private PoolOptions toPoolOptions(Integer eventLoopCount, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactivePostgreSQLConfig dataSourceReactivePostgreSQLConfig) {
        PoolOptions poolOptions = new PoolOptions();
        poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize);
        if (dataSourceReactiveRuntimeConfig.idleTimeout.isPresent()) {
            int idleTimeout = Math.toIntExact(((Duration)dataSourceReactiveRuntimeConfig.idleTimeout.get()).toMillis());
            poolOptions.setIdleTimeout(idleTimeout).setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        }
        if (dataSourceReactiveRuntimeConfig.shared) {
            poolOptions.setShared(true);
            if (dataSourceReactiveRuntimeConfig.name.isPresent()) {
                poolOptions.setName((String)dataSourceReactiveRuntimeConfig.name.get());
            }
        }
        if (dataSourceReactiveRuntimeConfig.eventLoopSize.isPresent()) {
            poolOptions.setEventLoopSize(Math.max(0, dataSourceReactiveRuntimeConfig.eventLoopSize.getAsInt()));
        } else if (eventLoopCount != null) {
            poolOptions.setEventLoopSize(Math.max(0, eventLoopCount));
        }
        return poolOptions;
    }

    private List<PgConnectOptions> toPgConnectOptions(DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactivePostgreSQLConfig dataSourceReactivePostgreSQLConfig) {
        ArrayList<PgConnectOptions> pgConnectOptionsList = new ArrayList<PgConnectOptions>();
        if (dataSourceReactiveRuntimeConfig.url.isPresent()) {
            List urls = (List)dataSourceReactiveRuntimeConfig.url.get();
            urls.forEach(url -> {
                if (url.matches("^vertx-reactive:postgre(?:s|sql)://.*$")) {
                    url = url.substring("vertx-reactive:".length());
                }
                pgConnectOptionsList.add(PgConnectOptions.fromUri((String)url));
            });
        } else {
            pgConnectOptionsList.add(new PgConnectOptions());
        }
        pgConnectOptionsList.forEach(pgConnectOptions -> {
            dataSourceRuntimeConfig.username.ifPresent(arg_0 -> ((PgConnectOptions)pgConnectOptions).setUser(arg_0));
            dataSourceRuntimeConfig.password.ifPresent(arg_0 -> ((PgConnectOptions)pgConnectOptions).setPassword(arg_0));
            if (dataSourceRuntimeConfig.credentialsProvider.isPresent()) {
                String beanName = dataSourceRuntimeConfig.credentialsProviderName.orElse(null);
                CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
                String name = (String)dataSourceRuntimeConfig.credentialsProvider.get();
                Map credentials = credentialsProvider.getCredentials(name);
                String user = (String)credentials.get("user");
                String password = (String)credentials.get("password");
                if (user != null) {
                    pgConnectOptions.setUser(user);
                }
                if (password != null) {
                    pgConnectOptions.setPassword(password);
                }
            }
            pgConnectOptions.setCachePreparedStatements(dataSourceReactiveRuntimeConfig.cachePreparedStatements);
            if (dataSourceReactivePostgreSQLConfig.pipeliningLimit.isPresent()) {
                pgConnectOptions.setPipeliningLimit(dataSourceReactivePostgreSQLConfig.pipeliningLimit.getAsInt());
            }
            if (dataSourceReactivePostgreSQLConfig.sslMode.isPresent()) {
                SslMode sslMode = dataSourceReactivePostgreSQLConfig.sslMode.get();
                pgConnectOptions.setSslMode(sslMode);
                if (sslMode == SslMode.VERIFY_FULL && (!dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm.isPresent() || "".equals(dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm.get()))) {
                    throw new IllegalArgumentException("quarkus.datasource.reactive.hostname-verification-algorithm must be specified under verify-full sslmode");
                }
            }
            pgConnectOptions.setTrustAll(dataSourceReactiveRuntimeConfig.trustAll);
            SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)pgConnectOptions, (PemTrustCertConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePem);
            SSLConfigHelper.configureJksTrustOptions((TCPSSLOptions)pgConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.trustCertificateJks);
            SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)pgConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePfx);
            SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)pgConnectOptions, (PemKeyCertConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePem);
            SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)pgConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.keyCertificateJks);
            SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)pgConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePfx);
            pgConnectOptions.setReconnectAttempts(dataSourceReactiveRuntimeConfig.reconnectAttempts);
            pgConnectOptions.setReconnectInterval(dataSourceReactiveRuntimeConfig.reconnectInterval.toMillis());
            dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm.ifPresent(arg_0 -> ((PgConnectOptions)pgConnectOptions).setHostnameVerificationAlgorithm(arg_0));
            dataSourceReactiveRuntimeConfig.additionalProperties.forEach((arg_0, arg_1) -> ((PgConnectOptions)pgConnectOptions).addProperty(arg_0, arg_1));
        });
        return pgConnectOptionsList;
    }

    private PgPool createPool(Vertx vertx, PoolOptions poolOptions, List<PgConnectOptions> pgConnectOptionsList, String dataSourceName) {
        InjectableInstance instance = DataSourceUtil.isDefault((String)dataSourceName) ? Arc.container().select(PgPoolCreator.class, new Annotation[0]) : Arc.container().select(PgPoolCreator.class, new Annotation[]{new ReactiveDataSource.ReactiveDataSourceLiteral(dataSourceName)});
        if (instance.isResolvable()) {
            DefaultInput input = new DefaultInput(vertx, poolOptions, pgConnectOptionsList);
            return ((PgPoolCreator)instance.get()).create(input);
        }
        return PgPool.pool((Vertx)vertx, pgConnectOptionsList, (PoolOptions)poolOptions);
    }

    private static class DefaultInput
    implements PgPoolCreator.Input {
        private final Vertx vertx;
        private final PoolOptions poolOptions;
        private final List<PgConnectOptions> pgConnectOptionsList;

        public DefaultInput(Vertx vertx, PoolOptions poolOptions, List<PgConnectOptions> pgConnectOptionsList) {
            this.vertx = vertx;
            this.poolOptions = poolOptions;
            this.pgConnectOptionsList = pgConnectOptionsList;
        }

        @Override
        public Vertx vertx() {
            return this.vertx;
        }

        @Override
        public PoolOptions poolOptions() {
            return this.poolOptions;
        }

        @Override
        public List<PgConnectOptions> pgConnectOptionsList() {
            return this.pgConnectOptionsList;
        }
    }
}

