/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.pg.client.runtime;

import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourceSupport;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.ConnectOptionsSupplier;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.ReactiveDataSourceUtil;
import io.quarkus.reactive.datasource.runtime.UnitisedTime;
import io.quarkus.reactive.pg.client.PgPoolCreator;
import io.quarkus.reactive.pg.client.runtime.DataSourceReactivePostgreSQLConfig;
import io.quarkus.reactive.pg.client.runtime.DataSourcesReactivePostgreSQLConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.JksConfiguration;
import io.quarkus.vertx.core.runtime.config.PemKeyCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PemTrustCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PfxConfiguration;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgPool;
import io.vertx.pgclient.SslMode;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.impl.Utils;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

@Recorder
public class PgPoolRecorder {
    private static final TypeLiteral<Instance<PgPoolCreator>> PG_POOL_CREATOR_TYPE_LITERAL = new TypeLiteral<Instance<PgPoolCreator>>(){};

    public Function<SyntheticCreationalContext<PgPool>, PgPool> configurePgPool(final RuntimeValue<Vertx> vertx, final Supplier<Integer> eventLoopCount, final String dataSourceName, final DataSourcesRuntimeConfig dataSourcesRuntimeConfig, final DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, final DataSourcesReactivePostgreSQLConfig dataSourcesReactivePostgreSQLConfig, final ShutdownContext shutdown) {
        return new Function<SyntheticCreationalContext<PgPool>, PgPool>(){

            @Override
            public PgPool apply(SyntheticCreationalContext<PgPool> context) {
                PgPool pgPool = PgPoolRecorder.this.initialize((VertxInternal)vertx.getValue(), (Integer)eventLoopCount.get(), dataSourceName, (DataSourceRuntimeConfig)dataSourcesRuntimeConfig.dataSources().get(dataSourceName), ((DataSourcesReactiveRuntimeConfig.DataSourceReactiveOuterNamedRuntimeConfig)dataSourcesReactiveRuntimeConfig.dataSources().get(dataSourceName)).reactive(), dataSourcesReactivePostgreSQLConfig.dataSources().get(dataSourceName).reactive().postgresql(), context);
                shutdown.addShutdownTask(() -> ((PgPool)pgPool).close());
                return pgPool;
            }
        };
    }

    public Function<SyntheticCreationalContext<io.vertx.mutiny.pgclient.PgPool>, io.vertx.mutiny.pgclient.PgPool> mutinyPgPool(final String dataSourceName) {
        return new Function<SyntheticCreationalContext<io.vertx.mutiny.pgclient.PgPool>, io.vertx.mutiny.pgclient.PgPool>(){

            @Override
            public io.vertx.mutiny.pgclient.PgPool apply(SyntheticCreationalContext context) {
                DataSourceSupport datasourceSupport = (DataSourceSupport)context.getInjectedReference(DataSourceSupport.class, new Annotation[0]);
                if (datasourceSupport.getInactiveNames().contains(dataSourceName)) {
                    throw DataSourceUtil.dataSourceInactive((String)dataSourceName);
                }
                return io.vertx.mutiny.pgclient.PgPool.newInstance((PgPool)((PgPool)context.getInjectedReference(PgPool.class, new Annotation[]{ReactiveDataSourceUtil.qualifier((String)dataSourceName)})));
            }
        };
    }

    private PgPool initialize(VertxInternal vertx, Integer eventLoopCount, String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactivePostgreSQLConfig dataSourceReactivePostgreSQLConfig, SyntheticCreationalContext<PgPool> context) {
        if (((DataSourceSupport)context.getInjectedReference(DataSourceSupport.class, new Annotation[0])).getInactiveNames().contains(dataSourceName)) {
            throw DataSourceUtil.dataSourceInactive((String)dataSourceName);
        }
        PoolOptions poolOptions = this.toPoolOptions(eventLoopCount, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactivePostgreSQLConfig);
        List<PgConnectOptions> pgConnectOptionsList = this.toPgConnectOptions(dataSourceName, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactivePostgreSQLConfig);
        Supplier<Future<PgConnectOptions>> databasesSupplier = this.toDatabasesSupplier((Vertx)vertx, pgConnectOptionsList, dataSourceRuntimeConfig);
        return this.createPool((Vertx)vertx, poolOptions, pgConnectOptionsList, dataSourceName, databasesSupplier, context);
    }

    private Supplier<Future<PgConnectOptions>> toDatabasesSupplier(Vertx vertx, List<PgConnectOptions> pgConnectOptionsList, DataSourceRuntimeConfig dataSourceRuntimeConfig) {
        Supplier supplier;
        if (dataSourceRuntimeConfig.credentialsProvider().isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName().orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider().get();
            supplier = new ConnectOptionsSupplier(vertx, credentialsProvider, name, pgConnectOptionsList, PgConnectOptions::new);
        } else {
            supplier = Utils.roundRobinSupplier(pgConnectOptionsList);
        }
        return supplier;
    }

    private PoolOptions toPoolOptions(Integer eventLoopCount, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactivePostgreSQLConfig dataSourceReactivePostgreSQLConfig) {
        PoolOptions poolOptions = new PoolOptions();
        poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize());
        if (dataSourceReactiveRuntimeConfig.idleTimeout().isPresent()) {
            UnitisedTime idleTimeout = UnitisedTime.unitised((Duration)((Duration)dataSourceReactiveRuntimeConfig.idleTimeout().get()));
            poolOptions.setIdleTimeout(idleTimeout.value).setIdleTimeoutUnit(idleTimeout.unit);
        }
        if (dataSourceReactiveRuntimeConfig.maxLifetime().isPresent()) {
            UnitisedTime maxLifetime = UnitisedTime.unitised((Duration)((Duration)dataSourceReactiveRuntimeConfig.maxLifetime().get()));
            poolOptions.setMaxLifetime(maxLifetime.value).setMaxLifetimeUnit(maxLifetime.unit);
        }
        if (dataSourceReactiveRuntimeConfig.shared()) {
            poolOptions.setShared(true);
            if (dataSourceReactiveRuntimeConfig.name().isPresent()) {
                poolOptions.setName((String)dataSourceReactiveRuntimeConfig.name().get());
            }
        }
        if (dataSourceReactiveRuntimeConfig.eventLoopSize().isPresent()) {
            poolOptions.setEventLoopSize(Math.max(0, dataSourceReactiveRuntimeConfig.eventLoopSize().getAsInt()));
        } else if (eventLoopCount != null) {
            poolOptions.setEventLoopSize(Math.max(0, eventLoopCount));
        }
        return poolOptions;
    }

    private List<PgConnectOptions> toPgConnectOptions(String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactivePostgreSQLConfig dataSourceReactivePostgreSQLConfig) {
        ArrayList<PgConnectOptions> pgConnectOptionsList = new ArrayList<PgConnectOptions>();
        if (dataSourceReactiveRuntimeConfig.url().isPresent()) {
            List urls = (List)dataSourceReactiveRuntimeConfig.url().get();
            urls.forEach(url -> {
                if (url.matches("^vertx-reactive:postgre(?:s|sql)://.*$")) {
                    url = url.substring("vertx-reactive:".length());
                }
                pgConnectOptionsList.add(PgConnectOptions.fromUri((String)url));
            });
        } else {
            pgConnectOptionsList.add(new PgConnectOptions());
        }
        pgConnectOptionsList.forEach(pgConnectOptions -> {
            dataSourceRuntimeConfig.username().ifPresent(arg_0 -> ((PgConnectOptions)pgConnectOptions).setUser(arg_0));
            dataSourceRuntimeConfig.password().ifPresent(arg_0 -> ((PgConnectOptions)pgConnectOptions).setPassword(arg_0));
            if (dataSourceRuntimeConfig.credentialsProvider().isPresent()) {
                String beanName = dataSourceRuntimeConfig.credentialsProviderName().orElse(null);
                CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
                String name = (String)dataSourceRuntimeConfig.credentialsProvider().get();
                Map credentials = credentialsProvider.getCredentials(name);
                String user = (String)credentials.get("user");
                String password = (String)credentials.get("password");
                if (user != null) {
                    pgConnectOptions.setUser(user);
                }
                if (password != null) {
                    pgConnectOptions.setPassword(password);
                }
            }
            pgConnectOptions.setCachePreparedStatements(dataSourceReactiveRuntimeConfig.cachePreparedStatements());
            if (dataSourceReactivePostgreSQLConfig.pipeliningLimit().isPresent()) {
                pgConnectOptions.setPipeliningLimit(dataSourceReactivePostgreSQLConfig.pipeliningLimit().getAsInt());
            }
            if (dataSourceReactivePostgreSQLConfig.sslMode().isPresent()) {
                SslMode sslMode = dataSourceReactivePostgreSQLConfig.sslMode().get();
                pgConnectOptions.setSslMode(sslMode);
                String algo = dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm();
                if ("NONE".equalsIgnoreCase(algo) && sslMode == SslMode.VERIFY_FULL) {
                    throw new IllegalArgumentException("quarkus.datasource.reactive.hostname-verification-algorithm must be specified under verify-full sslmode");
                }
            }
            pgConnectOptions.setUseLayer7Proxy(dataSourceReactivePostgreSQLConfig.useLayer7Proxy());
            pgConnectOptions.setTrustAll(dataSourceReactiveRuntimeConfig.trustAll());
            SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)pgConnectOptions, (PemTrustCertConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePem());
            SSLConfigHelper.configureJksTrustOptions((TCPSSLOptions)pgConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.trustCertificateJks());
            SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)pgConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePfx());
            SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)pgConnectOptions, (PemKeyCertConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePem());
            SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)pgConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.keyCertificateJks());
            SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)pgConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePfx());
            pgConnectOptions.setReconnectAttempts(dataSourceReactiveRuntimeConfig.reconnectAttempts());
            pgConnectOptions.setReconnectInterval(dataSourceReactiveRuntimeConfig.reconnectInterval().toMillis());
            String algo = dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm();
            if ("NONE".equalsIgnoreCase(algo)) {
                pgConnectOptions.setHostnameVerificationAlgorithm("");
            } else {
                pgConnectOptions.setHostnameVerificationAlgorithm(algo);
            }
            dataSourceReactiveRuntimeConfig.additionalProperties().forEach((arg_0, arg_1) -> ((PgConnectOptions)pgConnectOptions).addProperty(arg_0, arg_1));
            pgConnectOptions.setMetricsName("postgresql|" + dataSourceName);
        });
        return pgConnectOptionsList;
    }

    private PgPool createPool(Vertx vertx, PoolOptions poolOptions, List<PgConnectOptions> pgConnectOptionsList, String dataSourceName, Supplier<Future<PgConnectOptions>> databases, SyntheticCreationalContext<PgPool> context) {
        Instance instance = (Instance)context.getInjectedReference(PG_POOL_CREATOR_TYPE_LITERAL, new Annotation[]{ReactiveDataSourceUtil.qualifier((String)dataSourceName)});
        if (instance.isResolvable()) {
            DefaultInput input = new DefaultInput(vertx, poolOptions, pgConnectOptionsList);
            return ((PgPoolCreator)instance.get()).create(input);
        }
        return PgPool.pool((Vertx)vertx, databases, (PoolOptions)poolOptions);
    }

    private static class DefaultInput
    implements PgPoolCreator.Input {
        private final Vertx vertx;
        private final PoolOptions poolOptions;
        private final List<PgConnectOptions> pgConnectOptionsList;

        public DefaultInput(Vertx vertx, PoolOptions poolOptions, List<PgConnectOptions> pgConnectOptionsList) {
            this.vertx = vertx;
            this.poolOptions = poolOptions;
            this.pgConnectOptionsList = pgConnectOptionsList;
        }

        @Override
        public Vertx vertx() {
            return this.vertx;
        }

        @Override
        public PoolOptions poolOptions() {
            return this.poolOptions;
        }

        @Override
        public List<PgConnectOptions> pgConnectOptionsList() {
            return this.pgConnectOptionsList;
        }
    }
}

