/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.redis.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.cache.CompositeCacheKey;
import io.quarkus.cache.deployment.CacheDeploymentConstants;
import io.quarkus.cache.deployment.CacheNamesBuildItem;
import io.quarkus.cache.deployment.spi.CacheManagerInfoBuildItem;
import io.quarkus.cache.redis.runtime.RedisCacheBuildRecorder;
import io.quarkus.cache.redis.runtime.RedisCacheBuildTimeConfig;
import io.quarkus.cache.redis.runtime.RedisCachesBuildTimeConfig;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.types.TypeParser;
import io.quarkus.redis.deployment.client.RequestedRedisClientBuildItem;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.redis.client.Redis;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class RedisCacheProcessor {
    private static final Logger LOGGER = Logger.getLogger(RedisCacheProcessor.class);
    public static final DotName UNI = DotName.createSimple((String)Uni.class.getName());

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    CacheManagerInfoBuildItem cacheManagerInfo(RedisCacheBuildRecorder recorder) {
        return new CacheManagerInfoBuildItem(recorder.getCacheManagerSupplier());
    }

    @BuildStep
    UnremovableBeanBuildItem redisClientUnremoveable() {
        return UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{io.vertx.redis.client.Redis.class, Redis.class});
    }

    @BuildStep
    RequestedRedisClientBuildItem requestedRedisClientBuildItem(RedisCachesBuildTimeConfig buildConfig) {
        return new RequestedRedisClientBuildItem(buildConfig.clientName.orElse("<default>"));
    }

    @BuildStep
    void nativeImage(BuildProducer<ReflectiveClassBuildItem> producer) {
        producer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{CompositeCacheKey.class}).reason(this.getClass().getName()).methods().build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void determineKeyValueTypes(RedisCacheBuildRecorder recorder, CombinedIndexBuildItem combinedIndex, CacheNamesBuildItem cacheNamesBuildItem, RedisCachesBuildTimeConfig buildConfig) {
        HashMap<String, Type> keyTypes = new HashMap<String, Type>();
        RedisCacheBuildTimeConfig defaultBuildTimeConfig = buildConfig.defaultConfig;
        for (String cacheName : cacheNamesBuildItem.getNames()) {
            RedisCacheBuildTimeConfig namedBuildTimeConfig = (RedisCacheBuildTimeConfig)buildConfig.cachesConfig.get(cacheName);
            if (namedBuildTimeConfig != null && namedBuildTimeConfig.keyType.isPresent()) {
                keyTypes.put(cacheName, TypeParser.parse((String)((String)namedBuildTimeConfig.keyType.get())));
                continue;
            }
            if (!defaultBuildTimeConfig.keyType.isPresent()) continue;
            keyTypes.put(cacheName, TypeParser.parse((String)((String)defaultBuildTimeConfig.keyType.get())));
        }
        recorder.setCacheKeyTypes(keyTypes);
        Map<String, org.jboss.jandex.Type> resolvedValuesTypesFromAnnotations = RedisCacheProcessor.valueTypesFromCacheResultAnnotation(combinedIndex);
        HashMap<String, Type> valueTypes = new HashMap<String, Type>();
        Optional defaultValueType = buildConfig.defaultConfig.valueType;
        Set cacheNames = cacheNamesBuildItem.getNames();
        for (String cacheName : cacheNames) {
            String valueType = null;
            RedisCacheBuildTimeConfig cacheSpecificGroup = (RedisCacheBuildTimeConfig)buildConfig.cachesConfig.get(cacheName);
            if (cacheSpecificGroup == null) {
                if (defaultValueType.isPresent()) {
                    valueType = (String)defaultValueType.get();
                }
            } else if (cacheSpecificGroup.valueType.isPresent()) {
                valueType = (String)cacheSpecificGroup.valueType.get();
            }
            if (valueType == null && resolvedValuesTypesFromAnnotations.containsKey(cacheName)) {
                valueType = RedisCacheProcessor.typeToString(resolvedValuesTypesFromAnnotations.get(cacheName));
            }
            if (valueType != null) {
                valueTypes.put(cacheName, TypeParser.parse((String)valueType));
                continue;
            }
            throw new DeploymentException("Unable to determine the value type for '" + cacheName + "' Redis cache. An appropriate configuration value for 'quarkus.cache.redis." + cacheName + ".value-type' needs to be set");
        }
        recorder.setCacheValueTypes(valueTypes);
    }

    private static Map<String, org.jboss.jandex.Type> valueTypesFromCacheResultAnnotation(CombinedIndexBuildItem combinedIndex) {
        HashMap<String, HashSet<org.jboss.jandex.Type>> valueTypesFromAnnotations = new HashMap<String, HashSet<org.jboss.jandex.Type>>();
        for (AnnotationInstance instance : combinedIndex.getIndex().getAnnotations(CacheDeploymentConstants.CACHE_RESULT)) {
            AnnotationValue cacheNameValue;
            org.jboss.jandex.Type methodReturnType;
            if (instance.target().kind() != AnnotationTarget.Kind.METHOD || (methodReturnType = instance.target().asMethod().returnType()).kind() == Type.Kind.VOID || (cacheNameValue = instance.value("cacheName")) == null) continue;
            String cacheName = cacheNameValue.asString();
            HashSet<org.jboss.jandex.Type> types = (HashSet<org.jboss.jandex.Type>)valueTypesFromAnnotations.get(cacheName);
            if (types == null) {
                types = new HashSet<org.jboss.jandex.Type>(1);
                valueTypesFromAnnotations.put(cacheName, types);
            }
            types.add(methodReturnType);
        }
        if (valueTypesFromAnnotations.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, org.jboss.jandex.Type> result = new HashMap<String, org.jboss.jandex.Type>();
        for (Map.Entry entry : valueTypesFromAnnotations.entrySet()) {
            String cacheName = (String)entry.getKey();
            Set typeSet = (Set)entry.getValue();
            if (typeSet.size() != 1) {
                LOGGER.debugv("Cache named '{0}' is used on methods with different result types", (Object)cacheName);
                continue;
            }
            org.jboss.jandex.Type type = (org.jboss.jandex.Type)typeSet.iterator().next();
            org.jboss.jandex.Type resolvedType = null;
            if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && UNI.equals((Object)type.name())) {
                ParameterizedType parameterizedType = type.asParameterizedType();
                List arguments = parameterizedType.arguments();
                if (arguments.size() == 1) {
                    resolvedType = (org.jboss.jandex.Type)arguments.get(0);
                }
            } else {
                resolvedType = type;
            }
            if (resolvedType != null) {
                result.put(cacheName, resolvedType);
                continue;
            }
            LOGGER.debugv("Cache named '{0}' is used on method whose return type '{1}' is not eligible for automatic resolution", (Object)cacheName, (Object)type);
        }
        return result;
    }

    private static String typeToString(org.jboss.jandex.Type type) {
        StringBuilder result = new StringBuilder();
        RedisCacheProcessor.typeToString(type, result);
        return result.toString();
    }

    private static void typeToString(org.jboss.jandex.Type type, StringBuilder result) {
        switch (type.kind()) {
            case VOID: 
            case PRIMITIVE: 
            case CLASS: {
                result.append(type.name().toString());
                break;
            }
            case ARRAY: {
                RedisCacheProcessor.typeToString(type.asArrayType().elementType(), result);
                result.append("[]".repeat(type.asArrayType().deepDimensions()));
                break;
            }
            case PARAMETERIZED_TYPE: {
                if (type.asParameterizedType().owner() != null) {
                    throw new IllegalArgumentException("Unsupported type: " + type);
                }
                result.append(type.name().toString());
                result.append('<');
                boolean first = true;
                for (org.jboss.jandex.Type typeArgument : type.asParameterizedType().arguments()) {
                    if (!first) {
                        result.append(", ");
                    }
                    RedisCacheProcessor.typeToString(typeArgument, result);
                    first = false;
                }
                result.append('>');
                break;
            }
            case WILDCARD_TYPE: {
                result.append('?');
                if (type.asWildcardType().superBound() != null) {
                    result.append(" super ");
                    RedisCacheProcessor.typeToString(type.asWildcardType().superBound(), result);
                    break;
                }
                if (type.asWildcardType().extendsBound() == ClassType.OBJECT_TYPE) break;
                result.append(" extends ");
                RedisCacheProcessor.typeToString(type.asWildcardType().extendsBound(), result);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + type);
            }
        }
    }
}

