/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.redis.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.cache.CompositeCacheKey;
import io.quarkus.cache.deployment.CacheDeploymentConstants;
import io.quarkus.cache.deployment.CacheNamesBuildItem;
import io.quarkus.cache.deployment.spi.CacheManagerInfoBuildItem;
import io.quarkus.cache.redis.runtime.RedisCacheBuildRecorder;
import io.quarkus.cache.redis.runtime.RedisCacheBuildTimeConfig;
import io.quarkus.cache.redis.runtime.RedisCachesBuildTimeConfig;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.redis.client.deployment.RequestedRedisClientBuildItem;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.redis.client.Redis;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class RedisCacheProcessor {
    private static final Logger LOGGER = Logger.getLogger(RedisCacheProcessor.class);
    public static final DotName UNI = DotName.createSimple((String)Uni.class.getName());

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    CacheManagerInfoBuildItem cacheManagerInfo(RedisCacheBuildRecorder recorder) {
        return new CacheManagerInfoBuildItem(recorder.getCacheManagerSupplier());
    }

    @BuildStep
    UnremovableBeanBuildItem redisClientUnremoveable() {
        return UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{io.vertx.redis.client.Redis.class, Redis.class});
    }

    @BuildStep
    RequestedRedisClientBuildItem requestedRedisClientBuildItem(RedisCachesBuildTimeConfig buildConfig) {
        return new RequestedRedisClientBuildItem(buildConfig.clientName.orElse("<default>"));
    }

    @BuildStep
    void nativeImage(BuildProducer<ReflectiveClassBuildItem> producer) {
        producer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{CompositeCacheKey.class}).methods(true).build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void determineValueTypes(RedisCacheBuildRecorder recorder, CombinedIndexBuildItem combinedIndex, CacheNamesBuildItem cacheNamesBuildItem, RedisCachesBuildTimeConfig buildConfig) {
        Map<String, String> resolvedValuesTypesFromAnnotations = RedisCacheProcessor.valueTypesFromCacheResultAnnotation(combinedIndex);
        HashMap<String, String> valueTypes = new HashMap<String, String>();
        Optional defaultValueType = buildConfig.defaultConfig.valueType;
        Set cacheNames = cacheNamesBuildItem.getNames();
        for (String cacheName : cacheNames) {
            String valueType = null;
            RedisCacheBuildTimeConfig cacheSpecificGroup = (RedisCacheBuildTimeConfig)buildConfig.cachesConfig.get(cacheName);
            if (cacheSpecificGroup == null) {
                if (defaultValueType.isPresent()) {
                    valueType = (String)defaultValueType.get();
                }
            } else if (cacheSpecificGroup.valueType.isPresent()) {
                valueType = (String)cacheSpecificGroup.valueType.get();
            }
            if (valueType == null) {
                valueType = resolvedValuesTypesFromAnnotations.get(cacheName);
            }
            if (valueType != null) {
                valueTypes.put(cacheName, valueType);
                continue;
            }
            throw new DeploymentException("Unable to determine the value type for '" + cacheName + "' Redis cache. An appropriate configuration value for 'quarkus.cache.redis." + cacheName + ".value-type' needs to be set");
        }
        recorder.setCacheValueTypes(valueTypes);
    }

    private static Map<String, String> valueTypesFromCacheResultAnnotation(CombinedIndexBuildItem combinedIndex) {
        HashMap<String, HashSet<Type>> valueTypesFromAnnotations = new HashMap<String, HashSet<Type>>();
        for (AnnotationInstance instance : combinedIndex.getIndex().getAnnotations(CacheDeploymentConstants.CACHE_RESULT)) {
            AnnotationValue cacheNameValue;
            Type methodReturnType;
            if (instance.target().kind() != AnnotationTarget.Kind.METHOD || (methodReturnType = instance.target().asMethod().returnType()).kind() == Type.Kind.VOID || (cacheNameValue = instance.value("cacheName")) == null) continue;
            String cacheName = cacheNameValue.asString();
            HashSet<Type> types = (HashSet<Type>)valueTypesFromAnnotations.get(cacheName);
            if (types == null) {
                types = new HashSet<Type>(1);
                valueTypesFromAnnotations.put(cacheName, types);
            }
            types.add(methodReturnType);
        }
        if (valueTypesFromAnnotations.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : valueTypesFromAnnotations.entrySet()) {
            ParameterizedType parameterizedType;
            List arguments;
            String cacheName = (String)entry.getKey();
            Set typeSet = (Set)entry.getValue();
            if (typeSet.size() != 1) {
                LOGGER.debugv("Cache named '{0}' is used on methods with different result types", (Object)cacheName);
                continue;
            }
            Type type = (Type)typeSet.iterator().next();
            String resolvedType = null;
            if (type.kind() == Type.Kind.CLASS) {
                resolvedType = type.asClassType().name().toString();
            } else if (type.kind() == Type.Kind.PRIMITIVE) {
                resolvedType = type.asPrimitiveType().name().toString();
            } else if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && UNI.equals((Object)type.name()) && (arguments = (parameterizedType = type.asParameterizedType()).arguments()).size() == 1) {
                resolvedType = ((Type)arguments.get(0)).name().toString();
            }
            if (resolvedType != null) {
                result.put(cacheName, resolvedType);
                continue;
            }
            LOGGER.debugv("Cache named '{0}' is used on method whose return type '{1}' is not eligible for automatic resolution", (Object)cacheName, (Object)type);
        }
        return result;
    }
}

