/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.redis.runtime;

import io.quarkus.cache.redis.runtime.RedisCacheBuildTimeConfig;
import io.quarkus.cache.redis.runtime.RedisCacheInfo;
import io.quarkus.cache.redis.runtime.RedisCacheRuntimeConfig;
import io.quarkus.cache.redis.runtime.RedisCachesBuildTimeConfig;
import io.quarkus.cache.redis.runtime.RedisCachesConfig;
import io.quarkus.runtime.configuration.HashSetFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RedisCacheInfoBuilder {
    public static Set<RedisCacheInfo> build(Set<String> cacheNames, RedisCachesBuildTimeConfig buildTimeConfig, RedisCachesConfig runtimeConfig, Map<String, String> valueTypes) {
        if (cacheNames.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.getInstance().apply(cacheNames.size());
        for (String cacheName : cacheNames) {
            RedisCacheInfo cacheInfo = new RedisCacheInfo();
            cacheInfo.name = cacheName;
            RedisCacheRuntimeConfig defaultRuntimeConfig = runtimeConfig.defaultConfig;
            RedisCacheRuntimeConfig namedRuntimeConfig = runtimeConfig.cachesConfig.get(cacheInfo.name);
            if (namedRuntimeConfig != null && namedRuntimeConfig.ttl.isPresent()) {
                cacheInfo.ttl = namedRuntimeConfig.ttl;
            } else if (defaultRuntimeConfig.ttl.isPresent()) {
                cacheInfo.ttl = defaultRuntimeConfig.ttl;
            }
            if (namedRuntimeConfig != null && namedRuntimeConfig.prefix.isPresent()) {
                cacheInfo.prefix = namedRuntimeConfig.prefix.get();
            } else if (defaultRuntimeConfig.prefix.isPresent()) {
                cacheInfo.prefix = defaultRuntimeConfig.prefix.get();
            }
            cacheInfo.valueType = valueTypes.get(cacheName);
            RedisCacheBuildTimeConfig defaultBuildTimeConfig = buildTimeConfig.defaultConfig;
            RedisCacheBuildTimeConfig namedBuildTimeConfig = buildTimeConfig.cachesConfig.get(cacheInfo.name);
            if (namedBuildTimeConfig != null && namedBuildTimeConfig.keyType.isPresent()) {
                cacheInfo.keyType = namedBuildTimeConfig.keyType.get();
            } else if (defaultBuildTimeConfig.keyType.isPresent()) {
                cacheInfo.keyType = defaultBuildTimeConfig.keyType.get();
            }
            if (namedRuntimeConfig != null && namedRuntimeConfig.useOptimisticLocking.isPresent()) {
                cacheInfo.useOptimisticLocking = namedRuntimeConfig.useOptimisticLocking.get();
            } else if (defaultRuntimeConfig.useOptimisticLocking.isPresent()) {
                cacheInfo.useOptimisticLocking = defaultRuntimeConfig.useOptimisticLocking.get();
            }
            result.add(cacheInfo);
        }
        return result;
    }
}

