/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.redis.runtime;

import io.quarkus.cache.CacheManager;
import io.quarkus.cache.CacheManagerInfo;
import io.quarkus.cache.redis.runtime.RedisCacheImpl;
import io.quarkus.cache.redis.runtime.RedisCacheInfo;
import io.quarkus.cache.redis.runtime.RedisCacheInfoBuilder;
import io.quarkus.cache.redis.runtime.RedisCachesBuildTimeConfig;
import io.quarkus.cache.redis.runtime.RedisCachesConfig;
import io.quarkus.cache.runtime.CacheManagerImpl;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class RedisCacheBuildRecorder {
    private static final Logger LOGGER = Logger.getLogger(RedisCacheBuildRecorder.class);
    private final RedisCachesBuildTimeConfig buildConfig;
    private final RuntimeValue<RedisCachesConfig> redisCacheConfigRV;
    private static Map<String, Type> keyTypes;
    private static Map<String, Type> valueTypes;

    public RedisCacheBuildRecorder(RedisCachesBuildTimeConfig buildConfig, RuntimeValue<RedisCachesConfig> redisCacheConfigRV) {
        this.buildConfig = buildConfig;
        this.redisCacheConfigRV = redisCacheConfigRV;
    }

    public CacheManagerInfo getCacheManagerSupplier() {
        return new CacheManagerInfo(){

            public boolean supports(CacheManagerInfo.Context context) {
                return context.cacheEnabled() && "redis".equals(context.cacheType());
            }

            public Supplier<CacheManager> get(final CacheManagerInfo.Context context) {
                return new Supplier<CacheManager>(){

                    @Override
                    public CacheManager get() {
                        Set<RedisCacheInfo> cacheInfos = RedisCacheInfoBuilder.build(context.cacheNames(), (RedisCachesConfig)RedisCacheBuildRecorder.this.redisCacheConfigRV.getValue(), keyTypes, valueTypes);
                        if (cacheInfos.isEmpty()) {
                            return new CacheManagerImpl(Collections.emptyMap());
                        }
                        HashMap<String, RedisCacheImpl> caches = new HashMap<String, RedisCacheImpl>(cacheInfos.size() + 1, 1.0f);
                        for (RedisCacheInfo cacheInfo : cacheInfos) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debugf("Building Redis cache [%s] with [ttl=%s], [prefix=%s], [classOfItems=%s]", new Object[]{cacheInfo.name, cacheInfo.expireAfterAccess, cacheInfo.prefix, cacheInfo.valueType});
                            }
                            RedisCacheImpl cache = new RedisCacheImpl(cacheInfo, RedisCacheBuildRecorder.this.buildConfig.clientName);
                            caches.put(cacheInfo.name, cache);
                        }
                        return new CacheManagerImpl(caches);
                    }
                };
            }
        };
    }

    public void setCacheKeyTypes(Map<String, Type> keyTypes) {
        RedisCacheBuildRecorder.keyTypes = keyTypes;
    }

    public void setCacheValueTypes(Map<String, Type> valueTypes) {
        RedisCacheBuildRecorder.valueTypes = valueTypes;
    }
}

