/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.redis.runtime;

import io.quarkus.cache.Cache;
import io.smallrye.mutiny.Uni;
import java.util.function.Function;
import java.util.function.Supplier;

public interface RedisCache
extends Cache {
    public Class<?> getDefaultValueType();

    default public <K, V> Uni<V> get(K key, Function<K, V> valueLoader) {
        Class<?> type = this.getDefaultValueType();
        if (type == null) {
            throw new UnsupportedOperationException("Cannot use `get` method without a default type configured. Consider using the `get` method accepting the type or configure the default type for the cache " + this.getName());
        }
        return this.get(key, type, valueLoader);
    }

    default public <K, V> Uni<V> getAsync(K key, Function<K, Uni<V>> valueLoader) {
        Class<?> type = this.getDefaultValueType();
        if (type == null) {
            throw new UnsupportedOperationException("Cannot use `getAsync` method without a default type configured. Consider using the `getAsync` method accepting the type or configure the default type for the cache " + this.getName());
        }
        return this.getAsync(key, type, valueLoader);
    }

    public <K, V> Uni<V> get(K var1, Class<V> var2, Function<K, V> var3);

    public <K, V> Uni<V> getAsync(K var1, Class<V> var2, Function<K, Uni<V>> var3);

    default public <K, V> Uni<Void> put(K key, final V value) {
        return this.put(key, new Supplier<V>(){

            @Override
            public V get() {
                return value;
            }
        });
    }

    public <K, V> Uni<Void> put(K var1, Supplier<V> var2);

    public <K, V> Uni<V> getOrDefault(K var1, V var2);

    public <K, V> Uni<V> getOrNull(K var1, Class<V> var2);
}

