/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.client.deployment;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.DevServicesNativeConfigResultBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.redis.client.deployment.DevServicesConfig;
import io.quarkus.redis.client.deployment.RedisBuildTimeConfig;
import io.quarkus.redis.client.runtime.RedisClientUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class DevServicesProcessor {
    private static final Logger log = Logger.getLogger(DevServicesProcessor.class);
    private static final String REDIS_6_ALPINE = "redis:6-alpine";
    private static final int REDIS_EXPOSED_PORT = 6379;
    private static final String REDIS_SCHEME = "redis://";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-redis";
    private static final ContainerLocator redisContainerLocator = new ContainerLocator("quarkus-dev-service-redis", 6379);
    private static final String QUARKUS = "quarkus.";
    private static final String DOT = ".";
    private static volatile List<Closeable> closeables;
    private static volatile Map<String, RedisBuildTimeConfig.DevServiceConfiguration> capturedDevServicesConfiguration;
    private static volatile boolean first;

    @Produce(value=ServiceStartBuildItem.class)
    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={IsDockerWorking.IsDockerRunningSilent.class})
    public void startRedisContainers(LaunchModeBuildItem launchMode, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration, BuildProducer<DevServicesNativeConfigResultBuildItem> devConfigProducer, RedisBuildTimeConfig config) {
        HashMap<String, RedisBuildTimeConfig.DevServiceConfiguration> currentDevServicesConfiguration = new HashMap<String, RedisBuildTimeConfig.DevServiceConfiguration>(config.additionalDevServices);
        currentDevServicesConfiguration.put("<default>", config.defaultDevService);
        if (closeables != null) {
            boolean restartRequired;
            boolean bl = restartRequired = launchMode.getLaunchMode() == LaunchMode.TEST;
            if (!restartRequired) {
                boolean bl2 = restartRequired = !currentDevServicesConfiguration.equals(capturedDevServicesConfiguration);
            }
            if (!restartRequired) {
                return;
            }
            for (Closeable closeable : closeables) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop redis container", e);
                }
            }
            closeables = null;
            capturedDevServicesConfiguration = null;
        }
        capturedDevServicesConfiguration = currentDevServicesConfiguration;
        ArrayList<Closeable> currentCloseables = new ArrayList<Closeable>();
        for (Map.Entry entry : currentDevServicesConfiguration.entrySet()) {
            String connectionName = (String)entry.getKey();
            StartResult startResult = this.startContainer(connectionName, ((RedisBuildTimeConfig.DevServiceConfiguration)entry.getValue()).devservices, launchMode.getLaunchMode());
            if (startResult == null) continue;
            currentCloseables.add(startResult.closeable);
            String configKey = this.getConfigPrefix(connectionName) + "hosts";
            runTimeConfiguration.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(configKey, startResult.url));
            devConfigProducer.produce((BuildItem)new DevServicesNativeConfigResultBuildItem(configKey, startResult.url));
        }
        closeables = currentCloseables;
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (closeables != null) {
                    for (Closeable closeable : closeables) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable t) {
                            log.error((Object)"Failed to stop database", t);
                        }
                    }
                }
                first = true;
                closeables = null;
                capturedDevServicesConfiguration = null;
            };
            QuarkusClassLoader quarkusClassLoader = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            ((QuarkusClassLoader)quarkusClassLoader.parent()).addCloseTask(closeTask);
            Thread closeHookThread = new Thread(closeTask, "Redis container shutdown thread");
            Runtime.getRuntime().addShutdownHook(closeHookThread);
            ((QuarkusClassLoader)quarkusClassLoader.parent()).addCloseTask(() -> Runtime.getRuntime().removeShutdownHook(closeHookThread));
        }
    }

    private StartResult startContainer(String connectionName, DevServicesConfig devServicesConfig, LaunchMode launchMode) {
        boolean needToStart;
        if (!devServicesConfig.enabled) {
            log.debug((Object)("Not starting devservices for " + (RedisClientUtil.isDefault((String)connectionName) ? "default redis client" : connectionName) + " as it has been disabled in the config"));
            return null;
        }
        String configPrefix = this.getConfigPrefix(connectionName);
        boolean bl = needToStart = !ConfigUtils.isPropertyPresent((String)(configPrefix + "hosts"));
        if (!needToStart) {
            log.debug((Object)("Not starting devservices for " + (RedisClientUtil.isDefault((String)connectionName) ? "default redis client" : connectionName) + " as hosts have been provided"));
            return null;
        }
        DockerImageName dockerImageName = DockerImageName.parse((String)devServicesConfig.imageName.orElse(REDIS_6_ALPINE)).asCompatibleSubstituteFor(REDIS_6_ALPINE);
        Supplier<StartResult> defaultRedisServerSupplier = () -> {
            FixedPortRedisContainer redisContainer = new FixedPortRedisContainer(dockerImageName, devServicesConfig.port, launchMode == LaunchMode.DEVELOPMENT ? devServicesConfig.serviceName : null);
            redisContainer.start();
            String redisHost = REDIS_SCHEME + redisContainer.getHost() + ":" + redisContainer.getPort();
            return new StartResult(redisHost, () -> ((FixedPortRedisContainer)redisContainer).close());
        };
        return redisContainerLocator.locateContainer(devServicesConfig.serviceName, devServicesConfig.shared, launchMode).map(containerAddress -> new StartResult(containerAddress.getUrl(), null)).orElseGet(defaultRedisServerSupplier);
    }

    private String getConfigPrefix(String connectionName) {
        Object configPrefix = "quarkus.redis.";
        if (!RedisClientUtil.isDefault((String)connectionName)) {
            configPrefix = (String)configPrefix + connectionName + DOT;
        }
        return configPrefix;
    }

    static {
        first = true;
    }

    private static class FixedPortRedisContainer
    extends GenericContainer<FixedPortRedisContainer> {
        OptionalInt fixedExposedPort;

        public FixedPortRedisContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort, String serviceName) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
            if (serviceName != null) {
                this.withLabel(DevServicesProcessor.DEV_SERVICE_LABEL, serviceName);
            }
        }

        protected void configure() {
            super.configure();
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 6379);
            } else {
                this.addExposedPort(6379);
            }
        }

        public int getPort() {
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getFirstMappedPort();
        }
    }

    private static class StartResult {
        private final String url;
        private final Closeable closeable;

        public StartResult(String url, Closeable closeable) {
            this.url = url;
            this.closeable = closeable;
        }
    }
}

