/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.client.deployment;

import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.redis.client.deployment.DevServicesConfig;
import io.quarkus.redis.client.deployment.RedisBuildTimeConfig;
import io.quarkus.redis.client.runtime.RedisClientUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class DevServicesRedisProcessor {
    private static final Logger log = Logger.getLogger(DevServicesRedisProcessor.class);
    private static final String REDIS_6_ALPINE = "docker.io/redis:6-alpine";
    private static final int REDIS_EXPOSED_PORT = 6379;
    private static final String REDIS_SCHEME = "redis://";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-redis";
    private static final ContainerLocator redisContainerLocator = new ContainerLocator("quarkus-dev-service-redis", 6379);
    private static final String QUARKUS = "quarkus.";
    private static final String DOT = ".";
    private static volatile List<DevServicesResultBuildItem.RunningDevService> devServices;
    private static volatile Map<String, RedisBuildTimeConfig.DevServiceConfiguration> capturedDevServicesConfiguration;
    private static volatile boolean first;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public List<DevServicesResultBuildItem> startRedisContainers(LaunchModeBuildItem launchMode, DockerStatusBuildItem dockerStatusBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, RedisBuildTimeConfig config, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        HashMap<String, RedisBuildTimeConfig.DevServiceConfiguration> currentDevServicesConfiguration = new HashMap<String, RedisBuildTimeConfig.DevServiceConfiguration>(config.additionalDevServices);
        currentDevServicesConfiguration.put("<default>", config.defaultDevService);
        if (devServices != null) {
            boolean restartRequired;
            boolean bl = restartRequired = !currentDevServicesConfiguration.equals(capturedDevServicesConfiguration);
            if (!restartRequired) {
                return devServices.stream().map(DevServicesResultBuildItem.RunningDevService::toBuildItem).collect(Collectors.toList());
            }
            for (Closeable closeable : devServices) {
                try {
                    closeable.close();
                }
                catch (Throwable throwable) {
                    log.error((Object)"Failed to stop redis container", throwable);
                }
            }
            devServices = null;
            capturedDevServicesConfiguration = null;
        }
        capturedDevServicesConfiguration = currentDevServicesConfiguration;
        ArrayList<DevServicesResultBuildItem.RunningDevService> newDevServices = new ArrayList<DevServicesResultBuildItem.RunningDevService>();
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Redis Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            for (Map.Entry entry : currentDevServicesConfiguration.entrySet()) {
                String connectionName = (String)entry.getKey();
                DevServicesResultBuildItem.RunningDevService devService = this.startContainer(dockerStatusBuildItem, connectionName, ((RedisBuildTimeConfig.DevServiceConfiguration)entry.getValue()).devservices, launchMode.getLaunchMode(), !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout);
                if (devService == null) continue;
                newDevServices.add(devService);
                String configKey = this.getConfigPrefix(connectionName) + "hosts";
                log.infof("The %s redis server is ready to accept connections on %s", (Object)connectionName, devService.getConfig().get(configKey));
            }
            if (newDevServices.isEmpty()) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable throwable) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(throwable);
        }
        devServices = newDevServices;
        if (first) {
            first = false;
            Runnable runnable = () -> {
                if (devServices != null) {
                    for (Closeable closeable : devServices) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable t) {
                            log.error((Object)"Failed to stop database", t);
                        }
                    }
                }
                first = true;
                devServices = null;
                capturedDevServicesConfiguration = null;
            };
            closeBuildItem.addCloseTask(runnable, true);
        }
        return devServices.stream().map(DevServicesResultBuildItem.RunningDevService::toBuildItem).collect(Collectors.toList());
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(DockerStatusBuildItem dockerStatusBuildItem, String connectionName, DevServicesConfig devServicesConfig, LaunchMode launchMode, boolean useSharedNetwork, Optional<Duration> timeout) {
        boolean needToStart;
        if (!devServicesConfig.enabled) {
            log.debug((Object)("Not starting devservices for " + (RedisClientUtil.isDefault((String)connectionName) ? "default redis client" : connectionName) + " as it has been disabled in the config"));
            return null;
        }
        String configPrefix = this.getConfigPrefix(connectionName);
        boolean bl = needToStart = !ConfigUtils.isPropertyPresent((String)(configPrefix + "hosts"));
        if (!needToStart) {
            log.debug((Object)("Not starting devservices for " + (RedisClientUtil.isDefault((String)connectionName) ? "default redis client" : connectionName) + " as hosts have been provided"));
            return null;
        }
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warn((Object)("Please configure quarkus.redis.hosts for " + (RedisClientUtil.isDefault((String)connectionName) ? "default redis client" : connectionName) + " or get a working docker instance"));
            return null;
        }
        DockerImageName dockerImageName = DockerImageName.parse((String)devServicesConfig.imageName.orElse(REDIS_6_ALPINE)).asCompatibleSubstituteFor(REDIS_6_ALPINE);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultRedisServerSupplier = () -> {
            QuarkusPortRedisContainer redisContainer = new QuarkusPortRedisContainer(dockerImageName, devServicesConfig.port, launchMode == LaunchMode.DEVELOPMENT ? devServicesConfig.serviceName : null, useSharedNetwork);
            timeout.ifPresent(arg_0 -> ((QuarkusPortRedisContainer)redisContainer).withStartupTimeout(arg_0));
            redisContainer.start();
            String redisHost = REDIS_SCHEME + redisContainer.getHost() + ":" + redisContainer.getPort();
            return new DevServicesResultBuildItem.RunningDevService(Feature.REDIS_CLIENT.getName(), redisContainer.getContainerId(), () -> ((QuarkusPortRedisContainer)redisContainer).close(), configPrefix + "hosts", redisHost);
        };
        return redisContainerLocator.locateContainer(devServicesConfig.serviceName, devServicesConfig.shared, launchMode).map(containerAddress -> {
            String redisUrl = REDIS_SCHEME + containerAddress.getUrl();
            return new DevServicesResultBuildItem.RunningDevService(Feature.REDIS_CLIENT.getName(), containerAddress.getId(), null, configPrefix + "hosts", redisUrl);
        }).orElseGet(defaultRedisServerSupplier);
    }

    private String getConfigPrefix(String connectionName) {
        Object configPrefix = "quarkus.redis.";
        if (!RedisClientUtil.isDefault((String)connectionName)) {
            configPrefix = (String)configPrefix + connectionName + DOT;
        }
        return configPrefix;
    }

    static {
        first = true;
    }

    private static class QuarkusPortRedisContainer
    extends GenericContainer<QuarkusPortRedisContainer> {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusPortRedisContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort, String serviceName, boolean useSharedNetwork) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            if (serviceName != null) {
                this.withLabel(DevServicesRedisProcessor.DEV_SERVICE_LABEL, serviceName);
            }
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"redis");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 6379);
            } else {
                this.addExposedPort(6379);
            }
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 6379;
            }
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getFirstMappedPort();
        }

        public String getHost() {
            return this.useSharedNetwork ? this.hostName : super.getHost();
        }
    }
}

