/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.client.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.RedisSlaves;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public class RedisConfig {
    @ConfigItem(name="<<parent>>")
    public RedisConfiguration defaultClient;
    @ConfigItem(name="<<parent>>")
    Map<String, RedisConfiguration> additionalRedisClients;

    @ConfigGroup
    public static class RedisConfiguration {
        @ConfigItem(defaultValueDocumentation="redis://localhost:6379")
        public Optional<Set<URI>> hosts;
        @ConfigItem(defaultValue="10s")
        public Optional<Duration> timeout;
        @ConfigItem(defaultValue="standalone")
        public RedisClientType clientType;
        @ConfigItem(defaultValueDocumentation="mymaster")
        public Optional<String> masterName;
        @ConfigItem(defaultValueDocumentation="master")
        public Optional<RedisRole> role;
        @ConfigItem(defaultValueDocumentation="never")
        public Optional<RedisSlaves> slaves;
        @ConfigItem(defaultValue="6")
        public int maxPoolSize;
        @ConfigItem(defaultValue="24")
        public int maxPoolWaiting;
        @ConfigItem
        public Optional<Duration> poolCleanerInterval;
        @ConfigItem(defaultValue="15")
        public Duration poolRecycleTimeout;
        @ConfigItem(defaultValue="2048")
        public int maxWaitingHandlers;
        @ConfigItem(defaultValue="32")
        public int maxNestedArrays;
    }
}

