/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.client.runtime;

import io.quarkus.redis.client.runtime.MutinyRedis;
import io.quarkus.redis.client.runtime.MutinyRedisAPI;
import io.quarkus.redis.client.runtime.ReactiveRedisClientImpl;
import io.quarkus.redis.client.runtime.RedisAPIContainer;
import io.quarkus.redis.client.runtime.RedisClientImpl;
import io.quarkus.redis.client.runtime.RedisClientUtil;
import io.quarkus.redis.client.runtime.RedisConfig;
import io.vertx.core.Vertx;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.RedisOptions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.PreDestroy;

class RedisAPIProducer {
    private static Map<String, RedisAPIContainer> REDIS_APIS = new ConcurrentHashMap<String, RedisAPIContainer>();
    private final Vertx vertx;
    private final RedisConfig redisConfig;

    public RedisAPIProducer(RedisConfig redisConfig, Vertx vertx) {
        this.redisConfig = redisConfig;
        this.vertx = vertx;
    }

    public RedisAPIContainer getRedisAPIContainer(final String name) {
        return REDIS_APIS.computeIfAbsent(name, new Function<String, RedisAPIContainer>(){

            @Override
            public RedisAPIContainer apply(String s) {
                long timeout = 10L;
                RedisConfig.RedisConfiguration redisConfiguration = RedisClientUtil.getConfiguration(RedisAPIProducer.this.redisConfig, name);
                if (redisConfiguration.timeout.isPresent()) {
                    timeout = redisConfiguration.timeout.get().getSeconds();
                }
                RedisOptions options = RedisClientUtil.buildOptions(redisConfiguration);
                Redis redis = Redis.createClient((Vertx)RedisAPIProducer.this.vertx, (RedisOptions)options);
                RedisAPI redisAPI = RedisAPI.api((Redis)redis);
                MutinyRedis mutinyRedis = new MutinyRedis(redis);
                MutinyRedisAPI mutinyRedisAPI = new MutinyRedisAPI(redisAPI);
                RedisClientImpl redisClient = new RedisClientImpl(mutinyRedisAPI, timeout);
                ReactiveRedisClientImpl reactiveClient = new ReactiveRedisClientImpl(mutinyRedisAPI);
                return new RedisAPIContainer(redis, redisAPI, redisClient, reactiveClient, mutinyRedis, mutinyRedisAPI);
            }
        });
    }

    @PreDestroy
    public void close() {
        for (RedisAPIContainer container : REDIS_APIS.values()) {
            container.close();
        }
        REDIS_APIS.clear();
    }
}

