/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.geo.GeoAddArgs;
import io.quarkus.redis.datasource.geo.GeoCommands;
import io.quarkus.redis.datasource.geo.GeoItem;
import io.quarkus.redis.datasource.geo.GeoPosition;
import io.quarkus.redis.datasource.geo.GeoRadiusArgs;
import io.quarkus.redis.datasource.geo.GeoRadiusStoreArgs;
import io.quarkus.redis.datasource.geo.GeoSearchArgs;
import io.quarkus.redis.datasource.geo.GeoSearchStoreArgs;
import io.quarkus.redis.datasource.geo.GeoUnit;
import io.quarkus.redis.datasource.geo.GeoValue;
import io.quarkus.redis.datasource.geo.ReactiveGeoCommands;
import java.time.Duration;
import java.util.List;
import java.util.OptionalDouble;
import java.util.Set;

public class BlockingGeoCommandsImpl<K, V>
implements GeoCommands<K, V> {
    private final ReactiveGeoCommands<K, V> reactive;
    private final Duration timeout;

    public BlockingGeoCommandsImpl(ReactiveGeoCommands<K, V> reactive, Duration timeout) {
        this.reactive = reactive;
        this.timeout = timeout;
    }

    @Override
    public boolean geoadd(K key, double longitude, double latitude, V member) {
        return (Boolean)this.reactive.geoadd(key, longitude, latitude, member).await().atMost(this.timeout);
    }

    @Override
    public boolean geoadd(K key, GeoPosition position, V member) {
        return (Boolean)this.reactive.geoadd(key, position, member).await().atMost(this.timeout);
    }

    @Override
    public boolean geoadd(K key, GeoItem<V> item) {
        return (Boolean)this.reactive.geoadd(key, item).await().atMost(this.timeout);
    }

    @Override
    public int geoadd(K key, GeoItem<V> ... items) {
        return (Integer)this.reactive.geoadd(key, items).await().atMost(this.timeout);
    }

    @Override
    public boolean geoadd(K key, double longitude, double latitude, V member, GeoAddArgs args) {
        return (Boolean)this.reactive.geoadd(key, longitude, latitude, member, args).await().atMost(this.timeout);
    }

    @Override
    public boolean geoadd(K key, GeoItem<V> item, GeoAddArgs args) {
        return (Boolean)this.reactive.geoadd(key, item, args).await().atMost(this.timeout);
    }

    @Override
    public int geoadd(K key, GeoAddArgs args, GeoItem<V> ... items) {
        return (Integer)this.reactive.geoadd(key, args, items).await().atMost(this.timeout);
    }

    @Override
    public OptionalDouble geodist(K key, V from, V to, GeoUnit unit) {
        return (OptionalDouble)this.reactive.geodist(key, from, to, unit).map(d -> {
            if (d == null) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(d);
        }).await().atMost(this.timeout);
    }

    @Override
    public List<String> geohash(K key, V ... members) {
        return (List)this.reactive.geohash(key, members).await().atMost(this.timeout);
    }

    @Override
    public List<GeoPosition> geopos(K key, V ... members) {
        return (List)this.reactive.geopos(key, members).await().atMost(this.timeout);
    }

    @Override
    public Set<V> georadius(K key, double longitude, double latitude, double radius, GeoUnit unit) {
        return (Set)this.reactive.georadius(key, longitude, latitude, radius, unit).await().atMost(this.timeout);
    }

    @Override
    public Set<V> georadius(K key, GeoPosition position, double radius, GeoUnit unit) {
        return (Set)this.reactive.georadius(key, position, radius, unit).await().atMost(this.timeout);
    }

    @Override
    public List<GeoValue<V>> georadius(K key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusArgs geoArgs) {
        return (List)this.reactive.georadius(key, longitude, latitude, radius, unit, geoArgs).await().atMost(this.timeout);
    }

    @Override
    public List<GeoValue<V>> georadius(K key, GeoPosition position, double radius, GeoUnit unit, GeoRadiusArgs geoArgs) {
        return (List)this.reactive.georadius(key, position, radius, unit, geoArgs).await().atMost(this.timeout);
    }

    @Override
    public long georadius(K key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusStoreArgs<K> geoArgs) {
        return (Long)this.reactive.georadius(key, longitude, latitude, radius, unit, geoArgs).await().atMost(this.timeout);
    }

    @Override
    public long georadius(K key, GeoPosition position, double radius, GeoUnit unit, GeoRadiusStoreArgs<K> geoArgs) {
        return (Long)this.reactive.georadius(key, position, radius, unit, geoArgs).await().atMost(this.timeout);
    }

    @Override
    public Set<V> georadiusbymember(K key, V member, double distance, GeoUnit unit) {
        return (Set)this.reactive.georadiusbymember(key, member, distance, unit).await().atMost(this.timeout);
    }

    @Override
    public List<GeoValue<V>> georadiusbymember(K key, V member, double distance, GeoUnit unit, GeoRadiusArgs geoArgs) {
        return (List)this.reactive.georadiusbymember(key, member, distance, unit, geoArgs).await().atMost(this.timeout);
    }

    @Override
    public long georadiusbymember(K key, V member, double distance, GeoUnit unit, GeoRadiusStoreArgs<K> geoArgs) {
        return (Long)this.reactive.georadiusbymember(key, member, distance, unit, geoArgs).await().atMost(this.timeout);
    }

    @Override
    public List<GeoValue<V>> geosearch(K key, GeoSearchArgs<V> args) {
        return (List)this.reactive.geosearch(key, args).await().atMost(this.timeout);
    }

    @Override
    public long geosearchstore(K destination, K key, GeoSearchStoreArgs<V> args, boolean storeDist) {
        return (Long)this.reactive.geosearchstore(destination, key, args, storeDist).await().atMost(this.timeout);
    }
}

