/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.keys.CopyArgs;
import io.quarkus.redis.datasource.keys.ExpireArgs;
import io.quarkus.redis.datasource.keys.KeyCommands;
import io.quarkus.redis.datasource.keys.KeyScanArgs;
import io.quarkus.redis.datasource.keys.KeyScanCursor;
import io.quarkus.redis.datasource.keys.ReactiveKeyCommands;
import io.quarkus.redis.datasource.keys.RedisValueType;
import io.quarkus.redis.runtime.datasource.ScanBlockingCursorImpl;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

public class BlockingKeyCommandsImpl<K>
implements KeyCommands<K> {
    private final ReactiveKeyCommands<K> reactive;
    private final Duration timeout;

    public BlockingKeyCommandsImpl(ReactiveKeyCommands<K> reactive, Duration timeout) {
        this.reactive = reactive;
        this.timeout = timeout;
    }

    @Override
    public boolean copy(K source, K destination) {
        return (Boolean)this.reactive.copy(source, destination).await().atMost(this.timeout);
    }

    @Override
    public boolean copy(K source, K destination, CopyArgs copyArgs) {
        return (Boolean)this.reactive.copy(source, destination, copyArgs).await().atMost(this.timeout);
    }

    @Override
    public int del(K ... keys) {
        return (Integer)this.reactive.del(keys).await().atMost(this.timeout);
    }

    @Override
    public String dump(K key) {
        return (String)this.reactive.dump(key).await().atMost(this.timeout);
    }

    @Override
    public boolean exists(K key) {
        return (Boolean)this.reactive.exists(key).await().atMost(this.timeout);
    }

    @Override
    public int exists(K ... keys) {
        return (Integer)this.reactive.exists(keys).await().atMost(this.timeout);
    }

    @Override
    public boolean expire(K key, long seconds, ExpireArgs expireArgs) {
        return (Boolean)this.reactive.expire(key, seconds, expireArgs).await().atMost(this.timeout);
    }

    @Override
    public boolean expire(K key, Duration duration, ExpireArgs expireArgs) {
        return (Boolean)this.reactive.expire(key, duration, expireArgs).await().atMost(this.timeout);
    }

    @Override
    public boolean expire(K key, long seconds) {
        return (Boolean)this.reactive.expire(key, seconds).await().atMost(this.timeout);
    }

    @Override
    public boolean expire(K key, Duration duration) {
        return (Boolean)this.reactive.expire(key, duration).await().atMost(this.timeout);
    }

    @Override
    public boolean expireat(K key, long timestamp) {
        return (Boolean)this.reactive.expireat(key, timestamp).await().atMost(this.timeout);
    }

    @Override
    public boolean expireat(K key, Instant timestamp) {
        return (Boolean)this.reactive.expireat(key, timestamp).await().atMost(this.timeout);
    }

    @Override
    public boolean expireat(K key, long timestamp, ExpireArgs expireArgs) {
        return (Boolean)this.reactive.expireat(key, timestamp, expireArgs).await().atMost(this.timeout);
    }

    @Override
    public boolean expireat(K key, Instant timestamp, ExpireArgs expireArgs) {
        return (Boolean)this.reactive.expireat(key, timestamp, expireArgs).await().atMost(this.timeout);
    }

    @Override
    public long expiretime(K key) {
        return (Long)this.reactive.expiretime(key).await().atMost(this.timeout);
    }

    @Override
    public List<K> keys(String pattern) {
        return (List)this.reactive.keys(pattern).await().atMost(this.timeout);
    }

    @Override
    public boolean move(K key, long db) {
        return (Boolean)this.reactive.move(key, db).await().atMost(this.timeout);
    }

    @Override
    public boolean persist(K key) {
        return (Boolean)this.reactive.persist(key).await().atMost(this.timeout);
    }

    @Override
    public boolean pexpire(K key, long seconds, ExpireArgs pexpireArgs) {
        return (Boolean)this.reactive.pexpire(key, seconds, pexpireArgs).await().atMost(this.timeout);
    }

    @Override
    public boolean pexpire(K key, Duration duration, ExpireArgs pexpireArgs) {
        return (Boolean)this.reactive.pexpire(key, duration, pexpireArgs).await().atMost(this.timeout);
    }

    @Override
    public boolean pexpire(K key, long ms) {
        return (Boolean)this.reactive.pexpire(key, ms).await().atMost(this.timeout);
    }

    @Override
    public boolean pexpire(K key, Duration duration) {
        return (Boolean)this.reactive.pexpire(key, duration).await().atMost(this.timeout);
    }

    @Override
    public boolean pexpireat(K key, long timestamp) {
        return (Boolean)this.reactive.pexpireat(key, timestamp).await().atMost(this.timeout);
    }

    @Override
    public boolean pexpireat(K key, Instant timestamp) {
        return (Boolean)this.reactive.pexpireat(key, timestamp).await().atMost(this.timeout);
    }

    @Override
    public boolean pexpireat(K key, long timestamp, ExpireArgs pexpireArgs) {
        return (Boolean)this.reactive.pexpireat(key, timestamp, pexpireArgs).await().atMost(this.timeout);
    }

    @Override
    public boolean pexpireat(K key, Instant timestamp, ExpireArgs pexpireArgs) {
        return (Boolean)this.reactive.pexpireat(key, timestamp, pexpireArgs).await().atMost(this.timeout);
    }

    @Override
    public long pexpiretime(K key) {
        return (Long)this.reactive.pexpiretime(key).await().atMost(this.timeout);
    }

    @Override
    public long pttl(K key) {
        return (Long)this.reactive.pttl(key).await().atMost(this.timeout);
    }

    @Override
    public K randomkey() {
        return (K)this.reactive.randomkey().await().atMost(this.timeout);
    }

    @Override
    public void rename(K key, K newkey) {
        this.reactive.rename(key, newkey).await().atMost(this.timeout);
    }

    @Override
    public boolean renamenx(K key, K newkey) {
        return (Boolean)this.reactive.renamenx(key, newkey).await().atMost(this.timeout);
    }

    @Override
    public KeyScanCursor<K> scan() {
        return new ScanBlockingCursorImpl<K>(this.reactive.scan(), this.timeout);
    }

    @Override
    public KeyScanCursor<K> scan(KeyScanArgs args) {
        return new ScanBlockingCursorImpl<K>(this.reactive.scan(args), this.timeout);
    }

    @Override
    public int touch(K ... keys) {
        return (Integer)this.reactive.touch(keys).await().atMost(this.timeout);
    }

    @Override
    public long ttl(K key) {
        return (Long)this.reactive.ttl(key).await().atMost(this.timeout);
    }

    @Override
    public RedisValueType type(K key) {
        return (RedisValueType)((Object)this.reactive.type(key).await().atMost(this.timeout));
    }

    @Override
    public int unlink(K ... keys) {
        return (Integer)this.reactive.unlink(keys).await().atMost(this.timeout);
    }
}

