/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.ScanArgs;
import io.quarkus.redis.datasource.list.KeyValue;
import io.quarkus.redis.datasource.sortedset.Range;
import io.quarkus.redis.datasource.sortedset.ReactiveSortedSetCommands;
import io.quarkus.redis.datasource.sortedset.ReactiveZScanCursor;
import io.quarkus.redis.datasource.sortedset.ScoreRange;
import io.quarkus.redis.datasource.sortedset.ScoredValue;
import io.quarkus.redis.datasource.sortedset.ZAddArgs;
import io.quarkus.redis.datasource.sortedset.ZAggregateArgs;
import io.quarkus.redis.datasource.sortedset.ZRangeArgs;
import io.quarkus.redis.runtime.datasource.AbstractSortedSetCommands;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.ZScanReactiveCursorImpl;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Response;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ReactiveSortedSetCommandsImpl<K, V>
extends AbstractSortedSetCommands<K, V>
implements ReactiveSortedSetCommands<K, V> {
    public ReactiveSortedSetCommandsImpl(RedisCommandExecutor redis, Class<K> k, Class<V> v) {
        super(redis, k, v);
    }

    @Override
    public Uni<Boolean> zadd(K key, double score, V value) {
        return this.zadd(key, new ZAddArgs(), score, value);
    }

    @Override
    public Uni<Integer> zadd(K key, Map<V, Double> items) {
        return this.zadd(key, new ZAddArgs(), items);
    }

    @Override
    public Uni<Integer> zadd(K key, ScoredValue<V> ... items) {
        return this.zadd(key, new ZAddArgs(), items);
    }

    @Override
    public Uni<Boolean> zadd(K key, ZAddArgs args, double score, V value) {
        return super._zadd(key, args, score, value).map(this::decodeIntAsBoolean);
    }

    @Override
    public Uni<Integer> zadd(K key, ZAddArgs args, Map<V, Double> items) {
        return super._zadd(key, args, items).map(Response::toInteger);
    }

    @Override
    public Uni<Integer> zadd(K key, ZAddArgs args, ScoredValue<V> ... items) {
        return super._zadd(key, args, items).map(Response::toInteger);
    }

    @Override
    public Uni<Double> zaddincr(K key, double score, V value) {
        return this.zaddincr(key, new ZAddArgs(), score, value);
    }

    @Override
    public Uni<Double> zaddincr(K key, ZAddArgs args, double score, V value) {
        return super._zaddincr(key, args, score, value).map(this::decodeAsDouble);
    }

    @Override
    public Uni<Long> zcard(K key) {
        return super._zcard(key).map(this::decodeLongOrZero);
    }

    @Override
    public Uni<Long> zcount(K key, ScoreRange<Double> range) {
        return super._zcount(key, range).map(Response::toLong);
    }

    @Override
    public Uni<List<V>> zdiff(K ... keys) {
        return super._zdiff(keys).map(this::decodeAsListOfValues);
    }

    @Override
    public Uni<List<ScoredValue<V>>> zdiffWithScores(K ... keys) {
        return super._zdiffWithScores(keys).map(this::decodeAsListOfScoredValues);
    }

    @Override
    public Uni<Long> zdiffstore(K destination, K ... keys) {
        return super._zdiffstore(destination, keys).map(Response::toLong);
    }

    @Override
    public Uni<Double> zincrby(K key, double increment, V value) {
        return super._zincrby(key, increment, value).map(Response::toDouble);
    }

    @Override
    public Uni<List<V>> zinter(ZAggregateArgs args, K ... keys) {
        return super._zinter(args, keys).map(r -> this.marshaller.decodeAsList((Response)r, this.typeOfValue));
    }

    @Override
    public Uni<List<V>> zinter(K ... keys) {
        return this.zinter(DEFAULT_INSTANCE_AGG, keys);
    }

    @Override
    public Uni<List<ScoredValue<V>>> zinterWithScores(ZAggregateArgs arguments, K ... keys) {
        return super._zinterWithScores(arguments, keys).map(this::decodeAsListOfScoredValues);
    }

    @Override
    public Uni<List<ScoredValue<V>>> zinterWithScores(K ... keys) {
        return this.zinterWithScores(DEFAULT_INSTANCE_AGG, keys);
    }

    @Override
    public Uni<Long> zintercard(K ... keys) {
        return super._zintercard(keys).map(Response::toLong);
    }

    @Override
    public Uni<Long> zintercard(long limit, K ... keys) {
        return super._zintercard(limit, keys).map(Response::toLong);
    }

    @Override
    public Uni<Long> zinterstore(K destination, ZAggregateArgs arguments, K ... keys) {
        return super._zinterstore(destination, arguments, keys).map(Response::toLong);
    }

    @Override
    @SafeVarargs
    public final Uni<Long> zinterstore(K destination, K ... keys) {
        return this.zinterstore(destination, DEFAULT_INSTANCE_AGG, keys);
    }

    @Override
    public Uni<Long> zlexcount(K key, Range<String> range) {
        return super._zlexcount(key, range).map(Response::toLong);
    }

    @Override
    public Uni<ScoredValue<V>> zmpopMin(K ... keys) {
        return super._zmpopMin(keys).map(this::decodePopResponse);
    }

    @Override
    public Uni<List<ScoredValue<V>>> zmpopMin(int count, K ... keys) {
        return super._zmpopMin(count, keys).map(this::decodePopResponseWithCount);
    }

    @Override
    public Uni<ScoredValue<V>> zmpopMax(K ... keys) {
        return super._zmpopMax(keys).map(this::decodePopResponse);
    }

    @Override
    public Uni<List<ScoredValue<V>>> zmpopMax(int count, K ... keys) {
        return super._zmpopMax(count, keys).map(this::decodePopResponseWithCount);
    }

    @Override
    public Uni<ScoredValue<V>> bzmpopMin(Duration timeout, K ... keys) {
        return super._bzmpopMin(timeout, keys).map(this::decodePopResponse);
    }

    @Override
    public Uni<List<ScoredValue<V>>> bzmpopMin(Duration timeout, int count, K ... keys) {
        return super._bzmpopMin(timeout, count, keys).map(this::decodePopResponseWithCount);
    }

    @Override
    public Uni<ScoredValue<V>> bzmpopMax(Duration timeout, K ... keys) {
        return super._bzmpopMax(timeout, keys).map(this::decodePopResponse);
    }

    @Override
    public Uni<List<ScoredValue<V>>> bzmpopMax(Duration timeout, int count, K ... keys) {
        return super._bzmpopMax(timeout, count, keys).map(this::decodePopResponseWithCount);
    }

    @Override
    public Uni<List<Double>> zmscore(K key, V ... values) {
        return super._zmscore(key, values).map(this::decodeAsListOfDouble);
    }

    @Override
    public Uni<ScoredValue<V>> zpopmax(K key) {
        return super._zpopmax(key).map(this::decodeAsScoredValue);
    }

    @Override
    public Uni<List<ScoredValue<V>>> zpopmax(K key, int count) {
        return super._zpopmax(key, count).map(this::decodeAsListOfScoredValues);
    }

    @Override
    public Uni<ScoredValue<V>> zpopmin(K key) {
        return super._zpopmin(key).map(this::decodeAsScoredValue);
    }

    @Override
    public Uni<List<ScoredValue<V>>> zpopmin(K key, int count) {
        return super._zpopmin(key, count).map(this::decodeAsListOfScoredValues);
    }

    @Override
    public Uni<V> zrandmember(K key) {
        return super._zrandmember(key).map(this::decodeV);
    }

    @Override
    public Uni<List<V>> zrandmember(K key, int count) {
        return super._zrandmember(key, count).map(this::decodeAsListOfValues);
    }

    @Override
    public Uni<ScoredValue<V>> zrandmemberWithScores(K key) {
        return super._zrandmemberWithScores(key).map(this::decodeAsScoredValueOrEmpty);
    }

    @Override
    public Uni<List<ScoredValue<V>>> zrandmemberWithScores(K key, int count) {
        return super._zrandmemberWithScores(key, count).map(this::decodeAsListOfScoredValues);
    }

    @Override
    @SafeVarargs
    public final Uni<KeyValue<K, ScoredValue<V>>> bzpopmin(Duration timeout, K ... keys) {
        return super._bzpopmin(timeout, keys).map(this::decodeAsKeyValue);
    }

    @Override
    @SafeVarargs
    public final Uni<KeyValue<K, ScoredValue<V>>> bzpopmax(Duration timeout, K ... keys) {
        return super._bzpopmax(timeout, keys).map(this::decodeAsKeyValue);
    }

    @Override
    public Uni<List<V>> zrange(K key, long start, long stop, ZRangeArgs args) {
        return super._zrange(key, start, stop, args).map(this::decodeAsListOfValues);
    }

    @Override
    public Uni<List<ScoredValue<V>>> zrangeWithScores(K key, long start, long stop, ZRangeArgs args) {
        return super._zrangeWithScores(key, start, stop, args).map(this::decodeAsListOfScoredValues);
    }

    @Override
    public Uni<List<V>> zrange(K key, long start, long stop) {
        return this.zrange(key, start, stop, DEFAULT_INSTANCE_RANGE);
    }

    @Override
    public Uni<List<ScoredValue<V>>> zrangeWithScores(K key, long start, long stop) {
        return this.zrangeWithScores(key, start, stop, DEFAULT_INSTANCE_RANGE);
    }

    @Override
    public Uni<List<V>> zrangebylex(K key, Range<String> range, ZRangeArgs args) {
        return super._zrangebylex(key, range, args).map(this::decodeAsListOfValues);
    }

    @Override
    public Uni<List<V>> zrangebylex(K key, Range<String> range) {
        return this.zrangebylex(key, range, DEFAULT_INSTANCE_RANGE);
    }

    @Override
    public Uni<List<V>> zrangebyscore(K key, ScoreRange<Double> range, ZRangeArgs args) {
        return super._zrangebyscore(key, range, args).map(this::decodeAsListOfValues);
    }

    @Override
    public Uni<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, ScoreRange<Double> range, ZRangeArgs args) {
        return super._zrangebyscoreWithScores(key, range, args).map(this::decodeAsListOfScoredValues);
    }

    @Override
    public Uni<List<V>> zrangebyscore(K key, ScoreRange<Double> range) {
        return this.zrangebyscore(key, range, DEFAULT_INSTANCE_RANGE);
    }

    @Override
    public Uni<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, ScoreRange<Double> range) {
        return this.zrangebyscoreWithScores(key, range, DEFAULT_INSTANCE_RANGE);
    }

    @Override
    public Uni<Long> zrangestore(K dst, K src, long min, long max, ZRangeArgs args) {
        return super._zrangestore(dst, src, min, max, args).map(Response::toLong);
    }

    @Override
    public Uni<Long> zrangestore(K dst, K src, long min, long max) {
        return this.zrangestore(dst, src, min, max, DEFAULT_INSTANCE_RANGE);
    }

    @Override
    public Uni<Long> zrangestorebylex(K dst, K src, Range<String> range, ZRangeArgs args) {
        return super._zrangestorebylex(dst, src, range, args).map(Response::toLong);
    }

    @Override
    public Uni<Long> zrangestorebylex(K dst, K src, Range<String> range) {
        return this.zrangestorebylex(dst, src, range, DEFAULT_INSTANCE_RANGE);
    }

    @Override
    public Uni<Long> zrangestorebyscore(K dst, K src, ScoreRange<Double> range, ZRangeArgs args) {
        return super._zrangestorebyscore(dst, src, range, args).map(Response::toLong);
    }

    @Override
    public Uni<Long> zrangestorebyscore(K dst, K src, ScoreRange<Double> range) {
        return this.zrangestorebyscore(dst, src, range, DEFAULT_INSTANCE_RANGE);
    }

    @Override
    public Uni<Long> zrank(K key, V value) {
        return super._zrank(key, value).map(this::decodeAsLong);
    }

    @Override
    public Uni<Integer> zrem(K key, V ... values) {
        return super._zrem(key, values).map(Response::toInteger);
    }

    @Override
    public Uni<Long> zremrangebylex(K key, Range<String> range) {
        return super._zremrangebylex(key, range).map(Response::toLong);
    }

    @Override
    public Uni<Long> zremrangebyrank(K key, long start, long stop) {
        return super._zremrangebyrank(key, start, stop).map(Response::toLong);
    }

    @Override
    public Uni<Long> zremrangebyscore(K key, ScoreRange<Double> range) {
        return super._zremrangebyscore(key, range).map(Response::toLong);
    }

    @Override
    public Uni<Long> zrevrank(K key, V value) {
        return super._zrevrank(key, value).map(this::decodeAsLong);
    }

    @Override
    public ReactiveZScanCursor<V> zscan(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return new ZScanReactiveCursorImpl(this.redis, key, this.marshaller, this.typeOfValue, Collections.emptyList());
    }

    @Override
    public ReactiveZScanCursor<V> zscan(K key, ScanArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        return new ZScanReactiveCursorImpl(this.redis, key, this.marshaller, this.typeOfValue, args.toArgs());
    }

    @Override
    public Uni<Double> zscore(K key, V value) {
        return super._zscore(key, value).map(this::decodeAsDouble);
    }

    @Override
    public Uni<List<V>> zunion(ZAggregateArgs args, K ... keys) {
        return super._zunion(args, keys).map(this::decodeAsListOfValues);
    }

    @Override
    public Uni<List<V>> zunion(K ... keys) {
        return this.zunion(DEFAULT_INSTANCE_AGG, keys);
    }

    @Override
    public Uni<List<ScoredValue<V>>> zunionWithScores(K ... keys) {
        return this.zunionWithScores(DEFAULT_INSTANCE_AGG, keys);
    }

    @Override
    public Uni<List<ScoredValue<V>>> zunionWithScores(ZAggregateArgs args, K ... keys) {
        return super._zunionWithScores(args, keys).map(this::decodeAsListOfScoredValues);
    }

    @Override
    public Uni<Long> zunionstore(K destination, ZAggregateArgs args, K ... keys) {
        return super._zunionstore(destination, args, keys).map(Response::toLong);
    }

    @Override
    public Uni<Long> zunionstore(K destination, K ... keys) {
        return this.zunionstore(destination, DEFAULT_INSTANCE_AGG, keys);
    }
}

