/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.string;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class GetExArgs
implements RedisCommandExtraArguments {
    private long ex = -1L;
    private long exAt = -1L;
    private long px = -1L;
    private long pxAt = -1L;
    private boolean persist;

    public GetExArgs ex(long timeout) {
        this.ex = timeout;
        return this;
    }

    public GetExArgs ex(Duration timeout) {
        if (timeout == null) {
            throw new IllegalArgumentException("`timeout` must not be `null`");
        }
        return this.ex(timeout.toMillis() / 1000L);
    }

    public GetExArgs exAt(long timestamp) {
        this.exAt = timestamp;
        return this;
    }

    public GetExArgs exAt(Instant timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("`timestamp` must not be `null`");
        }
        this.exAt(timestamp.toEpochMilli() / 1000L);
        return this;
    }

    public GetExArgs px(long timeout) {
        this.px = timeout;
        return this;
    }

    public GetExArgs px(Duration timeout) {
        if (timeout == null) {
            throw new IllegalArgumentException("`timeout` must not be `null`");
        }
        return this.px(timeout.toMillis());
    }

    public GetExArgs pxAt(long timestamp) {
        this.pxAt = timestamp;
        return this;
    }

    public GetExArgs pxAt(Instant timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("`timestamp` must not be `null`");
        }
        return this.pxAt(timestamp.toEpochMilli());
    }

    public GetExArgs persist() {
        this.persist = true;
        return this;
    }

    @Override
    public List<String> toArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.ex >= 0L) {
            args.add("EX");
            args.add(Long.toString(this.ex));
        }
        if (this.exAt >= 0L) {
            args.add("EXAT");
            args.add(Long.toString(this.exAt));
        }
        if (this.px >= 0L) {
            args.add("PX");
            args.add(Long.toString(this.px));
        }
        if (this.pxAt >= 0L) {
            args.add("PXAT");
            args.add(Long.toString(this.pxAt));
        }
        if (this.persist) {
            args.add("PERSIST");
        }
        return args;
    }
}

