/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.codecs.Codec;
import io.quarkus.redis.datasource.codecs.Codecs;
import io.quarkus.redis.datasource.geo.GeoAddArgs;
import io.quarkus.redis.datasource.geo.GeoItem;
import io.quarkus.redis.datasource.geo.GeoPosition;
import io.quarkus.redis.datasource.geo.GeoRadiusArgs;
import io.quarkus.redis.datasource.geo.GeoRadiusStoreArgs;
import io.quarkus.redis.datasource.geo.GeoSearchArgs;
import io.quarkus.redis.datasource.geo.GeoSearchStoreArgs;
import io.quarkus.redis.datasource.geo.GeoUnit;
import io.quarkus.redis.datasource.geo.GeoValue;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;

class AbstractGeoCommands<K, V>
extends AbstractRedisCommands {
    protected final Class<V> typeOfValue;
    protected final Codec<K> keyCodec;
    protected final Codec<V> valueCodec;

    AbstractGeoCommands(RedisCommandExecutor redis, Class<K> k, Class<V> v) {
        super(redis, new Marshaller(k, v));
        this.typeOfValue = v;
        this.keyCodec = Codecs.getDefaultCodecFor(k);
        this.valueCodec = Codecs.getDefaultCodecFor(v);
    }

    Uni<Response> _geoadd(K key, double longitude, double latitude, V member, GeoAddArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(member, (String)"member");
        ParameterValidation.nonNull((Object)args, (String)"args");
        Validation.validateLongitude(longitude);
        Validation.validateLatitude(latitude);
        RedisCommand cmd = RedisCommand.of(Command.GEOADD).put(this.marshaller.encode(key)).putAll(args.toArgs()).put(longitude).put(latitude).put(this.marshaller.encode(member));
        return this.execute(cmd);
    }

    Uni<Response> _geoadd(K key, GeoItem<V> ... items) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(items, "items");
        ParameterValidation.doesNotContainNull((Object[])items, (String)"items");
        RedisCommand cmd = RedisCommand.of(Command.GEOADD).put(this.marshaller.encode(key));
        for (GeoItem<V> item : items) {
            cmd.put(Double.toString(item.longitude())).put(Double.toString(item.latitude())).put(this.marshaller.encode(item.member()));
        }
        return this.execute(cmd);
    }

    Uni<Response> _geoadd(K key, GeoAddArgs args, GeoItem<V> ... items) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(items, "items");
        ParameterValidation.doesNotContainNull((Object[])items, (String)"items");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.GEOADD).put(this.marshaller.encode(key)).put(args);
        for (GeoItem<V> item : items) {
            cmd.put(Double.toString(item.longitude()));
            cmd.put(Double.toString(item.latitude()));
            cmd.put(this.marshaller.encode(item.member()));
        }
        return this.execute(cmd);
    }

    Uni<Response> _geodist(K key, V from, V to, GeoUnit unit) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(from, (String)"from");
        ParameterValidation.nonNull(to, (String)"to");
        ParameterValidation.nonNull((Object)((Object)unit), (String)"unit");
        return this.execute(RedisCommand.of(Command.GEODIST).put(this.marshaller.encode(key)).put(this.marshaller.encode(from)).put(this.marshaller.encode(to)).put(unit.name()));
    }

    Uni<Response> _geohash(K key, V ... members) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(members, "members");
        ParameterValidation.doesNotContainNull((Object[])members, (String)"members");
        RedisCommand cmd = RedisCommand.of(Command.GEOHASH);
        cmd.put(this.marshaller.encode(key));
        for (V member : members) {
            cmd.put(this.marshaller.encode(member));
        }
        return this.execute(cmd);
    }

    Uni<Response> _geopos(K key, V ... members) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(members, "members");
        ParameterValidation.doesNotContainNull((Object[])members, (String)"members");
        RedisCommand cmd = RedisCommand.of(Command.GEOPOS).put(this.marshaller.encode(key));
        for (V member : members) {
            cmd.put(this.marshaller.encode(member));
        }
        return this.execute(cmd);
    }

    Uni<Response> _georadius(K key, double longitude, double latitude, double radius, GeoUnit unit) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.positive(radius, "radius");
        Validation.validateLongitude(longitude);
        Validation.validateLatitude(latitude);
        ParameterValidation.nonNull((Object)((Object)unit), (String)"unit");
        return this.execute(RedisCommand.of(Command.GEORADIUS).put(this.marshaller.encode(key)).put(longitude).put(latitude).put(radius).put(unit.name()));
    }

    Uni<Response> _georadius(K key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusArgs geoArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.validateLongitude(longitude);
        Validation.validateLatitude(latitude);
        Validation.positive(radius, "radius");
        ParameterValidation.nonNull((Object)((Object)unit), (String)"unit");
        ParameterValidation.nonNull((Object)geoArgs, (String)"geoArgs");
        return this.execute(RedisCommand.of(Command.GEORADIUS).put(this.marshaller.encode(key)).put(longitude).put(latitude).put(radius).put(unit.name()).putArgs(geoArgs));
    }

    Uni<Response> _georadius(K key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusStoreArgs<K> geoArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.validateLongitude(longitude);
        Validation.validateLatitude(latitude);
        Validation.positive(radius, "radius");
        ParameterValidation.nonNull((Object)((Object)unit), (String)"unit");
        ParameterValidation.nonNull(geoArgs, (String)"geoArgs");
        return this.execute(RedisCommand.of(Command.GEORADIUS).put(this.marshaller.encode(key)).put(longitude).put(latitude).put(radius).put(unit.name()).putArgs(geoArgs, this.keyCodec));
    }

    Uni<Response> _georadiusbymember(K key, V member, double distance, GeoUnit unit, GeoRadiusArgs geoArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(member, (String)"member");
        Validation.positive(distance, "distance");
        ParameterValidation.nonNull((Object)((Object)unit), (String)"unit");
        ParameterValidation.nonNull((Object)geoArgs, (String)"geoArgs");
        return this.execute(RedisCommand.of(Command.GEORADIUSBYMEMBER).put(this.marshaller.encode(key)).put(this.marshaller.encode(member)).put(distance).put(unit.name()).putArgs(geoArgs));
    }

    Uni<Response> _georadiusbymember(K key, V member, double distance, GeoUnit unit) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(member, (String)"member");
        Validation.positive(distance, "distance");
        ParameterValidation.nonNull((Object)((Object)unit), (String)"unit");
        return this.execute(RedisCommand.of(Command.GEORADIUSBYMEMBER).put(this.marshaller.encode(key)).put(this.marshaller.encode(member)).put(distance).put(unit.name()));
    }

    Uni<Response> _georadiusbymember(K key, V member, double distance, GeoUnit unit, GeoRadiusStoreArgs<K> geoArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(member, (String)"member");
        Validation.positive(distance, "distance");
        ParameterValidation.nonNull((Object)((Object)unit), (String)"unit");
        ParameterValidation.nonNull(geoArgs, (String)"geoArgs");
        return this.execute(RedisCommand.of(Command.GEORADIUSBYMEMBER).put(this.marshaller.encode(key)).put(this.marshaller.encode(member)).put(distance).put(unit.name()).putArgs(geoArgs, this.keyCodec));
    }

    Uni<Response> _geosearch(K key, GeoSearchArgs<V> geoArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(geoArgs, (String)"geoArgs");
        return this.execute(RedisCommand.of(Command.GEOSEARCH).put(this.marshaller.encode(key)).putArgs(geoArgs, this.valueCodec));
    }

    Uni<Response> _geosearchstore(K destination, K key, GeoSearchStoreArgs<V> args, boolean storeDist) {
        ParameterValidation.nonNull(destination, (String)"destination");
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(args, (String)"args");
        return this.execute(RedisCommand.of(Command.GEOSEARCHSTORE).put(this.marshaller.encode(destination)).put(this.marshaller.encode(key)).putArgs(args, this.valueCodec).putFlag(storeDist, "STOREDIST"));
    }

    List<String> decodeHashList(Response r) {
        return this.marshaller.decodeAsList(r, Response::toString);
    }

    Set<V> decodeRadiusSet(Response response) {
        return this.marshaller.decodeAsSet(response, this.typeOfValue);
    }

    Double decodeDistance(Response r) {
        if (r == null) {
            return null;
        }
        return r.toDouble();
    }

    List<GeoPosition> decodeGeoPositions(Response response) {
        return this.marshaller.decodeAsList(response, nested -> {
            if (nested == null) {
                return null;
            }
            return GeoPosition.of(nested.get(0).toDouble(), nested.get(1).toDouble());
        });
    }

    List<GeoValue<V>> decodeAsListOfGeoValues(Response r, boolean withDistance, boolean withCoordinates, boolean withHash) {
        ArrayList<GeoValue<V>> list = new ArrayList<GeoValue<V>>();
        for (Response response : r) {
            double latitude;
            long hash;
            if (!(withCoordinates || withHash || withDistance)) {
                list.add(new GeoValue<V>(this.marshaller.decode(this.typeOfValue, response), OptionalDouble.empty(), OptionalLong.empty(), OptionalDouble.empty(), OptionalDouble.empty()));
                continue;
            }
            V member = this.marshaller.decode(this.typeOfValue, response.get(0));
            if (withCoordinates && withDistance && withHash) {
                double dist = response.get(1).toDouble();
                hash = response.get(2).toLong();
                double longitude = response.get(3).get(0).toDouble();
                double latitude2 = response.get(3).get(1).toDouble();
                list.add(new GeoValue<V>(member, OptionalDouble.of(dist), OptionalLong.of(hash), OptionalDouble.of(longitude), OptionalDouble.of(latitude2)));
                continue;
            }
            if (withCoordinates && withDistance) {
                double dist = response.get(1).toDouble();
                double longitude = response.get(2).get(0).toDouble();
                latitude = response.get(2).get(1).toDouble();
                list.add(new GeoValue<V>(member, OptionalDouble.of(dist), OptionalLong.empty(), OptionalDouble.of(longitude), OptionalDouble.of(latitude)));
                continue;
            }
            if (withCoordinates && withHash) {
                long hash2 = response.get(1).toLong();
                double longitude = response.get(2).get(0).toDouble();
                latitude = response.get(2).get(1).toDouble();
                list.add(new GeoValue<V>(member, OptionalDouble.empty(), OptionalLong.of(hash2), OptionalDouble.of(longitude), OptionalDouble.of(latitude)));
                continue;
            }
            if (withCoordinates) {
                double longitude = response.get(1).get(0).toDouble();
                double latitude3 = response.get(1).get(1).toDouble();
                list.add(new GeoValue<V>(member, OptionalDouble.empty(), OptionalLong.empty(), OptionalDouble.of(longitude), OptionalDouble.of(latitude3)));
                continue;
            }
            if (withDistance && !withHash) {
                double dist = response.get(1).toDouble();
                list.add(new GeoValue<V>(member, OptionalDouble.of(dist), OptionalLong.empty(), OptionalDouble.empty(), OptionalDouble.empty()));
                continue;
            }
            if (!withDistance) {
                long hash3 = response.get(1).toLong();
                list.add(new GeoValue<V>(member, OptionalDouble.empty(), OptionalLong.of(hash3), OptionalDouble.empty(), OptionalDouble.empty()));
                continue;
            }
            double dist = response.get(1).toDouble();
            hash = response.get(2).toLong();
            list.add(new GeoValue<V>(member, OptionalDouble.of(dist), OptionalLong.of(hash), OptionalDouble.empty(), OptionalDouble.empty()));
        }
        return list;
    }
}

