/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.ScanArgs;
import io.quarkus.redis.datasource.SortArgs;
import io.quarkus.redis.datasource.set.ReactiveSetCommands;
import io.quarkus.redis.datasource.set.SScanCursor;
import io.quarkus.redis.datasource.set.SetCommands;
import io.quarkus.redis.runtime.datasource.SScanBlockingCursorImpl;
import java.time.Duration;
import java.util.List;
import java.util.Set;

public class BlockingSetCommandsImpl<K, V>
implements SetCommands<K, V> {
    private final ReactiveSetCommands<K, V> reactive;
    private final Duration timeout;

    public BlockingSetCommandsImpl(ReactiveSetCommands<K, V> reactive, Duration timeout) {
        this.reactive = reactive;
        this.timeout = timeout;
    }

    @Override
    public int sadd(K key, V ... values) {
        return (Integer)this.reactive.sadd(key, values).await().atMost(this.timeout);
    }

    @Override
    public long scard(K key) {
        return (Long)this.reactive.scard(key).await().atMost(this.timeout);
    }

    @Override
    public Set<V> sdiff(K ... keys) {
        return (Set)this.reactive.sdiff(keys).await().atMost(this.timeout);
    }

    @Override
    public long sdiffstore(K destination, K ... keys) {
        return (Long)this.reactive.sdiffstore(destination, keys).await().atMost(this.timeout);
    }

    @Override
    public Set<V> sinter(K ... keys) {
        return (Set)this.reactive.sinter(keys).await().atMost(this.timeout);
    }

    @Override
    public long sintercard(K ... keys) {
        return (Long)this.reactive.sintercard(keys).await().atMost(this.timeout);
    }

    @Override
    public long sintercard(int limit, K ... keys) {
        return (Long)this.reactive.sintercard(limit, keys).await().atMost(this.timeout);
    }

    @Override
    public long sinterstore(K destination, K ... keys) {
        return (Long)this.reactive.sinterstore(destination, keys).await().atMost(this.timeout);
    }

    @Override
    public boolean sismember(K key, V member) {
        return (Boolean)this.reactive.sismember(key, member).await().atMost(this.timeout);
    }

    @Override
    public Set<V> smembers(K key) {
        return (Set)this.reactive.smembers(key).await().atMost(this.timeout);
    }

    @Override
    public List<Boolean> smismember(K key, V ... members) {
        return (List)this.reactive.smismember(key, members).await().atMost(this.timeout);
    }

    @Override
    public boolean smove(K source, K destination, V member) {
        return (Boolean)this.reactive.smove(source, destination, member).await().atMost(this.timeout);
    }

    @Override
    public V spop(K key) {
        return (V)this.reactive.spop(key).await().atMost(this.timeout);
    }

    @Override
    public Set<V> spop(K key, int count) {
        return (Set)this.reactive.spop(key, count).await().atMost(this.timeout);
    }

    @Override
    public V srandmember(K key) {
        return (V)this.reactive.srandmember(key).await().atMost(this.timeout);
    }

    @Override
    public List<V> srandmember(K key, int count) {
        return (List)this.reactive.srandmember(key, count).await().atMost(this.timeout);
    }

    @Override
    public int srem(K key, V ... members) {
        return (Integer)this.reactive.srem(key, members).await().atMost(this.timeout);
    }

    @Override
    public Set<V> sunion(K ... keys) {
        return (Set)this.reactive.sunion(keys).await().atMost(this.timeout);
    }

    @Override
    public long sunionstore(K destination, K ... keys) {
        return (Long)this.reactive.sunionstore(destination, keys).await().atMost(this.timeout);
    }

    @Override
    public SScanCursor<V> sscan(K key) {
        return new SScanBlockingCursorImpl<V>(this.reactive.sscan(key), this.timeout);
    }

    @Override
    public SScanCursor<V> sscan(K key, ScanArgs scanArgs) {
        return new SScanBlockingCursorImpl<V>(this.reactive.sscan(key, scanArgs), this.timeout);
    }

    @Override
    public List<V> sort(K key) {
        return (List)this.reactive.sort(key).await().atMost(this.timeout);
    }

    @Override
    public List<V> sort(K key, SortArgs sortArguments) {
        return (List)this.reactive.sort(key, sortArguments).await().atMost(this.timeout);
    }

    @Override
    public long sortAndStore(K key, K destination, SortArgs sortArguments) {
        return (Long)this.reactive.sortAndStore(key, destination, sortArguments).await().atMost(this.timeout);
    }

    @Override
    public long sortAndStore(K key, K destination) {
        return (Long)this.reactive.sortAndStore(key, destination).await().atMost(this.timeout);
    }
}

