/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.codecs;

import io.quarkus.redis.datasource.codecs.Codec;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import java.nio.charset.StandardCharsets;

public class Codecs {
    private Codecs() {
    }

    public static <T> Codec<T> getDefaultCodecFor(Class<T> clazz) {
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return DoubleCodec.INSTANCE;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return IntegerCodec.INSTANCE;
        }
        if (clazz.equals(String.class)) {
            return StringCodec.INSTANCE;
        }
        return new JsonCodec<T>(clazz);
    }

    public static class IntegerCodec
    implements Codec<Integer> {
        public static IntegerCodec INSTANCE = new IntegerCodec();

        private IntegerCodec() {
        }

        @Override
        public byte[] encode(Integer item) {
            if (item == null) {
                return null;
            }
            return Integer.toString(item).getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public Integer decode(byte[] item) {
            if (item == null) {
                return 0;
            }
            return Integer.parseInt(new String(item, StandardCharsets.UTF_8));
        }
    }

    public static class DoubleCodec
    implements Codec<Double> {
        public static DoubleCodec INSTANCE = new DoubleCodec();

        private DoubleCodec() {
        }

        @Override
        public byte[] encode(Double item) {
            if (item == null) {
                return null;
            }
            return Double.toString(item).getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public Double decode(byte[] item) {
            if (item == null) {
                return 0.0;
            }
            return Double.parseDouble(new String(item, StandardCharsets.UTF_8));
        }
    }

    public static class StringCodec
    implements Codec<String> {
        public static StringCodec INSTANCE = new StringCodec();

        private StringCodec() {
        }

        @Override
        public byte[] encode(String item) {
            return item.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public String decode(byte[] item) {
            return new String(item, StandardCharsets.UTF_8);
        }
    }

    public static class JsonCodec<T>
    implements Codec<T> {
        private final Class<T> clazz;

        public JsonCodec(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public byte[] encode(T item) {
            return Json.encodeToBuffer(item).getBytes();
        }

        @Override
        public T decode(byte[] payload) {
            return (T)Json.decodeValue((Buffer)Buffer.buffer((byte[])payload), this.clazz);
        }
    }
}

