/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.SortArgs;
import io.quarkus.redis.datasource.list.KeyValue;
import io.quarkus.redis.datasource.list.LPosArgs;
import io.quarkus.redis.datasource.list.ListCommands;
import io.quarkus.redis.datasource.list.Position;
import io.quarkus.redis.datasource.list.ReactiveListCommands;
import java.time.Duration;
import java.util.List;
import java.util.OptionalLong;

public class BlockingListCommandsImpl<K, V>
implements ListCommands<K, V> {
    private final ReactiveListCommands<K, V> reactive;
    private final Duration timeout;

    public BlockingListCommandsImpl(ReactiveListCommands<K, V> reactive, Duration timeout) {
        this.reactive = reactive;
        this.timeout = timeout;
    }

    @Override
    public V blmove(K source, K destination, Position positionInSource, Position positionInDest, Duration timeout) {
        return (V)this.reactive.blmove(source, destination, positionInSource, positionInDest, timeout).await().atMost(this.timeout);
    }

    @Override
    public KeyValue<K, V> blmpop(Duration timeout, Position position, K ... keys) {
        return (KeyValue)this.reactive.blmpop(timeout, position, keys).await().atMost(this.timeout);
    }

    @Override
    public List<KeyValue<K, V>> blmpop(Duration timeout, Position position, int count, K ... keys) {
        return (List)this.reactive.blmpop(timeout, position, count, keys).await().atMost(this.timeout);
    }

    @Override
    public KeyValue<K, V> blpop(Duration timeout, K ... keys) {
        return (KeyValue)this.reactive.blpop(timeout, keys).await().atMost(this.timeout);
    }

    @Override
    public KeyValue<K, V> brpop(Duration timeout, K ... keys) {
        return (KeyValue)this.reactive.brpop(timeout, keys).await().atMost(this.timeout);
    }

    @Override
    public V brpoplpush(Duration timeout, K source, K destination) {
        return (V)this.reactive.brpoplpush(timeout, source, destination).await().atMost(this.timeout);
    }

    @Override
    public V lindex(K key, long index) {
        return (V)this.reactive.lindex(key, index).await().atMost(this.timeout);
    }

    @Override
    public long linsertBeforePivot(K key, V pivot, V element) {
        return (Long)this.reactive.linsertBeforePivot(key, pivot, element).await().atMost(this.timeout);
    }

    @Override
    public long linsertAfterPivot(K key, V pivot, V element) {
        return (Long)this.reactive.linsertAfterPivot(key, pivot, element).await().atMost(this.timeout);
    }

    @Override
    public long llen(K key) {
        return (Long)this.reactive.llen(key).await().atMost(this.timeout);
    }

    @Override
    public V lmove(K source, K destination, Position positionInSource, Position positionInDestination) {
        return (V)this.reactive.lmove(source, destination, positionInSource, positionInDestination).await().atMost(this.timeout);
    }

    @Override
    public KeyValue<K, V> lmpop(Position position, K ... keys) {
        return (KeyValue)this.reactive.lmpop(position, keys).await().atMost(this.timeout);
    }

    @Override
    public List<KeyValue<K, V>> lmpop(Position position, int count, K ... keys) {
        return (List)this.reactive.lmpop(position, count, keys).await().atMost(this.timeout);
    }

    @Override
    public V lpop(K key) {
        return (V)this.reactive.lpop(key).await().atMost(this.timeout);
    }

    @Override
    public List<V> lpop(K key, int count) {
        return (List)this.reactive.lpop(key, count).await().atMost(this.timeout);
    }

    @Override
    public OptionalLong lpos(K key, V element) {
        return (OptionalLong)this.reactive.lpos(key, element).map(l -> {
            if (l == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(l);
        }).await().atMost(this.timeout);
    }

    @Override
    public OptionalLong lpos(K key, V element, LPosArgs args) {
        return (OptionalLong)this.reactive.lpos(key, element, args).map(l -> {
            if (l == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(l);
        }).await().atMost(this.timeout);
    }

    @Override
    public List<Long> lpos(K key, V element, int count) {
        return (List)this.reactive.lpos(key, element, count).await().atMost(this.timeout);
    }

    @Override
    public List<Long> lpos(K key, V element, int count, LPosArgs args) {
        return (List)this.reactive.lpos(key, element, count, args).await().atMost(this.timeout);
    }

    @Override
    public long lpush(K key, V ... elements) {
        return (Long)this.reactive.lpush(key, elements).await().atMost(this.timeout);
    }

    @Override
    public long lpushx(K key, V ... elements) {
        return (Long)this.reactive.lpushx(key, elements).await().atMost(this.timeout);
    }

    @Override
    public List<V> lrange(K key, long start, long stop) {
        return (List)this.reactive.lrange(key, start, stop).await().atMost(this.timeout);
    }

    @Override
    public long lrem(K key, long count, V element) {
        return (Long)this.reactive.lrem(key, count, element).await().atMost(this.timeout);
    }

    @Override
    public void lset(K key, long index, V element) {
        this.reactive.lset(key, index, element).await().atMost(this.timeout);
    }

    @Override
    public void ltrim(K key, long start, long stop) {
        this.reactive.ltrim(key, start, stop).await().atMost(this.timeout);
    }

    @Override
    public V rpop(K key) {
        return (V)this.reactive.rpop(key).await().atMost(this.timeout);
    }

    @Override
    public List<V> rpop(K key, int count) {
        return (List)this.reactive.rpop(key, count).await().atMost(this.timeout);
    }

    @Override
    public V rpoplpush(K source, K destination) {
        return (V)this.reactive.rpoplpush(source, destination).await().atMost(this.timeout);
    }

    @Override
    public long rpush(K key, V ... values) {
        return (Long)this.reactive.rpush(key, values).await().atMost(this.timeout);
    }

    @Override
    public long rpushx(K key, V ... values) {
        return (Long)this.reactive.rpushx(key, values).await().atMost(this.timeout);
    }

    @Override
    public List<V> sort(K key) {
        return (List)this.reactive.sort(key).await().atMost(this.timeout);
    }

    @Override
    public List<V> sort(K key, SortArgs sortArguments) {
        return (List)this.reactive.sort(key, sortArguments).await().atMost(this.timeout);
    }

    @Override
    public long sortAndStore(K key, K destination, SortArgs sortArguments) {
        return (Long)this.reactive.sortAndStore(key, destination, sortArguments).await().atMost(this.timeout);
    }

    @Override
    public long sortAndStore(K key, K destination) {
        return (Long)this.reactive.sortAndStore(key, destination).await().atMost(this.timeout);
    }
}

