/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.bitmap.BitMapCommands;
import io.quarkus.redis.datasource.geo.GeoCommands;
import io.quarkus.redis.datasource.hash.HashCommands;
import io.quarkus.redis.datasource.hyperloglog.HyperLogLogCommands;
import io.quarkus.redis.datasource.keys.KeyCommands;
import io.quarkus.redis.datasource.list.ListCommands;
import io.quarkus.redis.datasource.pubsub.PubSubCommands;
import io.quarkus.redis.datasource.set.SetCommands;
import io.quarkus.redis.datasource.sortedset.SortedSetCommands;
import io.quarkus.redis.datasource.string.StringCommands;
import io.quarkus.redis.datasource.transactions.OptimisticLockingTransactionResult;
import io.quarkus.redis.datasource.transactions.TransactionResult;
import io.quarkus.redis.datasource.transactions.TransactionalRedisDataSource;
import io.quarkus.redis.runtime.datasource.BlockingBitmapCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingGeoCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingHashCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingHyperLogLogCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingKeyCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingListCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingPubSubCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingSetCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingSortedSetCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingStringCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingTransactionalRedisDataSourceImpl;
import io.quarkus.redis.runtime.datasource.ReactiveRedisDataSourceImpl;
import io.quarkus.redis.runtime.datasource.ReactiveTransactionalRedisDataSourceImpl;
import io.quarkus.redis.runtime.datasource.TransactionHolder;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.redis.client.Redis;
import io.vertx.mutiny.redis.client.RedisAPI;
import io.vertx.mutiny.redis.client.RedisConnection;
import io.vertx.mutiny.redis.client.Request;
import io.vertx.mutiny.redis.client.Response;
import io.vertx.redis.client.Command;
import java.time.Duration;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class BlockingRedisDataSourceImpl
implements RedisDataSource {
    private final Duration timeout;
    final ReactiveRedisDataSourceImpl reactive;
    final RedisConnection connection;

    public BlockingRedisDataSourceImpl(Vertx vertx, Redis redis, RedisAPI api, Duration timeout) {
        this(new ReactiveRedisDataSourceImpl(vertx, redis, api), timeout);
    }

    public BlockingRedisDataSourceImpl(ReactiveRedisDataSourceImpl reactive, Duration timeout) {
        this.reactive = reactive;
        this.timeout = timeout;
        this.connection = reactive.connection;
    }

    public BlockingRedisDataSourceImpl(Vertx vertx, Redis redis, RedisConnection connection, Duration timeout) {
        this(new ReactiveRedisDataSourceImpl(vertx, redis, connection), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionResult withTransaction(Consumer<TransactionalRedisDataSource> ds) {
        RedisConnection connection = (RedisConnection)this.reactive.redis.connect().await().atMost(this.timeout);
        ReactiveRedisDataSourceImpl dataSource = new ReactiveRedisDataSourceImpl(this.reactive.getVertx(), this.reactive.redis, connection);
        TransactionHolder th = new TransactionHolder();
        BlockingTransactionalRedisDataSourceImpl source = new BlockingTransactionalRedisDataSourceImpl(new ReactiveTransactionalRedisDataSourceImpl(dataSource, th), this.timeout);
        try {
            connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.MULTI)).await().atMost(this.timeout);
            ds.accept(source);
            if (!source.discarded()) {
                Response response = (Response)connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.EXEC)).await().atMost(this.timeout);
                TransactionResult transactionResult = ReactiveRedisDataSourceImpl.toTransactionResult(response, th);
                return transactionResult;
            }
            TransactionResult transactionResult = ReactiveRedisDataSourceImpl.toTransactionResult(null, th);
            return transactionResult;
        }
        finally {
            connection.closeAndAwait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionResult withTransaction(Consumer<TransactionalRedisDataSource> ds, String ... watchedKeys) {
        RedisConnection connection = (RedisConnection)this.reactive.redis.connect().await().atMost(this.timeout);
        ReactiveRedisDataSourceImpl dataSource = new ReactiveRedisDataSourceImpl(this.reactive.getVertx(), this.reactive.redis, connection);
        TransactionHolder th = new TransactionHolder();
        BlockingTransactionalRedisDataSourceImpl source = new BlockingTransactionalRedisDataSourceImpl(new ReactiveTransactionalRedisDataSourceImpl(dataSource, th), this.timeout);
        try {
            Request cmd = Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.WATCH);
            for (String watchedKey : watchedKeys) {
                cmd.arg(watchedKey);
            }
            connection.send(cmd).await().atMost(this.timeout);
            connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.MULTI)).await().atMost(this.timeout);
            ds.accept(source);
            if (!source.discarded()) {
                Response response = (Response)connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.EXEC)).await().atMost(this.timeout);
                TransactionResult transactionResult = ReactiveRedisDataSourceImpl.toTransactionResult(response, th);
                return transactionResult;
            }
            TransactionResult transactionResult = ReactiveRedisDataSourceImpl.toTransactionResult(null, th);
            return transactionResult;
        }
        finally {
            connection.closeAndAwait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <I> OptimisticLockingTransactionResult<I> withTransaction(Function<RedisDataSource, I> preTxBlock, BiConsumer<I, TransactionalRedisDataSource> tx, String ... watchedKeys) {
        RedisConnection connection = (RedisConnection)this.reactive.redis.connect().await().atMost(this.timeout);
        ReactiveRedisDataSourceImpl dataSource = new ReactiveRedisDataSourceImpl(this.reactive.getVertx(), this.reactive.redis, connection);
        TransactionHolder th = new TransactionHolder();
        BlockingTransactionalRedisDataSourceImpl source = new BlockingTransactionalRedisDataSourceImpl(new ReactiveTransactionalRedisDataSourceImpl(dataSource, th), this.timeout);
        try {
            Request cmd = Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.WATCH);
            for (String watchedKey : watchedKeys) {
                cmd.arg(watchedKey);
            }
            connection.send(cmd).await().atMost(this.timeout);
            I input = preTxBlock.apply(new BlockingRedisDataSourceImpl(this.reactive.getVertx(), this.reactive.redis, connection, this.timeout));
            connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.MULTI)).await().atMost(this.timeout);
            tx.accept(input, source);
            if (!source.discarded()) {
                Response response = (Response)connection.send(Request.cmd((io.vertx.mutiny.redis.client.Command)io.vertx.mutiny.redis.client.Command.EXEC)).await().atMost(this.timeout);
                OptimisticLockingTransactionResult<I> optimisticLockingTransactionResult = ReactiveRedisDataSourceImpl.toTransactionResult(response, input, th);
                return optimisticLockingTransactionResult;
            }
            OptimisticLockingTransactionResult<I> optimisticLockingTransactionResult = ReactiveRedisDataSourceImpl.toTransactionResult(null, input, th);
            return optimisticLockingTransactionResult;
        }
        finally {
            connection.closeAndAwait();
        }
    }

    @Override
    public void withConnection(Consumer<RedisDataSource> consumer) {
        if (this.connection != null) {
            consumer.accept(this);
            return;
        }
        BlockingRedisDataSourceImpl source = (BlockingRedisDataSourceImpl)this.reactive.redis.connect().map(rc -> new BlockingRedisDataSourceImpl(this.reactive.getVertx(), this.reactive.redis, (RedisConnection)rc, this.timeout)).await().atMost(this.timeout);
        try {
            consumer.accept(source);
        }
        finally {
            source.connection.closeAndAwait();
        }
    }

    @Override
    public void select(long index) {
        this.reactive.select(index).await().atMost(this.timeout);
    }

    @Override
    public void flushall() {
        this.reactive.flushall().await().atMost(this.timeout);
    }

    public <K1, F, V1> HashCommands<K1, F, V1> hash(Class<K1> redisKeyType, Class<F> typeOfField, Class<V1> typeOfValue) {
        return new BlockingHashCommandsImpl<K1, F, V1>(this.reactive.hash(redisKeyType, typeOfField, typeOfValue), this.timeout);
    }

    public <K1, V1> GeoCommands<K1, V1> geo(Class<K1> redisKeyType, Class<V1> memberType) {
        return new BlockingGeoCommandsImpl<K1, V1>(this.reactive.geo(redisKeyType, memberType), this.timeout);
    }

    public <K1> KeyCommands<K1> key(Class<K1> redisKeyType) {
        return new BlockingKeyCommandsImpl<K1>(this.reactive.key(redisKeyType), this.timeout);
    }

    public <K1, V1> SortedSetCommands<K1, V1> sortedSet(Class<K1> redisKeyType, Class<V1> valueType) {
        return new BlockingSortedSetCommandsImpl<K1, V1>(this.reactive.sortedSet(redisKeyType, valueType), this.timeout);
    }

    public <K1, V1> StringCommands<K1, V1> string(Class<K1> redisKeyType, Class<V1> valueType) {
        return new BlockingStringCommandsImpl<K1, V1>(this.reactive.string(redisKeyType, valueType), this.timeout);
    }

    public <K1, V1> SetCommands<K1, V1> set(Class<K1> redisKeyType, Class<V1> memberType) {
        return new BlockingSetCommandsImpl<K1, V1>(this.reactive.set(redisKeyType, memberType), this.timeout);
    }

    public <K1, V1> ListCommands<K1, V1> list(Class<K1> redisKeyType, Class<V1> memberType) {
        return new BlockingListCommandsImpl<K1, V1>(this.reactive.list(redisKeyType, memberType), this.timeout);
    }

    public <K1, V1> HyperLogLogCommands<K1, V1> hyperloglog(Class<K1> redisKeyType, Class<V1> memberType) {
        return new BlockingHyperLogLogCommandsImpl<K1, V1>(this.reactive.hyperloglog(redisKeyType, memberType), this.timeout);
    }

    @Override
    public <K> BitMapCommands<K> bitmap(Class<K> redisKeyType) {
        return new BlockingBitmapCommandsImpl<K>(this.reactive.bitmap(redisKeyType), this.timeout);
    }

    @Override
    public <V> PubSubCommands<V> pubsub(Class<V> messageType) {
        return new BlockingPubSubCommandsImpl<V>(this.reactive.pubsub(messageType), this.timeout);
    }

    @Override
    public Response execute(String command, String ... args) {
        return (Response)this.reactive.execute(command, args).await().atMost(this.timeout);
    }

    @Override
    public Response execute(io.vertx.mutiny.redis.client.Command command, String ... args) {
        return (Response)this.reactive.execute(command, args).await().atMost(this.timeout);
    }

    @Override
    public Response execute(Command command, String ... args) {
        return (Response)this.reactive.execute(command, args).await().atMost(this.timeout);
    }

    @Override
    public ReactiveRedisDataSource getReactive() {
        return this.reactive;
    }
}

