/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.bitmap.TransactionalBitMapCommands;
import io.quarkus.redis.datasource.geo.TransactionalGeoCommands;
import io.quarkus.redis.datasource.hash.TransactionalHashCommands;
import io.quarkus.redis.datasource.hyperloglog.TransactionalHyperLogLogCommands;
import io.quarkus.redis.datasource.keys.TransactionalKeyCommands;
import io.quarkus.redis.datasource.list.TransactionalListCommands;
import io.quarkus.redis.datasource.set.TransactionalSetCommands;
import io.quarkus.redis.datasource.sortedset.TransactionalSortedSetCommands;
import io.quarkus.redis.datasource.string.TransactionalStringCommands;
import io.quarkus.redis.datasource.transactions.ReactiveTransactionalRedisDataSource;
import io.quarkus.redis.datasource.transactions.TransactionalRedisDataSource;
import io.quarkus.redis.datasource.value.TransactionalValueCommands;
import io.quarkus.redis.runtime.datasource.BlockingTransactionalBitMapCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingTransactionalGeoCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingTransactionalHashCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingTransactionalHyperLogLogCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingTransactionalKeyCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingTransactionalListCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingTransactionalSetCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingTransactionalSortedSetCommandsImpl;
import io.quarkus.redis.runtime.datasource.BlockingTransactionalStringCommandsImpl;
import io.vertx.redis.client.Command;
import java.time.Duration;

public class BlockingTransactionalRedisDataSourceImpl
implements TransactionalRedisDataSource {
    private final ReactiveTransactionalRedisDataSource reactive;
    private final Duration timeout;

    public BlockingTransactionalRedisDataSourceImpl(ReactiveTransactionalRedisDataSource api, Duration timeout) {
        this.reactive = api;
        this.timeout = timeout;
    }

    @Override
    public void discard() {
        this.reactive.discard().await().atMost(this.timeout);
    }

    @Override
    public boolean discarded() {
        return this.reactive.discarded();
    }

    @Override
    public <K, F, V> TransactionalHashCommands<K, F, V> hash(Class<K> redisKeyType, Class<F> typeOfField, Class<V> typeOfValue) {
        return new BlockingTransactionalHashCommandsImpl<K, F, V>(this, this.reactive.hash(redisKeyType, typeOfField, typeOfValue), this.timeout);
    }

    @Override
    public <K, V> TransactionalGeoCommands<K, V> geo(Class<K> redisKeyType, Class<V> memberType) {
        return new BlockingTransactionalGeoCommandsImpl<K, V>(this, this.reactive.geo(redisKeyType, memberType), this.timeout);
    }

    @Override
    public <K> TransactionalKeyCommands<K> key(Class<K> redisKeyType) {
        return new BlockingTransactionalKeyCommandsImpl<K>(this, this.reactive.key(redisKeyType), this.timeout);
    }

    @Override
    public <K, V> TransactionalSetCommands<K, V> set(Class<K> redisKeyType, Class<V> memberType) {
        return new BlockingTransactionalSetCommandsImpl<K, V>(this, this.reactive.set(redisKeyType, memberType), this.timeout);
    }

    @Override
    public <K, V> TransactionalSortedSetCommands<K, V> sortedSet(Class<K> redisKeyType, Class<V> valueType) {
        return new BlockingTransactionalSortedSetCommandsImpl<K, V>(this, this.reactive.sortedSet(redisKeyType, valueType), this.timeout);
    }

    @Override
    public <K, V> TransactionalStringCommands<K, V> string(Class<K> redisKeyType, Class<V> valueType) {
        return new BlockingTransactionalStringCommandsImpl<K, V>(this, this.reactive.value(redisKeyType, valueType), this.timeout);
    }

    @Override
    public <K, V> TransactionalValueCommands<K, V> value(Class<K> redisKeyType, Class<V> valueType) {
        return new BlockingTransactionalStringCommandsImpl<K, V>(this, this.reactive.value(redisKeyType, valueType), this.timeout);
    }

    @Override
    public <K, V> TransactionalListCommands<K, V> list(Class<K> redisKeyType, Class<V> memberType) {
        return new BlockingTransactionalListCommandsImpl<K, V>(this, this.reactive.list(redisKeyType, memberType), this.timeout);
    }

    @Override
    public <K, V> TransactionalHyperLogLogCommands<K, V> hyperloglog(Class<K> redisKeyType, Class<V> memberType) {
        return new BlockingTransactionalHyperLogLogCommandsImpl<K, V>(this, this.reactive.hyperloglog(redisKeyType, memberType), this.timeout);
    }

    @Override
    public <K> TransactionalBitMapCommands<K> bitmap(Class<K> redisKeyType) {
        return new BlockingTransactionalBitMapCommandsImpl<K>(this, this.reactive.bitmap(redisKeyType), this.timeout);
    }

    @Override
    public void execute(String command, String ... args) {
        this.reactive.execute(command, args).await().atMost(this.timeout);
    }

    @Override
    public void execute(io.vertx.mutiny.redis.client.Command command, String ... args) {
        this.reactive.execute(command, args).await().atMost(this.timeout);
    }

    @Override
    public void execute(Command command, String ... args) {
        this.reactive.execute(command, args).await().atMost(this.timeout);
    }
}

