/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.search.AggregateArgs;
import io.quarkus.redis.datasource.search.CreateArgs;
import io.quarkus.redis.datasource.search.IndexedField;
import io.quarkus.redis.datasource.search.QueryArgs;
import io.quarkus.redis.datasource.search.SpellCheckArgs;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;

public class AbstractSearchCommands<K>
extends AbstractRedisCommands {
    AbstractSearchCommands(RedisCommandExecutor redis, Class<K> k) {
        super(redis, new Marshaller(k));
    }

    Uni<Response> _ft_list() {
        RedisCommand cmd = RedisCommand.of(Command.FT__LIST);
        return this.execute(cmd);
    }

    Uni<Response> _ftAggregate(String indexName, String query, AggregateArgs args) {
        Validation.notNullOrBlank(indexName, "indexName");
        Validation.notNullOrBlank(query, "query");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.FT_AGGREGATE).put(indexName).put(query).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _ftAggregate(String indexName, String query) {
        Validation.notNullOrBlank(indexName, "indexName");
        Validation.notNullOrBlank(query, "query");
        RedisCommand cmd = RedisCommand.of(Command.FT_AGGREGATE).put(indexName).put(query);
        return this.execute(cmd);
    }

    Uni<Response> _ftAliasAdd(String alias, String index) {
        Validation.notNullOrBlank(alias, "alias");
        Validation.notNullOrBlank(index, "index");
        RedisCommand cmd = RedisCommand.of(Command.FT_ALIASADD).put(alias).put(index);
        return this.execute(cmd);
    }

    Uni<Response> _ftAliasDel(String alias) {
        Validation.notNullOrBlank(alias, "alias");
        RedisCommand cmd = RedisCommand.of(Command.FT_ALIASDEL).put(alias);
        return this.execute(cmd);
    }

    Uni<Response> _ftAliasUpdate(String alias, String index) {
        Validation.notNullOrBlank(alias, "alias");
        Validation.notNullOrBlank(index, "index");
        RedisCommand cmd = RedisCommand.of(Command.FT_ALIASUPDATE).put(alias).put(index);
        return this.execute(cmd);
    }

    Uni<Response> _ftAlter(String index, IndexedField field, boolean skipInitialScan) {
        Validation.notNullOrBlank(index, "index");
        ParameterValidation.nonNull((Object)field, (String)"field");
        RedisCommand cmd = RedisCommand.of(Command.FT_ALTER).put(index).putFlag(skipInitialScan, "SKIPINITIALSCAN").put("SCHEMA").put("ADD").putArgs(field);
        return this.execute(cmd);
    }

    Uni<Response> _ftAlter(String index, IndexedField field) {
        return this._ftAlter(index, field, false);
    }

    Uni<Response> _ftCreate(String index, CreateArgs args) {
        Validation.notNullOrBlank(index, "index");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.FT_CREATE).put(index).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _ftCursorDel(String index, long cursor) {
        Validation.notNullOrBlank(index, "index");
        ParameterValidation.positiveOrZero((long)cursor, (String)"cursor");
        RedisCommand cmd = RedisCommand.of(Command.FT_CURSOR).put("DEL").put(index).put(cursor);
        return this.execute(cmd);
    }

    Uni<Response> _ftCursorRead(String index, long cursor) {
        Validation.notNullOrBlank(index, "index");
        ParameterValidation.positiveOrZero((long)cursor, (String)"cursor");
        RedisCommand cmd = RedisCommand.of(Command.FT_CURSOR).put("READ").put(index).put(cursor);
        return this.execute(cmd);
    }

    Uni<Response> _ftCursorRead(String index, long cursor, int count) {
        Validation.notNullOrBlank(index, "index");
        ParameterValidation.positiveOrZero((long)cursor, (String)"cursor");
        ParameterValidation.positive((int)count, (String)"count");
        RedisCommand cmd = RedisCommand.of(Command.FT_CURSOR).put("READ").put(index).put(cursor).put("COUNT").put(count);
        return this.execute(cmd);
    }

    Uni<Response> _ftDropIndex(String index) {
        Validation.notNullOrBlank(index, "index");
        RedisCommand cmd = RedisCommand.of(Command.FT_DROPINDEX).put(index);
        return this.execute(cmd);
    }

    Uni<Response> _ftDropIndex(String index, boolean dd) {
        Validation.notNullOrBlank(index, "index");
        RedisCommand cmd = RedisCommand.of(Command.FT_DROPINDEX).put(index).putFlag(dd, "DD");
        return this.execute(cmd);
    }

    Uni<Response> _ftDictAdd(String dict, String ... words) {
        Validation.notNullOrBlank(dict, "dict");
        Validation.notNullOrEmpty(words, "words");
        ParameterValidation.doesNotContainNull((Object[])words, (String)"words");
        RedisCommand cmd = RedisCommand.of(Command.FT_DICTADD).put(dict).putAll(words);
        return this.execute(cmd);
    }

    Uni<Response> _ftDictDel(String dict, String ... words) {
        Validation.notNullOrBlank(dict, "dict");
        Validation.notNullOrEmpty(words, "words");
        ParameterValidation.doesNotContainNull((Object[])words, (String)"words");
        RedisCommand cmd = RedisCommand.of(Command.FT_DICTDEL).put(dict).putAll(words);
        return this.execute(cmd);
    }

    Uni<Response> _ftDictDump(String dict) {
        Validation.notNullOrBlank(dict, "dict");
        RedisCommand cmd = RedisCommand.of(Command.FT_DICTDUMP).put(dict);
        return this.execute(cmd);
    }

    Uni<Response> _ftSearch(String index, String query, QueryArgs args) {
        Validation.notNullOrBlank(index, "index");
        Validation.notNullOrBlank(query, "query");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.FT_SEARCH).put(index).put(query).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _ftSearch(String index, String query) {
        Validation.notNullOrBlank(index, "index");
        Validation.notNullOrBlank(query, "query");
        RedisCommand cmd = RedisCommand.of(Command.FT_SEARCH).put(index).put(query);
        return this.execute(cmd);
    }

    Uni<Response> _ftSpellCheck(String index, String query) {
        Validation.notNullOrBlank(index, "index");
        Validation.notNullOrBlank(query, "query");
        RedisCommand cmd = RedisCommand.of(Command.FT_SPELLCHECK).put(index).put(query);
        return this.execute(cmd);
    }

    Uni<Response> _ftSpellCheck(String index, String query, SpellCheckArgs args) {
        Validation.notNullOrBlank(index, "index");
        Validation.notNullOrBlank(query, "query");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.FT_SPELLCHECK).put(index).put(query).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _ftSynDump(String index) {
        Validation.notNullOrBlank(index, "index");
        RedisCommand cmd = RedisCommand.of(Command.FT_SYNDUMP).put(index);
        return this.execute(cmd);
    }

    Uni<Response> _ftSynUpdate(String index, String groupId, String ... words) {
        Validation.notNullOrBlank(index, "index");
        Validation.notNullOrBlank(groupId, "groupId");
        ParameterValidation.doesNotContainNull((Object[])words, (String)"words");
        Validation.notNullOrEmpty(words, "words");
        RedisCommand cmd = RedisCommand.of(Command.FT_SYNUPDATE).put(index).put(groupId).putAll(words);
        return this.execute(cmd);
    }

    Uni<Response> _ftSynUpdate(String index, String groupId, boolean skipInitialScan, String ... words) {
        Validation.notNullOrBlank(index, "index");
        Validation.notNullOrBlank(groupId, "groupId");
        ParameterValidation.doesNotContainNull((Object[])words, (String)"words");
        Validation.notNullOrEmpty(words, "words");
        RedisCommand cmd = RedisCommand.of(Command.FT_SYNUPDATE).put(index).put(groupId).putFlag(skipInitialScan, "SKIPINITIALSCAN").putAll(words);
        return this.execute(cmd);
    }

    Uni<Response> _ftTagVals(String index, String field) {
        Validation.notNullOrBlank(index, "index");
        Validation.notNullOrBlank(field, "field");
        RedisCommand cmd = RedisCommand.of(Command.FT_TAGVALS).put(index).put(field);
        return this.execute(cmd);
    }
}

